/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.analyze;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.DefaultModuleConfiguration;
import org.jetbrains.jet.lang.ModuleConfiguration;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class JsConfiguration
implements ModuleConfiguration {
    @NotNull
    public static final List<ImportPath> DEFAULT_IMPORT_PATHS = ImmutableList.of(new ImportPath("js.*"), new ImportPath("java.lang.*"), new ImportPath(KotlinBuiltIns.getInstance().getBuiltInsPackageFqName(), true), new ImportPath("kotlin.*"));
    @Nullable
    private final BindingContext preanalyzedContext;

    JsConfiguration(@Nullable BindingContext preanalyzedContext) {
        this.preanalyzedContext = preanalyzedContext;
    }

    @Override
    public void extendNamespaceScope(@NotNull NamespaceDescriptor namespaceDescriptor, @NotNull WritableScope namespaceMemberScope) {
        if (namespaceDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceDescriptor", "org/jetbrains/k2js/analyze/JsConfiguration", "extendNamespaceScope"));
        }
        if (namespaceMemberScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceMemberScope", "org/jetbrains/k2js/analyze/JsConfiguration", "extendNamespaceScope"));
        }
        DefaultModuleConfiguration.INSTANCE.extendNamespaceScope(namespaceDescriptor, namespaceMemberScope);
        if (namespaceDescriptor.getFqName().shortNameOrSpecial().equals(FqNameUnsafe.ROOT_NAME)) {
            namespaceMemberScope.importScope(KotlinBuiltIns.getInstance().getBuiltInsScope());
        }
        if (this.hasPreanalyzedContextForTests()) {
            this.extendScopeWithPreAnalyzedContextForTests(namespaceDescriptor, namespaceMemberScope);
        }
    }

    private boolean hasPreanalyzedContextForTests() {
        return this.preanalyzedContext != null;
    }

    private void extendScopeWithPreAnalyzedContextForTests(@NotNull NamespaceDescriptor namespaceDescriptor, @NotNull WritableScope namespaceMemberScope) {
        if (namespaceDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceDescriptor", "org/jetbrains/k2js/analyze/JsConfiguration", "extendScopeWithPreAnalyzedContextForTests"));
        }
        if (namespaceMemberScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceMemberScope", "org/jetbrains/k2js/analyze/JsConfiguration", "extendScopeWithPreAnalyzedContextForTests"));
        }
        if (JsConfiguration.isNamespaceImportedByDefault(namespaceDescriptor) || DescriptorUtils.isRootNamespace(namespaceDescriptor)) {
            FqName descriptorName = DescriptorUtils.getFQName(namespaceDescriptor).toSafe();
            NamespaceDescriptor alreadyAnalyzedNamespace = this.preanalyzedContext.get(BindingContext.FQNAME_TO_NAMESPACE_DESCRIPTOR, descriptorName);
            namespaceMemberScope.importScope(alreadyAnalyzedNamespace.getMemberScope());
        }
    }

    private static boolean isNamespaceImportedByDefault(@NotNull NamespaceDescriptor namespaceDescriptor) {
        if (namespaceDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceDescriptor", "org/jetbrains/k2js/analyze/JsConfiguration", "isNamespaceImportedByDefault"));
        }
        for (ImportPath path : DEFAULT_IMPORT_PATHS) {
            if (!path.fqnPart().equals(DescriptorUtils.getFQName(namespaceDescriptor).toSafe())) continue;
            return true;
        }
        return false;
    }
}

