/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotatedImpl;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;

public class TypeConstructorImpl
extends AnnotatedImpl
implements TypeConstructor {
    private final List<TypeParameterDescriptor> parameters;
    private Collection<JetType> supertypes;
    private final String debugName;
    private final boolean isFinal;
    @Nullable
    private final ClassifierDescriptor classifierDescriptor;

    public TypeConstructorImpl(@Nullable ClassifierDescriptor classifierDescriptor, @NotNull List<AnnotationDescriptor> annotations, boolean isFinal, @NotNull String debugName, @NotNull List<? extends TypeParameterDescriptor> parameters, @NotNull Collection<JetType> supertypes) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/types/TypeConstructorImpl", "<init>"));
        }
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/jet/lang/types/TypeConstructorImpl", "<init>"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/jet/lang/types/TypeConstructorImpl", "<init>"));
        }
        if (supertypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/jet/lang/types/TypeConstructorImpl", "<init>"));
        }
        super(annotations);
        this.classifierDescriptor = classifierDescriptor;
        this.isFinal = isFinal;
        this.debugName = debugName;
        this.parameters = Collections.unmodifiableList(new ArrayList<TypeParameterDescriptor>(parameters));
        this.supertypes = Collections.unmodifiableCollection(supertypes);
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        List<TypeParameterDescriptor> list2 = this.parameters;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeConstructorImpl", "getParameters"));
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<JetType> getSupertypes() {
        Collection<JetType> collection = this.supertypes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeConstructorImpl", "getSupertypes"));
        }
        return collection;
    }

    public String toString() {
        return this.debugName;
    }

    @Override
    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public boolean isDenotable() {
        return true;
    }

    @Override
    @Nullable
    public ClassifierDescriptor getDeclarationDescriptor() {
        return this.classifierDescriptor;
    }
}

