/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public class JetScopeSelectorUtil {
    public static final ScopeByNameSelector<ClassifierDescriptor> CLASSIFIER_DESCRIPTOR_SCOPE_SELECTOR = new ScopeByNameSelector<ClassifierDescriptor>(){

        @Override
        @Nullable
        public ClassifierDescriptor get(@NotNull JetScope scope, @NotNull Name name) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$1", "get"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$1", "get"));
            }
            return scope.getClassifier(name);
        }
    };
    public static final ScopeByNameSelector<ClassDescriptor> NAMED_OBJECT_SCOPE_SELECTOR = new ScopeByNameSelector<ClassDescriptor>(){

        @Override
        @Nullable
        public ClassDescriptor get(@NotNull JetScope scope, @NotNull Name name) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$2", "get"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$2", "get"));
            }
            return scope.getObjectDescriptor(name);
        }
    };
    public static final ScopeByNameSelector<NamespaceDescriptor> NAMESPACE_SCOPE_SELECTOR = new ScopeByNameSelector<NamespaceDescriptor>(){

        @Override
        @Nullable
        public NamespaceDescriptor get(@NotNull JetScope scope, @NotNull Name name) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$3", "get"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$3", "get"));
            }
            return scope.getNamespace(name);
        }
    };
    public static final ScopeByNameMultiSelector<FunctionDescriptor> NAMED_FUNCTION_SCOPE_SELECTOR = new ScopeByNameMultiSelector<FunctionDescriptor>(){

        @Override
        @NotNull
        public Collection<FunctionDescriptor> get(@NotNull JetScope scope, @NotNull Name name) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$4", "get"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$4", "get"));
            }
            Collection<FunctionDescriptor> collection = scope.getFunctions(name);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$4", "get"));
            }
            return collection;
        }
    };
    public static final ScopeByNameMultiSelector<VariableDescriptor> NAMED_PROPERTIES_SCOPE_SELECTOR = new ScopeByNameMultiSelector<VariableDescriptor>(){

        @Override
        @NotNull
        public Collection<VariableDescriptor> get(@NotNull JetScope scope, @NotNull Name name) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$5", "get"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$5", "get"));
            }
            Collection<VariableDescriptor> collection = scope.getProperties(name);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$5", "get"));
            }
            return collection;
        }
    };
    public static final ScopeDescriptorSelector<ClassDescriptor> OBJECTS_SCOPE_SELECTOR = new ScopeDescriptorSelector<ClassDescriptor>(){

        @Override
        @NotNull
        public Collection<ClassDescriptor> get(@NotNull JetScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$6", "get"));
            }
            Collection<ClassDescriptor> collection = scope.getObjectDescriptors();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$6", "get"));
            }
            return collection;
        }
    };
    public static final ScopeDescriptorSelector<DeclarationDescriptor> ALL_DESCRIPTORS_SCOPE_SELECTOR = new ScopeDescriptorSelector<DeclarationDescriptor>(){

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> get(@NotNull JetScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$7", "get"));
            }
            Collection<DeclarationDescriptor> collection = scope.getAllDescriptors();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil$7", "get"));
            }
            return collection;
        }
    };

    private JetScopeSelectorUtil() {
    }

    @NotNull
    public static <D extends DeclarationDescriptor> Collection<D> collect(Collection<JetScope> scopes, ScopeByNameMultiSelector<D> selector, Name name) {
        HashSet<D> descriptors = Sets.newHashSet();
        for (JetScope scope : scopes) {
            descriptors.addAll(selector.get(scope, name));
        }
        HashSet<D> hashSet = descriptors;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil", "collect"));
        }
        return hashSet;
    }

    @NotNull
    public static <D extends DeclarationDescriptor> Collection<D> collect(Collection<JetScope> scopes, ScopeDescriptorSelector<D> selector) {
        HashSet<D> descriptors = Sets.newHashSet();
        for (JetScope scope : scopes) {
            descriptors.addAll(selector.get(scope));
        }
        HashSet<D> hashSet = descriptors;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/JetScopeSelectorUtil", "collect"));
        }
        return hashSet;
    }

    public static interface ScopeDescriptorSelector<D extends DeclarationDescriptor> {
        @NotNull
        public Collection<D> get(JetScope var1);
    }

    public static interface ScopeByNameMultiSelector<D extends DeclarationDescriptor> {
        @NotNull
        public Collection<D> get(JetScope var1, Name var2);
    }

    public static interface ScopeByNameSelector<D extends DeclarationDescriptor> {
        @Nullable
        public D get(@NotNull JetScope var1, @NotNull Name var2);
    }
}

