/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.data;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import java.util.List;
import jet.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.resolve.lazy.data.JetClassLikeInfo;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.storage.NotNullLazyValue;
import org.jetbrains.jet.storage.StorageManager;

public class FilteringClassLikeInfo
implements JetClassLikeInfo {
    private final JetClassLikeInfo delegate;
    private final NotNullLazyValue<List<JetDeclaration>> filteredDeclarations;

    public FilteringClassLikeInfo(@NotNull StorageManager storageManager, final @NotNull JetClassLikeInfo delegate, final @NotNull Predicate<? super JetDeclaration> declarationFilter) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/lang/resolve/lazy/data/FilteringClassLikeInfo", "<init>"));
        }
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/jet/lang/resolve/lazy/data/FilteringClassLikeInfo", "<init>"));
        }
        if (declarationFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationFilter", "org/jetbrains/jet/lang/resolve/lazy/data/FilteringClassLikeInfo", "<init>"));
        }
        this.delegate = delegate;
        this.filteredDeclarations = storageManager.createLazyValue(new Function0<List<JetDeclaration>>(){

            @Override
            public List<JetDeclaration> invoke() {
                return Lists.newArrayList(Collections2.filter(delegate.getDeclarations(), declarationFilter));
            }
        });
    }

    @Override
    @NotNull
    public FqName getContainingPackageFqName() {
        FqName fqName = this.delegate.getContainingPackageFqName();
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/data/FilteringClassLikeInfo", "getContainingPackageFqName"));
        }
        return fqName;
    }

    @Override
    @NotNull
    public List<JetDelegationSpecifier> getDelegationSpecifiers() {
        List<JetDelegationSpecifier> list2 = this.delegate.getDelegationSpecifiers();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/data/FilteringClassLikeInfo", "getDelegationSpecifiers"));
        }
        return list2;
    }

    @Override
    @Nullable
    public JetModifierList getModifierList() {
        return this.delegate.getModifierList();
    }

    @Override
    @Nullable
    public JetClassObject getClassObject() {
        return this.delegate.getClassObject();
    }

    @Override
    @NotNull
    public PsiElement getScopeAnchor() {
        PsiElement psiElement = this.delegate.getScopeAnchor();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/data/FilteringClassLikeInfo", "getScopeAnchor"));
        }
        return psiElement;
    }

    @Override
    @Nullable
    public JetClassOrObject getCorrespondingClassOrObject() {
        return this.delegate.getCorrespondingClassOrObject();
    }

    @Override
    @NotNull
    public List<JetTypeParameter> getTypeParameters() {
        List<JetTypeParameter> list2 = this.delegate.getTypeParameters();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/data/FilteringClassLikeInfo", "getTypeParameters"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<? extends JetParameter> getPrimaryConstructorParameters() {
        List<? extends JetParameter> list2 = this.delegate.getPrimaryConstructorParameters();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/data/FilteringClassLikeInfo", "getPrimaryConstructorParameters"));
        }
        return list2;
    }

    @Override
    @NotNull
    public ClassKind getClassKind() {
        ClassKind classKind = this.delegate.getClassKind();
        if (classKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/data/FilteringClassLikeInfo", "getClassKind"));
        }
        return classKind;
    }

    @Override
    @NotNull
    public List<JetDeclaration> getDeclarations() {
        List list2 = (List)this.filteredDeclarations.invoke();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/data/FilteringClassLikeInfo", "getDeclarations"));
        }
        return list2;
    }

    public String toString() {
        return "filtering " + this.delegate.toString();
    }
}

