/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.descriptors.serialization.DescriptorFinder;
import org.jetbrains.jet.descriptors.serialization.JavaProtoBufUtil;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedPackageMemberScope;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.resolver.ErrorReporter;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaClassResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaNamespaceResolver;
import org.jetbrains.jet.lang.resolve.kotlin.AnnotationDescriptorDeserializer;
import org.jetbrains.jet.lang.resolve.kotlin.DeserializedResolverUtils;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.kotlin.header.KotlinClassHeader;
import org.jetbrains.jet.lang.resolve.kotlin.header.SerializedDataHeader;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.storage.LockBasedStorageManager;

public final class DeserializedDescriptorResolver {
    private AnnotationDescriptorDeserializer annotationDeserializer;
    private final LockBasedStorageManager storageManager = new LockBasedStorageManager();
    private JavaNamespaceResolver javaNamespaceResolver;
    private JavaClassResolver javaClassResolver;
    private ErrorReporter errorReporter;
    @NotNull
    private final DescriptorFinder javaDescriptorFinder = new DescriptorFinder(){

        @Override
        @Nullable
        public ClassDescriptor findClass(@NotNull ClassId classId) {
            if (classId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver$1", "findClass"));
            }
            return DeserializedDescriptorResolver.this.javaClassResolver.resolveClass(DeserializedResolverUtils.kotlinFqNameToJavaFqName(classId.asSingleFqName()), DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES);
        }

        @Override
        @Nullable
        public NamespaceDescriptor findPackage(@NotNull FqName name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver$1", "findPackage"));
            }
            return DeserializedDescriptorResolver.this.javaNamespaceResolver.resolveNamespace(name, DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
        }

        @Override
        @NotNull
        public Collection<Name> getClassNames(@NotNull FqName packageName) {
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver$1", "getClassNames"));
            }
            Collection<Name> collection = DeserializedDescriptorResolver.this.javaNamespaceResolver.getClassNamesInPackage(packageName);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver$1", "getClassNames"));
            }
            return collection;
        }
    };

    public void setAnnotationDeserializer(AnnotationDescriptorDeserializer annotationDeserializer) {
        this.annotationDeserializer = annotationDeserializer;
    }

    public void setJavaNamespaceResolver(JavaNamespaceResolver javaNamespaceResolver) {
        this.javaNamespaceResolver = javaNamespaceResolver;
    }

    public void setJavaClassResolver(JavaClassResolver javaClassResolver) {
        this.javaClassResolver = javaClassResolver;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Nullable
    public ClassDescriptor resolveClass(@NotNull KotlinJvmBinaryClass kotlinClass) {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver", "resolveClass"));
        }
        String[] data2 = this.readData(kotlinClass);
        return data2 == null ? null : new DeserializedClassDescriptor(this.storageManager, this.annotationDeserializer, this.javaDescriptorFinder, JavaProtoBufUtil.readClassDataFrom(data2));
    }

    @Nullable
    public JetScope createKotlinPackageScope(@NotNull NamespaceDescriptor descriptor, @NotNull KotlinJvmBinaryClass kotlinClass) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
        }
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
        }
        String[] data2 = this.readData(kotlinClass);
        return data2 == null ? null : new DeserializedPackageMemberScope(this.storageManager, descriptor, this.annotationDeserializer, this.javaDescriptorFinder, JavaProtoBufUtil.readPackageDataFrom(data2));
    }

    @Nullable
    private String[] readData(@NotNull KotlinJvmBinaryClass kotlinClass) {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedDescriptorResolver", "readData"));
        }
        KotlinClassHeader header = KotlinClassHeader.read(kotlinClass);
        if (header instanceof SerializedDataHeader) {
            return ((SerializedDataHeader)header).getAnnotationData();
        }
        if (header != null) {
            this.errorReporter.reportIncompatibleAbiVersion(kotlinClass, header.getVersion());
        }
        return null;
    }
}

