/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.java.JavaVisibilities;
import org.jetbrains.jet.lang.resolve.java.resolver.ExternalSignatureResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaResolverCache;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaTypeTransformer;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaValueParameterResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.TypeVariableResolverImpl;
import org.jetbrains.jet.lang.resolve.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.jet.lang.resolve.java.structure.JavaArrayType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.types.JetType;

public final class JavaConstructorResolver {
    private JavaResolverCache cache;
    private JavaTypeTransformer typeTransformer;
    private JavaValueParameterResolver valueParameterResolver;
    private ExternalSignatureResolver externalSignatureResolver;

    public void setCache(JavaResolverCache cache) {
        this.cache = cache;
    }

    public void setTypeTransformer(JavaTypeTransformer typeTransformer) {
        this.typeTransformer = typeTransformer;
    }

    public void setValueParameterResolver(JavaValueParameterResolver valueParameterResolver) {
        this.valueParameterResolver = valueParameterResolver;
    }

    public void setExternalSignatureResolver(ExternalSignatureResolver externalSignatureResolver) {
        this.externalSignatureResolver = externalSignatureResolver;
    }

    @NotNull
    public Collection<ConstructorDescriptor> resolveConstructors(@NotNull JavaClass javaClass, @NotNull ClassDescriptor containingClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/resolver/JavaConstructorResolver", "resolveConstructors"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/jet/lang/resolve/java/resolver/JavaConstructorResolver", "resolveConstructors"));
        }
        ArrayList<ConstructorDescriptor> result = new ArrayList<ConstructorDescriptor>();
        Collection<JavaMethod> constructors = javaClass.getConstructors();
        if (constructors.isEmpty()) {
            ConstructorDescriptor defaultConstructor = this.resolveDefaultConstructor(javaClass, containingClass);
            if (defaultConstructor != null) {
                result.add(defaultConstructor);
            }
        } else {
            for (JavaMethod javaMethod : constructors) {
                ConstructorDescriptor descriptor = this.resolveConstructor(javaMethod, containingClass, javaClass.isStatic());
                result.add(descriptor);
                ConstructorDescriptor samAdapter = JavaConstructorResolver.resolveSamAdapter(descriptor);
                if (samAdapter == null) continue;
                result.add(samAdapter);
            }
        }
        for (ConstructorDescriptor constructorDescriptor : result) {
            ((ConstructorDescriptorImpl)constructorDescriptor).setReturnType(containingClass.getDefaultType());
        }
        ArrayList<ConstructorDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaConstructorResolver", "resolveConstructors"));
        }
        return arrayList;
    }

    @Nullable
    private ConstructorDescriptor resolveDefaultConstructor(@NotNull JavaClass javaClass, @NotNull ClassDescriptor containingClass) {
        List<ValueParameterDescriptor> valueParameters;
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/resolver/JavaConstructorResolver", "resolveDefaultConstructor"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/jet/lang/resolve/java/resolver/JavaConstructorResolver", "resolveDefaultConstructor"));
        }
        ConstructorDescriptor alreadyResolved = this.cache.getConstructor(javaClass);
        if (alreadyResolved != null) {
            return alreadyResolved;
        }
        boolean isAnnotation = javaClass.isAnnotationType();
        if (javaClass.isInterface() && !isAnnotation) {
            return null;
        }
        ConstructorDescriptorImpl constructorDescriptor = new ConstructorDescriptorImpl(containingClass, Collections.<AnnotationDescriptor>emptyList(), true);
        List<TypeParameterDescriptor> typeParameters = containingClass.getTypeConstructor().getParameters();
        if (isAnnotation) {
            TypeVariableResolverImpl typeVariableResolver = new TypeVariableResolverImpl(typeParameters, containingClass);
            valueParameters = this.resolveAnnotationParameters(javaClass, constructorDescriptor, typeVariableResolver);
        } else {
            valueParameters = Collections.emptyList();
        }
        constructorDescriptor.initialize(typeParameters, valueParameters, JavaConstructorResolver.getConstructorVisibility(containingClass), javaClass.isStatic());
        this.cache.recordConstructor(javaClass, constructorDescriptor);
        return constructorDescriptor;
    }

    @NotNull
    private List<ValueParameterDescriptor> resolveAnnotationParameters(@NotNull JavaClass javaClass, @NotNull ConstructorDescriptor constructorDescriptor, @NotNull TypeVariableResolver typeVariableResolver) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/resolver/JavaConstructorResolver", "resolveAnnotationParameters"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/jet/lang/resolve/java/resolver/JavaConstructorResolver", "resolveAnnotationParameters"));
        }
        if (typeVariableResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeVariableResolver", "org/jetbrains/jet/lang/resolve/java/resolver/JavaConstructorResolver", "resolveAnnotationParameters"));
        }
        Collection<JavaMethod> methods = javaClass.getMethods();
        ArrayList<ValueParameterDescriptor> result = new ArrayList<ValueParameterDescriptor>(methods.size());
        int index = 0;
        Iterator<JavaMethod> iterator2 = methods.iterator();
        while (iterator2.hasNext()) {
            JavaMethod method = iterator2.next();
            assert (method.getValueParameters().isEmpty()) : "Annotation method can't have parameters: " + method;
            JavaType returnType = method.getReturnType();
            assert (returnType != null) : "Annotation method has no return type: " + method;
            JetType varargElementType = null;
            if (!iterator2.hasNext() && returnType instanceof JavaArrayType) {
                JavaType componentType = ((JavaArrayType)returnType).getComponentType();
                varargElementType = this.typeTransformer.transformToType(componentType, typeVariableResolver);
            }
            result.add(new ValueParameterDescriptorImpl(constructorDescriptor, index, Collections.<AnnotationDescriptor>emptyList(), method.getName(), this.typeTransformer.transformToType(returnType, typeVariableResolver), method.hasAnnotationParameterDefaultValue(), varargElementType));
            ++index;
        }
        ArrayList<ValueParameterDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaConstructorResolver", "resolveAnnotationParameters"));
        }
        return arrayList;
    }

    @NotNull
    private static Visibility getConstructorVisibility(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/java/resolver/JavaConstructorResolver", "getConstructorVisibility"));
        }
        Visibility visibility = classDescriptor.getVisibility();
        if (visibility == JavaVisibilities.PROTECTED_STATIC_VISIBILITY) {
            Visibility visibility2 = JavaVisibilities.PROTECTED_AND_PACKAGE;
            if (visibility2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaConstructorResolver", "getConstructorVisibility"));
            }
            return visibility2;
        }
        Visibility visibility3 = visibility;
        if (visibility3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaConstructorResolver", "getConstructorVisibility"));
        }
        return visibility3;
    }

    @NotNull
    private ConstructorDescriptor resolveConstructor(@NotNull JavaMethod constructor, @NotNull ClassDescriptor classDescriptor, boolean isStaticClass) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/jet/lang/resolve/java/resolver/JavaConstructorResolver", "resolveConstructor"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/java/resolver/JavaConstructorResolver", "resolveConstructor"));
        }
        ConstructorDescriptor alreadyResolved = this.cache.getConstructor(constructor);
        if (alreadyResolved != null) {
            ConstructorDescriptor constructorDescriptor = alreadyResolved;
            if (constructorDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaConstructorResolver", "resolveConstructor"));
            }
            return constructorDescriptor;
        }
        ConstructorDescriptorImpl constructorDescriptor = new ConstructorDescriptorImpl(classDescriptor, Collections.<AnnotationDescriptor>emptyList(), false);
        List<TypeParameterDescriptor> typeParameters = classDescriptor.getTypeConstructor().getParameters();
        List<ValueParameterDescriptor> valueParameters = this.valueParameterResolver.resolveValueParameters(constructorDescriptor, constructor, new TypeVariableResolverImpl(typeParameters, classDescriptor));
        ExternalSignatureResolver.AlternativeMethodSignature effectiveSignature = this.externalSignatureResolver.resolveAlternativeMethodSignature(constructor, false, null, null, valueParameters, Collections.<TypeParameterDescriptor>emptyList());
        constructorDescriptor.initialize(typeParameters, effectiveSignature.getValueParameters(), constructor.getVisibility(), isStaticClass);
        List<String> signatureErrors = effectiveSignature.getErrors();
        if (!signatureErrors.isEmpty()) {
            this.externalSignatureResolver.reportSignatureErrors(constructorDescriptor, signatureErrors);
        }
        this.cache.recordConstructor(constructor, constructorDescriptor);
        ConstructorDescriptorImpl constructorDescriptorImpl = constructorDescriptor;
        if (constructorDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaConstructorResolver", "resolveConstructor"));
        }
        return constructorDescriptorImpl;
    }

    @Nullable
    private static ConstructorDescriptor resolveSamAdapter(@NotNull ConstructorDescriptor original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/jet/lang/resolve/java/resolver/JavaConstructorResolver", "resolveSamAdapter"));
        }
        return SingleAbstractMethodUtils.isSamAdapterNecessary(original) ? (ConstructorDescriptor)((Object)SingleAbstractMethodUtils.createSamAdapterConstructor(original)) : null;
    }
}

