/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertySetterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ReceiverParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class DescriptorFactory {
    public static final Name VALUE_OF_METHOD_NAME = Name.identifier("valueOf");
    public static final Name VALUES_METHOD_NAME = Name.identifier("values");

    private DescriptorFactory() {
    }

    @NotNull
    public static PropertySetterDescriptorImpl createDefaultSetter(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createDefaultSetter"));
        }
        PropertySetterDescriptorImpl propertySetterDescriptorImpl = DescriptorFactory.createSetter(propertyDescriptor, true);
        if (propertySetterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createDefaultSetter"));
        }
        return propertySetterDescriptorImpl;
    }

    @NotNull
    public static PropertySetterDescriptorImpl createSetter(@NotNull PropertyDescriptor propertyDescriptor, boolean isDefault) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createSetter"));
        }
        PropertySetterDescriptorImpl setterDescriptor = new PropertySetterDescriptorImpl(propertyDescriptor, Collections.<AnnotationDescriptor>emptyList(), propertyDescriptor.getModality(), propertyDescriptor.getVisibility(), !isDefault, isDefault, CallableMemberDescriptor.Kind.DECLARATION);
        setterDescriptor.initializeDefault();
        PropertySetterDescriptorImpl propertySetterDescriptorImpl = setterDescriptor;
        if (propertySetterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createSetter"));
        }
        return propertySetterDescriptorImpl;
    }

    @NotNull
    public static PropertyGetterDescriptorImpl createDefaultGetter(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createDefaultGetter"));
        }
        PropertyGetterDescriptorImpl propertyGetterDescriptorImpl = DescriptorFactory.createGetter(propertyDescriptor, true);
        if (propertyGetterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createDefaultGetter"));
        }
        return propertyGetterDescriptorImpl;
    }

    @NotNull
    public static PropertyGetterDescriptorImpl createGetter(@NotNull PropertyDescriptor propertyDescriptor, boolean isDefault) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createGetter"));
        }
        PropertyGetterDescriptorImpl propertyGetterDescriptorImpl = new PropertyGetterDescriptorImpl(propertyDescriptor, Collections.<AnnotationDescriptor>emptyList(), propertyDescriptor.getModality(), propertyDescriptor.getVisibility(), !isDefault, isDefault, CallableMemberDescriptor.Kind.DECLARATION);
        if (propertyGetterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createGetter"));
        }
        return propertyGetterDescriptorImpl;
    }

    @NotNull
    public static ConstructorDescriptorImpl createPrimaryConstructorForObject(@NotNull ClassDescriptor containingClass) {
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createPrimaryConstructorForObject"));
        }
        ConstructorDescriptorImpl constructorDescriptor = new ConstructorDescriptorImpl(containingClass, Collections.<AnnotationDescriptor>emptyList(), true);
        constructorDescriptor.initialize(Collections.<TypeParameterDescriptor>emptyList(), Collections.<ValueParameterDescriptor>emptyList(), DescriptorUtils.getDefaultConstructorVisibility(containingClass));
        ConstructorDescriptorImpl constructorDescriptorImpl = constructorDescriptor;
        if (constructorDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createPrimaryConstructorForObject"));
        }
        return constructorDescriptorImpl;
    }

    @NotNull
    public static SimpleFunctionDescriptor createEnumClassObjectValuesMethod(@NotNull ClassDescriptor classObject, @NotNull JetType returnType) {
        if (classObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObject", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createEnumClassObjectValuesMethod"));
        }
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createEnumClassObjectValuesMethod"));
        }
        SimpleFunctionDescriptorImpl values = new SimpleFunctionDescriptorImpl(classObject, Collections.<AnnotationDescriptor>emptyList(), VALUES_METHOD_NAME, CallableMemberDescriptor.Kind.SYNTHESIZED);
        FunctionDescriptorImpl functionDescriptorImpl = values.initialize((JetType)null, classObject.getThisAsReceiverParameter(), Collections.emptyList(), Collections.emptyList(), returnType, Modality.FINAL, Visibilities.PUBLIC);
        if (functionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createEnumClassObjectValuesMethod"));
        }
        return functionDescriptorImpl;
    }

    @NotNull
    public static SimpleFunctionDescriptor createEnumClassObjectValueOfMethod(@NotNull ClassDescriptor classObject, @NotNull JetType returnType) {
        if (classObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObject", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createEnumClassObjectValueOfMethod"));
        }
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createEnumClassObjectValueOfMethod"));
        }
        SimpleFunctionDescriptorImpl values = new SimpleFunctionDescriptorImpl(classObject, Collections.<AnnotationDescriptor>emptyList(), VALUE_OF_METHOD_NAME, CallableMemberDescriptor.Kind.SYNTHESIZED);
        ValueParameterDescriptorImpl parameterDescriptor = new ValueParameterDescriptorImpl(values, 0, Collections.<AnnotationDescriptor>emptyList(), Name.identifier("value"), KotlinBuiltIns.getInstance().getStringType(), false, null);
        FunctionDescriptorImpl functionDescriptorImpl = values.initialize((JetType)null, classObject.getThisAsReceiverParameter(), Collections.emptyList(), Collections.singletonList(parameterDescriptor), returnType, Modality.FINAL, Visibilities.PUBLIC);
        if (functionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createEnumClassObjectValueOfMethod"));
        }
        return functionDescriptorImpl;
    }

    @Nullable
    public static ReceiverParameterDescriptor createReceiverParameterForCallable(@NotNull CallableDescriptor owner, @Nullable JetType receiverParameterType) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/DescriptorFactory", "createReceiverParameterForCallable"));
        }
        return receiverParameterType == null ? ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER : new ReceiverParameterDescriptorImpl(owner, receiverParameterType, new ExtensionReceiver(owner, receiverParameterType));
    }
}

