/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.sampullara.cli.Args;
import com.sampullara.cli.ArgumentUtils;
import java.io.PrintStream;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.cli.common.CLIConfigurationKeys;
import org.jetbrains.jet.cli.common.CompilerPlugin;
import org.jetbrains.jet.cli.common.ExitCode;
import org.jetbrains.jet.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.FilteringMessageCollector;
import org.jetbrains.jet.cli.common.messages.GroupingMessageCollector;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.common.messages.MessageRenderer;
import org.jetbrains.jet.cli.common.messages.MessageSeverityCollector;
import org.jetbrains.jet.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.jet.config.CompilerConfiguration;

public abstract class CLICompiler<A extends CommonCompilerArguments> {
    @NotNull
    private List<CompilerPlugin> compilerPlugins = Lists.newArrayList();

    @NotNull
    public List<CompilerPlugin> getCompilerPlugins() {
        List<CompilerPlugin> list2 = this.compilerPlugins;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/CLICompiler", "getCompilerPlugins"));
        }
        return list2;
    }

    public void setCompilerPlugins(@NotNull List<CompilerPlugin> compilerPlugins) {
        if (compilerPlugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerPlugins", "org/jetbrains/jet/cli/common/CLICompiler", "setCompilerPlugins"));
        }
        this.compilerPlugins = compilerPlugins;
    }

    @NotNull
    public ExitCode exec(@NotNull PrintStream errStream, String ... args) {
        if (errStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errStream", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
        }
        A arguments = this.createArguments();
        if (!this.parseArguments(errStream, arguments, args)) {
            ExitCode exitCode = ExitCode.INTERNAL_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
            }
            return exitCode;
        }
        ExitCode exitCode = this.exec(errStream, arguments);
        if (exitCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
        }
        return exitCode;
    }

    protected boolean parseArguments(@NotNull PrintStream errStream, @NotNull A arguments, @NotNull String[] args) {
        if (errStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errStream", "org/jetbrains/jet/cli/common/CLICompiler", "parseArguments"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/jet/cli/common/CLICompiler", "parseArguments"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/jet/cli/common/CLICompiler", "parseArguments"));
        }
        try {
            ((CommonCompilerArguments)arguments).freeArgs = Args.parse(arguments, args);
            return true;
        }
        catch (IllegalArgumentException e) {
            errStream.println(e.getMessage());
            this.usage(errStream);
        }
        catch (Throwable t) {
            errStream.println(MessageRenderer.TAGS.renderException(t));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void usage(@NotNull PrintStream target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jet/cli/common/CLICompiler", "usage"));
        }
        PrintStream oldErr = System.err;
        System.setErr(target);
        try {
            Args.usage(this.createArguments());
        }
        finally {
            System.setErr(oldErr);
        }
    }

    protected void configureEnvironment(@NotNull CompilerConfiguration configuration, @NotNull A arguments) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/jet/cli/common/CLICompiler", "configureEnvironment"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/jet/cli/common/CLICompiler", "configureEnvironment"));
        }
        configuration.addAll(CLIConfigurationKeys.COMPILER_PLUGINS, this.compilerPlugins);
    }

    @NotNull
    protected abstract A createArguments();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ExitCode exec(@NotNull PrintStream errStream, @NotNull A arguments) {
        if (errStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errStream", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
        }
        if (((CommonCompilerArguments)arguments).help) {
            this.usage(errStream);
            ExitCode exitCode = ExitCode.OK;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
            }
            return exitCode;
        }
        MessageRenderer messageRenderer = this.getMessageRenderer(arguments);
        errStream.print(messageRenderer.renderPreamble());
        this.printArgumentsIfNeeded(errStream, arguments, messageRenderer);
        this.printVersionIfNeeded(errStream, arguments, messageRenderer);
        MessageCollector collector = new PrintingMessageCollector(errStream, messageRenderer, ((CommonCompilerArguments)arguments).verbose);
        if (((CommonCompilerArguments)arguments).suppressAllWarnings()) {
            collector = new FilteringMessageCollector(collector, Predicates.equalTo(CompilerMessageSeverity.WARNING));
        }
        ExitCode exitCode = this.exec(collector, arguments);
        ExitCode exitCode2 = exitCode;
        if (exitCode2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
        }
        return exitCode2;
        finally {
            errStream.print(messageRenderer.renderConclusion());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public ExitCode exec(@NotNull MessageCollector messageCollector, @NotNull A arguments) {
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
        }
        GroupingMessageCollector groupingCollector = new GroupingMessageCollector(messageCollector);
        Disposable rootDisposable = Disposer.newDisposable();
        MessageSeverityCollector severityCollector = new MessageSeverityCollector(groupingCollector);
        ExitCode code = this.doExecute(arguments, severityCollector, rootDisposable);
        ExitCode exitCode = severityCollector.anyReported(CompilerMessageSeverity.ERROR) ? ExitCode.COMPILATION_ERROR : code;
        Disposer.dispose(rootDisposable);
        groupingCollector.flush();
        ExitCode exitCode2 = exitCode;
        if (exitCode2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
        }
        return exitCode2;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        Disposer.dispose(rootDisposable);
                        throw throwable;
                    }
                    catch (Throwable t) {
                        groupingCollector.report(CompilerMessageSeverity.EXCEPTION, MessageRenderer.PLAIN.renderException(t), CompilerMessageLocation.NO_LOCATION);
                        ExitCode exitCode3 = ExitCode.INTERNAL_ERROR;
                        ExitCode exitCode4 = exitCode3;
                        if (exitCode4 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/CLICompiler", "exec"));
                        }
                        return exitCode4;
                    }
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    groupingCollector.flush();
                }
            }
        }
    }

    @NotNull
    protected abstract ExitCode doExecute(@NotNull A var1, @NotNull MessageCollector var2, @NotNull Disposable var3);

    @NotNull
    protected MessageRenderer getMessageRenderer(@NotNull A arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/jet/cli/common/CLICompiler", "getMessageRenderer"));
        }
        MessageRenderer messageRenderer = ((CommonCompilerArguments)arguments).tags ? MessageRenderer.TAGS : MessageRenderer.PLAIN;
        if (messageRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/CLICompiler", "getMessageRenderer"));
        }
        return messageRenderer;
    }

    protected void printVersionIfNeeded(@NotNull PrintStream errStream, @NotNull A arguments, @NotNull MessageRenderer messageRenderer) {
        if (errStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errStream", "org/jetbrains/jet/cli/common/CLICompiler", "printVersionIfNeeded"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/jet/cli/common/CLICompiler", "printVersionIfNeeded"));
        }
        if (messageRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageRenderer", "org/jetbrains/jet/cli/common/CLICompiler", "printVersionIfNeeded"));
        }
        if (((CommonCompilerArguments)arguments).version) {
            String versionMessage = messageRenderer.render(CompilerMessageSeverity.INFO, "Kotlin Compiler version 0.6.1590", CompilerMessageLocation.NO_LOCATION);
            errStream.println(versionMessage);
        }
    }

    private void printArgumentsIfNeeded(@NotNull PrintStream errStream, @NotNull A arguments, @NotNull MessageRenderer messageRenderer) {
        if (errStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errStream", "org/jetbrains/jet/cli/common/CLICompiler", "printArgumentsIfNeeded"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/jet/cli/common/CLICompiler", "printArgumentsIfNeeded"));
        }
        if (messageRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageRenderer", "org/jetbrains/jet/cli/common/CLICompiler", "printArgumentsIfNeeded"));
        }
        if (((CommonCompilerArguments)arguments).printArgs) {
            String freeArgs = !((CommonCompilerArguments)arguments).freeArgs.isEmpty() ? " " + StringUtil.join(((CommonCompilerArguments)arguments).freeArgs, " ") : "";
            List<String> argumentsAsList = ArgumentUtils.convertArgumentsToStringList(arguments, this.createArguments());
            String argumentsAsString = StringUtil.join(argumentsAsList, " ");
            String printArgsMessage = messageRenderer.render(CompilerMessageSeverity.INFO, "Invoking compiler " + this.getClass().getName() + " with arguments " + argumentsAsString + freeArgs, CompilerMessageLocation.NO_LOCATION);
            errStream.println(printArgsMessage);
        }
    }

    public static void doMain(@NotNull CLICompiler compiler, @NotNull String[] args) {
        if (compiler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compiler", "org/jetbrains/jet/cli/common/CLICompiler", "doMain"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/jet/cli/common/CLICompiler", "doMain"));
        }
        System.setProperty("java.awt.headless", "true");
        ExitCode exitCode = CLICompiler.doMainNoExit(compiler, args);
        if (exitCode != ExitCode.OK) {
            System.exit(exitCode.getCode());
        }
    }

    @NotNull
    public static ExitCode doMainNoExit(@NotNull CLICompiler compiler, @NotNull String[] args) {
        ExitCode exitCode;
        if (compiler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compiler", "org/jetbrains/jet/cli/common/CLICompiler", "doMainNoExit"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/jet/cli/common/CLICompiler", "doMainNoExit"));
        }
        try {
            ExitCode rc = compiler.exec(System.out, args);
            if (rc != ExitCode.OK) {
                System.err.println("exec() finished with " + (Object)((Object)rc) + " return code");
            }
            exitCode = rc;
        }
        catch (CompileEnvironmentException e) {
            System.err.println(e.getMessage());
            ExitCode exitCode2 = ExitCode.INTERNAL_ERROR;
            if (exitCode2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/CLICompiler", "doMainNoExit"));
            }
            return exitCode2;
        }
        if (exitCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/CLICompiler", "doMainNoExit"));
        }
        return exitCode;
    }
}

