/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Enumerator;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.diff.IntLCS;
import com.intellij.util.diff.LCSBuilder;
import com.intellij.util.diff.Reindexer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Diff {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.diff.Diff");

    @Nullable
    public static Change buildChanges(@NotNull CharSequence before, @NotNull CharSequence after) throws FilesTooBigForDiffException {
        if (before == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/diff/Diff", "buildChanges"));
        }
        if (after == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/diff/Diff", "buildChanges"));
        }
        String[] strings1 = LineTokenizer.tokenize(before, false);
        String[] strings2 = LineTokenizer.tokenize(after, false);
        return Diff.buildChanges(strings1, strings2);
    }

    @Nullable
    public static <T> Change buildChanges(@NotNull T[] objects1, @NotNull T[] objects2) throws FilesTooBigForDiffException {
        if (objects1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/diff/Diff", "buildChanges"));
        }
        if (objects2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/diff/Diff", "buildChanges"));
        }
        for (T anObjects1 : objects1) {
            LOG.assertTrue(anObjects1 != null);
        }
        for (T anObjects2 : objects2) {
            LOG.assertTrue(anObjects2 != null);
        }
        int startShift = Diff.getStartShift(objects1, objects2);
        int endCut = Diff.getEndCut(objects1, objects2, startShift);
        Enumerator<T> enumerator = new Enumerator<T>(objects1.length + objects2.length, ContainerUtil.canonicalStrategy());
        int[] ints1 = enumerator.enumerate(objects1, startShift, endCut);
        int[] ints2 = enumerator.enumerate(objects2, startShift, endCut);
        Reindexer reindexer = new Reindexer();
        int[][] discarded = reindexer.discardUnique(ints1, ints2);
        IntLCS intLCS = new IntLCS(discarded[0], discarded[1]);
        intLCS.execute();
        ChangeBuilder builder = new ChangeBuilder(startShift);
        reindexer.reindex(intLCS.getPaths(), builder);
        return builder.getFirstChange();
    }

    private static <T> int getStartShift(T[] o1, T[] o2) {
        int size = Math.min(o1.length, o2.length);
        int idx = 0;
        for (int i = 0; i < size && o1[i].equals(o2[i]); ++i) {
            ++idx;
        }
        return idx;
    }

    private static <T> int getEndCut(T[] o1, T[] o2, int startShift) {
        int size = Math.min(o1.length, o2.length) - startShift;
        int idx = 0;
        for (int i = 0; i < size && o1[o1.length - i - 1].equals(o2[o2.length - i - 1]); ++i) {
            ++idx;
        }
        return idx;
    }

    public static int translateLine(@NotNull Change change, int line) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/diff/Diff", "translateLine"));
        }
        int result = line;
        Change currentChange = change;
        while (currentChange != null && line >= currentChange.line0) {
            if (line >= currentChange.line0 + currentChange.deleted) {
                result += currentChange.inserted - currentChange.deleted;
            } else {
                return -1;
            }
            currentChange = currentChange.link;
        }
        return result;
    }

    public static class ChangeBuilder
    implements LCSBuilder {
        private int myIndex1 = 0;
        private int myIndex2 = 0;
        private Change myFirstChange;
        private Change myLastChange;

        public ChangeBuilder(int startShift) {
            this.skip(startShift, startShift);
        }

        @Override
        public void addChange(int first, int second) {
            Change change = new Change(this.myIndex1, this.myIndex2, first, second, null);
            if (this.myLastChange != null) {
                this.myLastChange.link = change;
            } else {
                this.myFirstChange = change;
            }
            this.myLastChange = change;
            this.skip(first, second);
        }

        private void skip(int first, int second) {
            this.myIndex1 += first;
            this.myIndex2 += second;
        }

        @Override
        public void addEqual(int length) {
            this.skip(length, length);
        }

        public Change getFirstChange() {
            return this.myFirstChange;
        }
    }

    public static class Change {
        public Change link;
        public final int inserted;
        public final int deleted;
        public final int line0;
        public final int line1;

        protected Change(int line0, int line1, int deleted, int inserted, Change old) {
            this.line0 = line0;
            this.line1 = line1;
            this.inserted = inserted;
            this.deleted = deleted;
            this.link = old;
        }

        @NonNls
        public String toString() {
            return "change[inserted=" + this.inserted + ", deleted=" + this.deleted + ", line0=" + this.line0 + ", line1=" + this.line1 + "]";
        }
    }
}

