/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class FList<E>
extends AbstractList<E> {
    private static final FList<?> EMPTY_LIST = new FList();
    private E myHead;
    private FList<E> myTail;
    private int mySize;

    private FList() {
    }

    private FList(E head, FList<E> tail) {
        this.myHead = head;
        this.myTail = tail;
        this.mySize = tail.size() + 1;
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.mySize) {
            throw new IndexOutOfBoundsException("index = " + index + ", size = " + this.mySize);
        }
        FList<E> current = this;
        while (index > 0) {
            current = current.myTail;
            --index;
        }
        return current.myHead;
    }

    public E getHead() {
        return this.myHead;
    }

    public FList<E> prepend(E elem) {
        return new FList<E>(elem, this);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        Iterator iterator2 = new Iterator<E>(){
            private FList<E> list;
            {
                this.list = FList.this;
            }

            @Override
            public boolean hasNext() {
                return this.list.size() > 0;
            }

            @Override
            public E next() {
                if (this.list.size() == 0) {
                    throw new NoSuchElementException();
                }
                Object res = this.list.myHead;
                this.list = this.list.getTail();
                assert (this.list != null);
                return res;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        if (iterator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/FList", "iterator"));
        }
        return iterator2;
    }

    public FList<E> getTail() {
        return this.myTail;
    }

    @Override
    public int size() {
        return this.mySize;
    }

    public static <E> FList<E> emptyList() {
        return EMPTY_LIST;
    }
}

