/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaHighlightingUtil;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.SubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.impl.source.tree.java.PsiMethodReferenceExpressionImpl;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.HashMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PsiMethodReferenceCompatibilityConstraint
implements ConstraintFormula {
    private static final Logger LOG = Logger.getInstance("#" + PsiMethodReferenceCompatibilityConstraint.class.getName());
    private final PsiMethodReferenceExpression myExpression;
    private PsiType myT;

    public PsiMethodReferenceCompatibilityConstraint(PsiMethodReferenceExpression expression, PsiType t) {
        this.myExpression = expression;
        this.myT = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        PsiElement resolve;
        if (LambdaHighlightingUtil.checkInterfaceFunctional(this.myT) != null) {
            return false;
        }
        PsiClassType.ClassResolveResult classResolveResult = PsiUtil.resolveGenericsClassInType(this.myT);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(classResolveResult);
        if (interfaceMethod == null) {
            return false;
        }
        PsiSubstitutor substitutor = LambdaUtil.getSubstitutor(interfaceMethod, classResolveResult);
        PsiParameter[] targetParameters = interfaceMethod.getParameterList().getParameters();
        PsiType returnType = substitutor.substitute(interfaceMethod.getReturnType());
        PsiType[] typeParameters = this.myExpression.getTypeParameters();
        if (!this.myExpression.isExact()) {
            for (PsiParameter parameter : targetParameters) {
                if (session.isProperType(substitutor.substitute(parameter.getType()))) continue;
                return false;
            }
        } else {
            PsiParameter[] parameters;
            PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(this.myExpression);
            PsiSubstitutor psiSubstitutor = qualifierResolveResult.getSubstitutor();
            PsiMember applicableMember = ((PsiMethodReferenceExpressionImpl)this.myExpression).getPotentiallyApplicableMember();
            LOG.assertTrue(applicableMember != null);
            PsiType applicableMethodReturnType = applicableMember instanceof PsiMethod ? ((PsiMethod)applicableMember).getReturnType() : null;
            int idx = 0;
            for (PsiTypeParameter param : ((PsiTypeParameterListOwner)applicableMember).getTypeParameters()) {
                if (idx >= typeParameters.length) continue;
                psiSubstitutor = psiSubstitutor.put(param, typeParameters[idx++]);
            }
            PsiParameter[] psiParameterArray = parameters = applicableMember instanceof PsiMethod ? ((PsiMethod)applicableMember).getParameterList().getParameters() : PsiParameter.EMPTY_ARRAY;
            if (targetParameters.length == parameters.length + 1) {
                PsiType qualifierType;
                PsiTypeElement qualifierTypeElement = this.myExpression.getQualifierType();
                PsiExpression qualifierExpression = this.myExpression.getQualifierExpression();
                if (qualifierTypeElement != null) {
                    qualifierType = qualifierTypeElement.getType();
                } else {
                    JavaResolveResult resolveResult;
                    PsiElement resolve2;
                    LOG.assertTrue(qualifierExpression != null);
                    qualifierType = qualifierExpression.getType();
                    if (qualifierType == null && qualifierExpression instanceof PsiReferenceExpression && (resolve2 = (resolveResult = ((PsiReferenceExpression)qualifierExpression).advancedResolve(false)).getElement()) instanceof PsiClass) {
                        qualifierType = JavaPsiFacade.getElementFactory(resolve2.getProject()).createType((PsiClass)resolve2, resolveResult.getSubstitutor());
                    }
                }
                constraints.add(new SubtypingConstraint(qualifierType, GenericsUtil.eliminateWildcards(substitutor.substitute(targetParameters[0].getType())), true));
                for (int i = 1; i < targetParameters.length; ++i) {
                    constraints.add(new TypeCompatibilityConstraint(psiSubstitutor.substitute(parameters[i - 1].getType()), GenericsUtil.eliminateWildcards(substitutor.substitute(targetParameters[i].getType()))));
                }
            } else if (targetParameters.length == parameters.length) {
                for (int i = 0; i < targetParameters.length; ++i) {
                    constraints.add(new TypeCompatibilityConstraint(psiSubstitutor.substitute(parameters[i].getType()), GenericsUtil.eliminateWildcards(substitutor.substitute(targetParameters[i].getType()))));
                }
            } else {
                return false;
            }
            if (returnType != PsiType.VOID && returnType != null) {
                if (applicableMethodReturnType == PsiType.VOID) {
                    return false;
                }
                if (applicableMethodReturnType != null) {
                    constraints.add(new TypeCompatibilityConstraint(GenericsUtil.eliminateWildcards(returnType), psiSubstitutor.substitute(applicableMethodReturnType)));
                } else if (applicableMember instanceof PsiClass || applicableMember instanceof PsiMethod && ((PsiMethod)applicableMember).isConstructor()) {
                    PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(applicableMember.getProject());
                    PsiClassType classType = elementFactory.createType(qualifierResolveResult.getContainingClass(), psiSubstitutor);
                    constraints.add(new TypeCompatibilityConstraint(GenericsUtil.eliminateWildcards(returnType), classType));
                }
            }
            return true;
        }
        Map<PsiMethodReferenceExpression, PsiType> map = PsiMethodReferenceUtil.ourRefs.get();
        if (map == null) {
            map = new HashMap<PsiMethodReferenceExpression, PsiType>();
            PsiMethodReferenceUtil.ourRefs.set(map);
        }
        PsiType added = map.put(this.myExpression, this.myT);
        try {
            resolve = this.myExpression.resolve();
        }
        finally {
            if (added == null) {
                map.remove(this.myExpression);
            }
        }
        if (resolve == null) {
            return false;
        }
        if (PsiType.VOID.equals(returnType) || returnType == null) {
            return true;
        }
        if (resolve instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolve;
            PsiClass containingClass = method.getContainingClass();
            LOG.assertTrue(containingClass != null, method);
            PsiType referencedMethodReturnType = method.isConstructor() ? JavaPsiFacade.getElementFactory(method.getProject()).createType(containingClass, PsiSubstitutor.EMPTY) : method.getReturnType();
            LOG.assertTrue(referencedMethodReturnType != null, method);
            if (typeParameters.length == 0 && ((PsiMethod)resolve).getTypeParameters().length > 0 && PsiPolyExpressionUtil.mentionsTypeParameters(returnType, new HashSet<PsiTypeParameter>(Arrays.asList(interfaceMethod.getTypeParameters()))).booleanValue()) {
                return true;
            }
            if (PsiType.VOID.equals(referencedMethodReturnType)) {
                return false;
            }
            session.initBounds(method.getTypeParameters());
            session.initBounds(containingClass.getTypeParameters());
            constraints.add(new TypeCompatibilityConstraint(returnType, referencedMethodReturnType));
        }
        return true;
    }

    @Override
    public void apply(PsiSubstitutor substitutor) {
        this.myT = substitutor.substitute(this.myT);
    }
}

