/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowAnalyzer;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowSubRange;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;

public class ControlFlowFactory {
    private final ConcurrentMap<PsiElement, Reference<CopyOnWriteArrayList<ControlFlowContext>>> cachedFlows = new ConcurrentWeakHashMap<PsiElement, Reference<CopyOnWriteArrayList<ControlFlowContext>>>();
    private static final NotNullLazyKey<ControlFlowFactory, Project> INSTANCE_KEY = ServiceManager.createLazyKey(ControlFlowFactory.class);

    public static ControlFlowFactory getInstance(Project project) {
        return INSTANCE_KEY.getValue(project);
    }

    public ControlFlowFactory(PsiManagerEx psiManager) {
        psiManager.registerRunnableToRunOnChange(new Runnable(){

            @Override
            public void run() {
                ControlFlowFactory.this.clearCache();
            }
        });
    }

    private void clearCache() {
        this.cachedFlows.clear();
    }

    public void registerSubRange(PsiElement codeFragment, ControlFlowSubRange flow, boolean evaluateConstantIfConfition, ControlFlowPolicy policy) {
        this.registerControlFlow(codeFragment, flow, evaluateConstantIfConfition, policy);
    }

    @NotNull
    public ControlFlow getControlFlow(@NotNull PsiElement element, @NotNull ControlFlowPolicy policy) throws AnalysisCanceledException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/controlFlow/ControlFlowFactory", "getControlFlow"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/controlFlow/ControlFlowFactory", "getControlFlow"));
        }
        ControlFlow controlFlow = this.getControlFlow(element, policy, true, true);
        if (controlFlow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowFactory", "getControlFlow"));
        }
        return controlFlow;
    }

    @NotNull
    public ControlFlow getControlFlow(@NotNull PsiElement element, @NotNull ControlFlowPolicy policy, boolean evaluateConstantIfCondition) throws AnalysisCanceledException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/controlFlow/ControlFlowFactory", "getControlFlow"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/controlFlow/ControlFlowFactory", "getControlFlow"));
        }
        ControlFlow controlFlow = this.getControlFlow(element, policy, true, evaluateConstantIfCondition);
        if (controlFlow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowFactory", "getControlFlow"));
        }
        return controlFlow;
    }

    @NotNull
    public ControlFlow getControlFlow(@NotNull PsiElement element, @NotNull ControlFlowPolicy policy, boolean enableShortCircuit, boolean evaluateConstantIfCondition) throws AnalysisCanceledException {
        ControlFlowContext context2;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/controlFlow/ControlFlowFactory", "getControlFlow"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/controlFlow/ControlFlowFactory", "getControlFlow"));
        }
        long modificationCount = element.getManager().getModificationTracker().getModificationCount();
        CopyOnWriteArrayList<ControlFlowContext> cached = this.getOrCreateCachedFlowsForElement(element);
        for (ControlFlowContext context2 : cached) {
            if (!context2.isFor(policy, evaluateConstantIfCondition, modificationCount)) continue;
            ControlFlow controlFlow = context2.controlFlow;
            if (controlFlow == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowFactory", "getControlFlow"));
            }
            return controlFlow;
        }
        ControlFlow controlFlow = new ControlFlowAnalyzer(element, policy, enableShortCircuit, evaluateConstantIfCondition).buildControlFlow();
        context2 = ControlFlowFactory.createContext(evaluateConstantIfCondition, policy, controlFlow, modificationCount);
        cached.addIfAbsent(context2);
        ControlFlow controlFlow2 = controlFlow;
        if (controlFlow2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowFactory", "getControlFlow"));
        }
        return controlFlow2;
    }

    @NotNull
    private static ControlFlowContext createContext(boolean evaluateConstantIfCondition, @NotNull ControlFlowPolicy policy, @NotNull ControlFlow controlFlow, long modificationCount) {
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/controlFlow/ControlFlowFactory", "createContext"));
        }
        if (controlFlow == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/controlFlow/ControlFlowFactory", "createContext"));
        }
        ControlFlowContext controlFlowContext = new ControlFlowContext(evaluateConstantIfCondition, policy, modificationCount, controlFlow);
        if (controlFlowContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowFactory", "createContext"));
        }
        return controlFlowContext;
    }

    private void registerControlFlow(@NotNull PsiElement element, @NotNull ControlFlow flow, boolean evaluateConstantIfCondition, @NotNull ControlFlowPolicy policy) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/controlFlow/ControlFlowFactory", "registerControlFlow"));
        }
        if (flow == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/controlFlow/ControlFlowFactory", "registerControlFlow"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/controlFlow/ControlFlowFactory", "registerControlFlow"));
        }
        long modificationCount = element.getManager().getModificationTracker().getModificationCount();
        ControlFlowContext controlFlowContext = ControlFlowFactory.createContext(evaluateConstantIfCondition, policy, flow, modificationCount);
        CopyOnWriteArrayList<ControlFlowContext> cached = this.getOrCreateCachedFlowsForElement(element);
        cached.addIfAbsent(controlFlowContext);
    }

    @NotNull
    private CopyOnWriteArrayList<ControlFlowContext> getOrCreateCachedFlowsForElement(@NotNull PsiElement element) {
        CopyOnWriteArrayList<ControlFlowContext> cached;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/controlFlow/ControlFlowFactory", "getOrCreateCachedFlowsForElement"));
        }
        Reference cachedRef = (Reference)this.cachedFlows.get(element);
        CopyOnWriteArrayList<ControlFlowContext> copyOnWriteArrayList = cached = cachedRef == null ? null : (CopyOnWriteArrayList<ControlFlowContext>)cachedRef.get();
        if (cached == null) {
            cached = ContainerUtil.createEmptyCOWList();
            this.cachedFlows.put(element, new SoftReference<CopyOnWriteArrayList<ControlFlowContext>>(cached));
        }
        CopyOnWriteArrayList<ControlFlowContext> copyOnWriteArrayList2 = cached;
        if (copyOnWriteArrayList2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowFactory", "getOrCreateCachedFlowsForElement"));
        }
        return copyOnWriteArrayList2;
    }

    private static class ControlFlowContext {
        private final ControlFlowPolicy policy;
        private final boolean evaluateConstantIfCondition;
        private final long modificationCount;
        private final ControlFlow controlFlow;

        /*
         * WARNING - void declaration
         */
        private ControlFlowContext(boolean evaluateConstantIfCondition, @NotNull ControlFlowPolicy policy, long modificationCount, @NotNull ControlFlow controlFlow) {
            void controlFlow2;
            if (policy == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/controlFlow/ControlFlowFactory$ControlFlowContext", "<init>"));
            }
            if (controlFlow == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/controlFlow/ControlFlowFactory$ControlFlowContext", "<init>"));
            }
            this.evaluateConstantIfCondition = evaluateConstantIfCondition;
            this.policy = policy;
            this.modificationCount = modificationCount;
            this.controlFlow = controlFlow2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ControlFlowContext that = (ControlFlowContext)o;
            return this.isFor(that);
        }

        public int hashCode() {
            int result = this.policy.hashCode();
            result = 31 * result + (this.evaluateConstantIfCondition ? 1 : 0);
            result = 31 * result + (int)(this.modificationCount ^ this.modificationCount >>> 32);
            return result;
        }

        public boolean isFor(@NotNull ControlFlowPolicy policy, boolean evaluateConstantIfCondition, long modificationCount) {
            if (policy == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/controlFlow/ControlFlowFactory$ControlFlowContext", "isFor"));
            }
            if (modificationCount != this.modificationCount) {
                return false;
            }
            if (!policy.equals(this.policy)) {
                return false;
            }
            if (!this.controlFlow.isConstantConditionOccurred()) {
                return true;
            }
            return evaluateConstantIfCondition == this.evaluateConstantIfCondition;
        }

        private boolean isFor(@NotNull ControlFlowContext that) {
            if (that == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/controlFlow/ControlFlowFactory$ControlFlowContext", "isFor"));
            }
            return this.isFor(that.policy, that.evaluateConstantIfCondition, that.modificationCount);
        }
    }
}

