/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.operation;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.intrinsic.operation.BinaryOperationIntrinsic;
import org.jetbrains.k2js.translate.operation.OperatorTable;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public final class CompareToInstrinsic
implements BinaryOperationIntrinsic {
    @Override
    public boolean isApplicable(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/intrinsic/operation/CompareToInstrinsic", "isApplicable"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/intrinsic/operation/CompareToInstrinsic", "isApplicable"));
        }
        if (!OperatorConventions.COMPARISON_OPERATIONS.contains(PsiUtils.getOperationToken(expression))) {
            return false;
        }
        FunctionDescriptor functionDescriptor = BindingUtils.getFunctionDescriptorForOperationExpression(context.bindingContext(), expression);
        assert (functionDescriptor != null);
        return JsDescriptorUtils.isStandardDeclaration(functionDescriptor);
    }

    @Override
    @NotNull
    public JsExpression apply(@NotNull JetBinaryExpression expression, @NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/intrinsic/operation/CompareToInstrinsic", "apply"));
        }
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/k2js/translate/intrinsic/operation/CompareToInstrinsic", "apply"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/k2js/translate/intrinsic/operation/CompareToInstrinsic", "apply"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/intrinsic/operation/CompareToInstrinsic", "apply"));
        }
        JsBinaryOperator operator = OperatorTable.getBinaryOperator(PsiUtils.getOperationToken(expression));
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(operator, left, right);
        if (jsBinaryOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/operation/CompareToInstrinsic", "apply"));
        }
        return jsBinaryOperation;
    }
}

