/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceDescriptorParent;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JavaBridgeConfiguration;
import org.jetbrains.jet.lang.resolve.java.JavaClassFinder;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.java.descriptor.JavaNamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.java.mapping.JavaToKotlinClassMap;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaMemberResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaResolverCache;
import org.jetbrains.jet.lang.resolve.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.jet.lang.resolve.java.scope.JavaClassStaticMembersScope;
import org.jetbrains.jet.lang.resolve.java.scope.JavaPackageScope;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaField;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.JavaPackage;
import org.jetbrains.jet.lang.resolve.kotlin.DeserializedDescriptorResolver;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinClassFinder;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public final class JavaNamespaceResolver {
    @NotNull
    public static final ModuleDescriptor FAKE_ROOT_MODULE = new ModuleDescriptorImpl(JavaDescriptorResolver.JAVA_ROOT, JavaBridgeConfiguration.ALL_JAVA_IMPORTS, JavaToKotlinClassMap.getInstance());
    @NotNull
    private final Map<FqName, JetScope> resolvedNamespaceCache = new HashMap<FqName, JetScope>();
    @NotNull
    private final Set<FqName> unresolvedCache = new HashSet<FqName>();
    private JavaClassFinder javaClassFinder;
    private JavaResolverCache cache;
    private JavaMemberResolver memberResolver;
    private DeserializedDescriptorResolver deserializedDescriptorResolver;
    private KotlinClassFinder kotlinClassFinder;

    public void setKotlinClassFinder(KotlinClassFinder kotlinClassFinder) {
        this.kotlinClassFinder = kotlinClassFinder;
    }

    public void setJavaClassFinder(JavaClassFinder javaClassFinder) {
        this.javaClassFinder = javaClassFinder;
    }

    public void setCache(JavaResolverCache cache) {
        this.cache = cache;
    }

    public void setMemberResolver(@NotNull JavaMemberResolver memberResolver) {
        if (memberResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberResolver", "org/jetbrains/jet/lang/resolve/java/resolver/JavaNamespaceResolver", "setMemberResolver"));
        }
        this.memberResolver = memberResolver;
    }

    public void setDeserializedDescriptorResolver(DeserializedDescriptorResolver deserializedDescriptorResolver) {
        this.deserializedDescriptorResolver = deserializedDescriptorResolver;
    }

    @Nullable
    public NamespaceDescriptor resolveNamespace(@NotNull FqName qualifiedName, @NotNull DescriptorSearchRule searchRule) {
        NamespaceDescriptor kotlinNamespaceDescriptor;
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/jet/lang/resolve/java/resolver/JavaNamespaceResolver", "resolveNamespace"));
        }
        if (searchRule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchRule", "org/jetbrains/jet/lang/resolve/java/resolver/JavaNamespaceResolver", "resolveNamespace"));
        }
        if (searchRule == DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES && (kotlinNamespaceDescriptor = this.cache.getPackageResolvedFromSource(qualifiedName)) != null) {
            return kotlinNamespaceDescriptor;
        }
        if (this.unresolvedCache.contains(qualifiedName)) {
            return null;
        }
        JetScope scope = this.resolvedNamespaceCache.get(qualifiedName);
        if (scope != null) {
            return (NamespaceDescriptor)scope.getContainingDeclaration();
        }
        NamespaceDescriptorParent parentNs = this.resolveParentNamespace(qualifiedName);
        if (parentNs == null) {
            return null;
        }
        JavaNamespaceDescriptor javaNamespaceDescriptor = new JavaNamespaceDescriptor(parentNs, Collections.<AnnotationDescriptor>emptyList(), qualifiedName);
        JetScope newScope = this.createNamespaceScope(qualifiedName, javaNamespaceDescriptor, true);
        if (newScope == null) {
            return null;
        }
        javaNamespaceDescriptor.setMemberScope(newScope);
        return javaNamespaceDescriptor;
    }

    @Nullable
    private NamespaceDescriptorParent resolveParentNamespace(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/resolver/JavaNamespaceResolver", "resolveParentNamespace"));
        }
        if (fqName.isRoot()) {
            return FAKE_ROOT_MODULE;
        }
        return this.resolveNamespace(fqName.parent(), DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES);
    }

    @Nullable
    private JetScope createNamespaceScope(@NotNull FqName fqName, @NotNull NamespaceDescriptor namespaceDescriptor, boolean record) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/resolver/JavaNamespaceResolver", "createNamespaceScope"));
        }
        if (namespaceDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceDescriptor", "org/jetbrains/jet/lang/resolve/java/resolver/JavaNamespaceResolver", "createNamespaceScope"));
        }
        JetScope namespaceScope = this.doCreateNamespaceScope(fqName, namespaceDescriptor, record);
        this.cache(fqName, namespaceScope);
        return namespaceScope;
    }

    @Nullable
    private JetScope doCreateNamespaceScope(@NotNull FqName fqName, @NotNull NamespaceDescriptor namespaceDescriptor, boolean record) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/resolver/JavaNamespaceResolver", "doCreateNamespaceScope"));
        }
        if (namespaceDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceDescriptor", "org/jetbrains/jet/lang/resolve/java/resolver/JavaNamespaceResolver", "doCreateNamespaceScope"));
        }
        JavaPackage javaPackage = this.javaClassFinder.findPackage(fqName);
        if (javaPackage != null) {
            JetScope kotlinPackageScope;
            FqName packageClassFqName = PackageClassUtils.getPackageClassFqName(fqName);
            KotlinJvmBinaryClass kotlinClass = this.kotlinClassFinder.find(packageClassFqName);
            this.cache.recordProperNamespace(namespaceDescriptor);
            if (kotlinClass != null && (kotlinPackageScope = this.deserializedDescriptorResolver.createKotlinPackageScope(namespaceDescriptor, kotlinClass)) != null) {
                return kotlinPackageScope;
            }
            if (record) {
                this.cache.recordPackage(javaPackage, namespaceDescriptor);
            }
            return new JavaPackageScope(namespaceDescriptor, javaPackage, fqName, this.memberResolver);
        }
        JavaClass javaClass = this.javaClassFinder.findClass(fqName);
        if (javaClass == null) {
            return null;
        }
        if (DescriptorResolverUtils.isCompiledKotlinClassOrPackageClass(javaClass)) {
            return null;
        }
        if (!JavaNamespaceResolver.hasStaticMembers(javaClass)) {
            return null;
        }
        this.cache.recordClassStaticMembersNamespace(namespaceDescriptor);
        if (record) {
            this.cache.recordPackage(javaClass, namespaceDescriptor);
        }
        return new JavaClassStaticMembersScope(namespaceDescriptor, fqName, javaClass, this.memberResolver);
    }

    private void cache(@NotNull FqName fqName, @Nullable JetScope packageScope) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/resolver/JavaNamespaceResolver", "cache"));
        }
        if (packageScope == null) {
            this.unresolvedCache.add(fqName);
            return;
        }
        JetScope oldValue = this.resolvedNamespaceCache.put(fqName, packageScope);
        if (oldValue != null) {
            throw new IllegalStateException("rewrite at " + fqName);
        }
    }

    @Nullable
    public JetScope getJavaPackageScopeForExistingNamespaceDescriptor(@NotNull NamespaceDescriptor namespaceDescriptor) {
        if (namespaceDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceDescriptor", "org/jetbrains/jet/lang/resolve/java/resolver/JavaNamespaceResolver", "getJavaPackageScopeForExistingNamespaceDescriptor"));
        }
        FqName fqName = DescriptorUtils.getFQName(namespaceDescriptor).toSafe();
        if (this.unresolvedCache.contains(fqName)) {
            throw new IllegalStateException("This means that we are trying to create a Java package, but have a package with the same FQN defined in Kotlin: " + fqName);
        }
        JetScope alreadyResolvedScope = this.resolvedNamespaceCache.get(fqName);
        if (alreadyResolvedScope != null) {
            return alreadyResolvedScope;
        }
        return this.createNamespaceScope(fqName, namespaceDescriptor, false);
    }

    private static boolean hasStaticMembers(@NotNull JavaClass javaClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/resolver/JavaNamespaceResolver", "hasStaticMembers"));
        }
        for (JavaMethod method : javaClass.getMethods()) {
            if (!method.isStatic() || DescriptorResolverUtils.shouldBeInEnumClassObject(method)) continue;
            return true;
        }
        for (JavaField field : javaClass.getFields()) {
            if (!field.isStatic() || DescriptorResolverUtils.shouldBeInEnumClassObject(field)) continue;
            return true;
        }
        for (JavaClass nestedClass : javaClass.getInnerClasses()) {
            if (SingleAbstractMethodUtils.isSamInterface(nestedClass)) {
                return true;
            }
            if (!nestedClass.isStatic() || !JavaNamespaceResolver.hasStaticMembers(nestedClass)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Collection<Name> getClassNamesInPackage(@NotNull FqName packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/jet/lang/resolve/java/resolver/JavaNamespaceResolver", "getClassNamesInPackage"));
        }
        JavaPackage javaPackage = this.javaClassFinder.findPackage(packageName);
        if (javaPackage == null) {
            List<Name> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaNamespaceResolver", "getClassNamesInPackage"));
            }
            return list2;
        }
        Collection<JavaClass> classes = DescriptorResolverUtils.getClassesInPackage(javaPackage);
        ArrayList<Name> result = new ArrayList<Name>(classes.size());
        for (JavaClass javaClass : classes) {
            if (!DescriptorResolverUtils.isCompiledKotlinClass(javaClass)) continue;
            result.add(javaClass.getName());
        }
        ArrayList<Name> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaNamespaceResolver", "getClassNamesInPackage"));
        }
        return arrayList;
    }
}

