/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.Method;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class JvmAbi {
    public static final int VERSION = 11;
    public static final String TRAIT_IMPL_CLASS_NAME = "$TImpl";
    public static final String TRAIT_IMPL_SUFFIX = "$$TImpl";
    public static final String DEFAULT_PARAMS_IMPL_SUFFIX = "$default";
    public static final String GETTER_PREFIX = "get";
    public static final String SETTER_PREFIX = "set";
    public static final String CLASS_OBJECT_CLASS_NAME = "object";
    public static final String CLASS_OBJECT_SUFFIX = "$object";
    public static final String DELEGATED_PROPERTY_NAME_SUFFIX = "$delegate";
    public static final String ANNOTATED_PROPERTY_METHOD_NAME_SUFFIX = "$annotations";
    public static final String INSTANCE_FIELD = "instance$";
    public static final String CLASS_OBJECT_FIELD = "object$";
    public static final JvmClassName JET_OBJECT = JvmClassName.byFqNameWithoutInnerClasses("jet.JetObject");

    public static boolean isClassObjectFqName(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/JvmAbi", "isClassObjectFqName"));
        }
        return fqName.lastSegmentIs(Name.identifier(CLASS_OBJECT_CLASS_NAME));
    }

    @NotNull
    public static String getPropertyDelegateName(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/JvmAbi", "getPropertyDelegateName"));
        }
        String string = name.asString() + DELEGATED_PROPERTY_NAME_SUFFIX;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmAbi", "getPropertyDelegateName"));
        }
        return string;
    }

    @NotNull
    public static Method getSyntheticMethodSignatureForAnnotatedProperty(@NotNull Name propertyName, @Nullable Type receiver) {
        Type[] typeArray;
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/jet/lang/resolve/java/JvmAbi", "getSyntheticMethodSignatureForAnnotatedProperty"));
        }
        String string = propertyName.asString() + ANNOTATED_PROPERTY_METHOD_NAME_SUFFIX;
        if (receiver == null) {
            typeArray = new Type[]{};
        } else {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = receiver;
        }
        Method method = new Method(string, Type.VOID_TYPE, typeArray);
        if (method == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmAbi", "getSyntheticMethodSignatureForAnnotatedProperty"));
        }
        return method;
    }

    @NotNull
    public static String getDefaultPropertyName(@NotNull Name propertyName, boolean isDelegated, boolean isExtensionProperty) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/jet/lang/resolve/java/JvmAbi", "getDefaultPropertyName"));
        }
        if (isDelegated) {
            String string = JvmAbi.getPropertyDelegateName(propertyName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmAbi", "getDefaultPropertyName"));
            }
            return string;
        }
        String name = propertyName.asString();
        if (isExtensionProperty) {
            name = name + "$ext";
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/JvmAbi", "getDefaultPropertyName"));
        }
        return string;
    }

    private JvmAbi() {
    }
}

