/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.constants;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.constants.NumberValueTypeConstructor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class IntegerValueTypeConstructor
extends NumberValueTypeConstructor {
    private final long value;
    private final Collection<JetType> supertypes = Lists.newArrayList();

    public IntegerValueTypeConstructor(long value) {
        this.value = value;
        this.checkBoundsAndAddSuperType(value, Integer.MIN_VALUE, Integer.MAX_VALUE, KotlinBuiltIns.getInstance().getIntType());
        this.checkBoundsAndAddSuperType(value, -128L, 127L, KotlinBuiltIns.getInstance().getByteType());
        this.checkBoundsAndAddSuperType(value, -32768L, 32767L, KotlinBuiltIns.getInstance().getShortType());
        this.supertypes.add(KotlinBuiltIns.getInstance().getLongType());
    }

    private void checkBoundsAndAddSuperType(long value, long minValue, long maxValue, JetType kotlinType) {
        if (value >= minValue && value <= maxValue) {
            this.supertypes.add(kotlinType);
        }
    }

    @Override
    @NotNull
    public Collection<JetType> getSupertypes() {
        Collection<JetType> collection = this.supertypes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/constants/IntegerValueTypeConstructor", "getSupertypes"));
        }
        return collection;
    }

    public String toString() {
        return "IntegerValueType(" + this.value + ")";
    }
}

