/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.descriptors.serialization.DescriptorDeserializer;
import org.jetbrains.jet.descriptors.serialization.DescriptorFinder;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.PackageData;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotationDeserializer;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedMemberScope;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.storage.StorageManager;

public class DeserializedPackageMemberScope
extends DeserializedMemberScope {
    private final DescriptorFinder descriptorFinder;
    private final FqName packageFqName;

    public DeserializedPackageMemberScope(@NotNull StorageManager storageManager, @NotNull NamespaceDescriptor packageDescriptor, @NotNull AnnotationDeserializer annotationDeserializer, @NotNull DescriptorFinder descriptorFinder, @NotNull ProtoBuf.Package proto, @NotNull NameResolver nameResolver) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedPackageMemberScope", "<init>"));
        }
        if (packageDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageDescriptor", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedPackageMemberScope", "<init>"));
        }
        if (annotationDeserializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationDeserializer", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedPackageMemberScope", "<init>"));
        }
        if (descriptorFinder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorFinder", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedPackageMemberScope", "<init>"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedPackageMemberScope", "<init>"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedPackageMemberScope", "<init>"));
        }
        super(storageManager, packageDescriptor, DescriptorDeserializer.create(storageManager, packageDescriptor, nameResolver, descriptorFinder, annotationDeserializer), proto.getMemberList());
        this.descriptorFinder = descriptorFinder;
        this.packageFqName = DescriptorUtils.getFQName(packageDescriptor).toSafe();
    }

    public DeserializedPackageMemberScope(@NotNull StorageManager storageManager, @NotNull NamespaceDescriptor packageDescriptor, @NotNull AnnotationDeserializer annotationDeserializer, @NotNull DescriptorFinder descriptorFinder, @NotNull PackageData packageData) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedPackageMemberScope", "<init>"));
        }
        if (packageDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageDescriptor", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedPackageMemberScope", "<init>"));
        }
        if (annotationDeserializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationDeserializer", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedPackageMemberScope", "<init>"));
        }
        if (descriptorFinder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorFinder", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedPackageMemberScope", "<init>"));
        }
        if (packageData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageData", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedPackageMemberScope", "<init>"));
        }
        this(storageManager, packageDescriptor, annotationDeserializer, descriptorFinder, packageData.getPackageProto(), packageData.getNameResolver());
    }

    @Override
    @Nullable
    protected ClassifierDescriptor getClassDescriptor(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedPackageMemberScope", "getClassDescriptor"));
        }
        return this.findClassDescriptor(name, false);
    }

    @Override
    @Nullable
    public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedPackageMemberScope", "getObjectDescriptor"));
        }
        return this.findClassDescriptor(name, true);
    }

    @Nullable
    private ClassDescriptor findClassDescriptor(Name name, boolean object2) {
        ClassDescriptor classDescriptor = this.descriptorFinder.findClass(new ClassId(this.packageFqName, FqNameUnsafe.topLevel(name)));
        if (classDescriptor == null) {
            return null;
        }
        return classDescriptor.getKind().isObject() == object2 ? classDescriptor : null;
    }

    @Override
    protected void addAllClassDescriptors(@NotNull Collection<DeclarationDescriptor> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedPackageMemberScope", "addAllClassDescriptors"));
        }
        this.findClassifiers(result, false);
    }

    @Override
    @NotNull
    protected Collection<ClassDescriptor> computeAllObjectDescriptors() {
        ArrayList<ClassDescriptor> arrayList = this.findClassifiers(new ArrayList(), true);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedPackageMemberScope", "computeAllObjectDescriptors"));
        }
        return arrayList;
    }

    private <T extends Collection<? super ClassDescriptor>> T findClassifiers(T result, boolean object2) {
        for (Name className : this.descriptorFinder.getClassNames(this.packageFqName)) {
            ClassDescriptor classDescriptor = this.findClassDescriptor(className, object2);
            if (classDescriptor == null) continue;
            assert (classDescriptor.getKind().isObject() == object2);
            result.add((ClassDescriptor)classDescriptor);
        }
        return result;
    }

    @Override
    protected void addNonDeclaredDescriptors(@NotNull Collection<DeclarationDescriptor> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedPackageMemberScope", "addNonDeclaredDescriptors"));
        }
    }

    @Override
    @Nullable
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedPackageMemberScope", "getNamespace"));
        }
        return this.descriptorFinder.findPackage(this.packageFqName.child(name));
    }

    @Override
    @Nullable
    protected ReceiverParameterDescriptor getImplicitReceiver() {
        return null;
    }
}

