/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm.compiler;

import com.google.common.base.Predicates;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jet.Function0;
import jet.modules.AllModules;
import jet.modules.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.analyzer.AnalyzeExhaust;
import org.jetbrains.jet.cli.common.CLIConfigurationKeys;
import org.jetbrains.jet.cli.common.CompilerPlugin;
import org.jetbrains.jet.cli.common.CompilerPluginContext;
import org.jetbrains.jet.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.common.output.OutputDirector;
import org.jetbrains.jet.cli.common.output.SingleDirectoryDirector;
import org.jetbrains.jet.cli.jvm.JVMConfigurationKeys;
import org.jetbrains.jet.cli.jvm.compiler.ChunkAsOneModule;
import org.jetbrains.jet.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.jet.cli.jvm.compiler.JetCoreEnvironment;
import org.jetbrains.jet.cli.jvm.compiler.ModuleChunk;
import org.jetbrains.jet.codegen.ClassBuilderFactories;
import org.jetbrains.jet.codegen.ClassFileFactory;
import org.jetbrains.jet.codegen.CompilationErrorHandler;
import org.jetbrains.jet.codegen.GeneratedClassLoader;
import org.jetbrains.jet.codegen.KotlinCodegenFacade;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.Progress;
import org.jetbrains.jet.config.CommonConfigurationKeys;
import org.jetbrains.jet.config.CompilerConfiguration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.ScriptNameUtil;
import org.jetbrains.jet.lang.resolve.java.AnalyzerFacadeForJVM;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.plugin.JetMainDetector;
import org.jetbrains.jet.utils.KotlinPaths;

public class KotlinToJVMBytecodeCompiler {
    private KotlinToJVMBytecodeCompiler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ClassFileFactory compileModule(CompilerConfiguration configuration, Module module, File directory) {
        List<String> sourceFiles = module.getSourceFiles();
        if (sourceFiles.isEmpty()) {
            throw new CompileEnvironmentException("No source files where defined in module " + module.getModuleName());
        }
        CompilerConfiguration compilerConfiguration = configuration.copy();
        for (String sourceFile : sourceFiles) {
            File source = new File(sourceFile);
            if (!source.isAbsolute()) {
                source = new File(directory, sourceFile);
            }
            if (!source.exists()) {
                throw new CompileEnvironmentException("'" + source + "' does not exist in module " + module.getModuleName());
            }
            compilerConfiguration.add(CommonConfigurationKeys.SOURCE_ROOTS_KEY, source.getPath());
        }
        for (String classpathRoot : module.getClasspathRoots()) {
            compilerConfiguration.add(JVMConfigurationKeys.CLASSPATH_KEY, new File(classpathRoot));
        }
        for (String annotationsRoot : module.getAnnotationsRoots()) {
            compilerConfiguration.add(JVMConfigurationKeys.ANNOTATIONS_PATH_KEY, new File(annotationsRoot));
        }
        Disposable parentDisposable = Disposer.newDisposable();
        JetCoreEnvironment moduleEnvironment = null;
        try {
            moduleEnvironment = JetCoreEnvironment.createForProduction(parentDisposable, compilerConfiguration);
            GenerationState generationState = KotlinToJVMBytecodeCompiler.analyzeAndGenerate(moduleEnvironment);
            if (generationState == null) {
                ClassFileFactory classFileFactory = null;
                return classFileFactory;
            }
            ClassFileFactory classFileFactory = generationState.getFactory();
            return classFileFactory;
        }
        finally {
            if (moduleEnvironment != null) {
                Disposer.dispose(parentDisposable);
            }
        }
    }

    private static void writeOutput(CompilerConfiguration configuration, ClassFileFactory outputFiles, OutputDirector outputDir, File jarPath, boolean jarRuntime, FqName mainClass) {
        MessageCollector messageCollector = configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, MessageCollector.NONE);
        CompileEnvironmentUtil.writeOutputToDirOrJar(jarPath, outputDir, jarRuntime, mainClass, outputFiles, messageCollector);
    }

    public static boolean compileModules(CompilerConfiguration configuration, final @NotNull ModuleChunk chunk, @NotNull File directory, @Nullable File jarPath, boolean jarRuntime) {
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileModules"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileModules"));
        }
        List<Module> modules = chunk.getModules();
        if (modules.size() > 1) {
            modules = Collections.singletonList(new ChunkAsOneModule(chunk));
        }
        for (Module module : modules) {
            ClassFileFactory outputFiles = KotlinToJVMBytecodeCompiler.compileModule(configuration, module, directory);
            if (outputFiles == null) {
                return false;
            }
            OutputDirector outputDir = new OutputDirector(){

                @Override
                @NotNull
                public File getOutputDirectory(@NotNull Collection<? extends File> sourceFiles) {
                    if (sourceFiles == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler$1", "getOutputDirectory"));
                    }
                    for (File file : sourceFiles) {
                        Module module = chunk.findModuleBySourceFile(file);
                        if (module == null) continue;
                        File file2 = new File(module.getOutputDirectory());
                        if (file2 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler$1", "getOutputDirectory"));
                        }
                        return file2;
                    }
                    throw new IllegalStateException("No module found for source files: " + sourceFiles);
                }
            };
            KotlinToJVMBytecodeCompiler.writeOutput(configuration, outputFiles, outputDir, jarPath, jarRuntime, null);
        }
        return true;
    }

    @Nullable
    private static FqName findMainClass(@NotNull List<JetFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "findMainClass"));
        }
        FqName mainClass = null;
        for (JetFile file : files) {
            if (!JetMainDetector.hasMain(file.getDeclarations())) continue;
            if (mainClass != null) {
                return null;
            }
            FqName fqName = JetPsiUtil.getFQName(file);
            mainClass = PackageClassUtils.getPackageClassFqName(fqName);
        }
        return mainClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compileBunchOfSources(JetCoreEnvironment environment, @Nullable File jar, @Nullable File outputDir, boolean includeRuntime) {
        FqName mainClass = KotlinToJVMBytecodeCompiler.findMainClass(environment.getSourceFiles());
        GenerationState generationState = KotlinToJVMBytecodeCompiler.analyzeAndGenerate(environment);
        if (generationState == null) {
            return false;
        }
        try {
            SingleDirectoryDirector outputDirector = outputDir != null ? new SingleDirectoryDirector(outputDir) : null;
            KotlinToJVMBytecodeCompiler.writeOutput(environment.getConfiguration(), generationState.getFactory(), outputDirector, jar, includeRuntime, mainClass);
            boolean bl = true;
            return bl;
        }
        finally {
            generationState.destroy();
        }
    }

    public static void compileAndExecuteScript(@NotNull KotlinPaths paths, @NotNull JetCoreEnvironment environment, @NotNull List<String> scriptArgs) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileAndExecuteScript"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileAndExecuteScript"));
        }
        if (scriptArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptArgs", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileAndExecuteScript"));
        }
        Class<?> scriptClass = KotlinToJVMBytecodeCompiler.compileScript(paths, environment);
        if (scriptClass == null) {
            return;
        }
        try {
            scriptClass.getConstructor(String[].class).newInstance(new Object[]{scriptArgs.toArray(new String[scriptArgs.size()])});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to evaluate script: " + e, e);
        }
    }

    @Nullable
    public static Class<?> compileScript(@NotNull KotlinPaths paths, @NotNull JetCoreEnvironment environment) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileScript"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "compileScript"));
        }
        GenerationState state = KotlinToJVMBytecodeCompiler.analyzeAndGenerate(environment);
        if (state == null) {
            return null;
        }
        GeneratedClassLoader classLoader = null;
        try {
            classLoader = new GeneratedClassLoader(state.getFactory(), (ClassLoader)new URLClassLoader(new URL[]{paths.getRuntimePath().toURI().toURL()}, AllModules.class.getClassLoader()), new URL[0]);
            Class<?> clazz = classLoader.loadClass(ScriptNameUtil.classNameForScript(environment.getSourceFiles().get(0)));
            return clazz;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to evaluate script: " + e, e);
        }
        finally {
            if (classLoader != null) {
                classLoader.dispose();
            }
            state.destroy();
        }
    }

    @Nullable
    public static GenerationState analyzeAndGenerate(@NotNull JetCoreEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "analyzeAndGenerate"));
        }
        AnalyzeExhaust exhaust = KotlinToJVMBytecodeCompiler.analyze(environment);
        if (exhaust == null) {
            return null;
        }
        exhaust.throwIfError();
        return KotlinToJVMBytecodeCompiler.generate(environment, exhaust);
    }

    @Nullable
    private static AnalyzeExhaust analyze(final @NotNull JetCoreEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "analyze"));
        }
        AnalyzerWithCompilerReport analyzerWithCompilerReport = new AnalyzerWithCompilerReport(environment.getConfiguration().get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY));
        analyzerWithCompilerReport.analyzeAndReport(new Function0<AnalyzeExhaust>(){

            @Override
            @NotNull
            public AnalyzeExhaust invoke() {
                BindingTrace sharedTrace = CliLightClassGenerationSupport.getInstanceForCli(environment.getProject()).getTrace();
                AnalyzeExhaust analyzeExhaust = AnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(environment.getProject(), environment.getSourceFiles(), sharedTrace, environment.getConfiguration().getList(JVMConfigurationKeys.SCRIPT_PARAMETERS), Predicates.<PsiFile>alwaysTrue(), false);
                if (analyzeExhaust == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler$2", "invoke"));
                }
                return analyzeExhaust;
            }
        }, environment.getSourceFiles());
        return analyzerWithCompilerReport.hasErrors() ? null : analyzerWithCompilerReport.getAnalyzeExhaust();
    }

    @NotNull
    private static GenerationState generate(@NotNull JetCoreEnvironment environment, @NotNull AnalyzeExhaust exhaust) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "generate"));
        }
        if (exhaust == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exhaust", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "generate"));
        }
        Project project = environment.getProject();
        CompilerConfiguration configuration = environment.getConfiguration();
        GenerationState generationState = new GenerationState(project, ClassBuilderFactories.BINARIES, Progress.DEAF, exhaust.getBindingContext(), environment.getSourceFiles(), configuration.get(JVMConfigurationKeys.GENERATE_NOT_NULL_ASSERTIONS, false), configuration.get(JVMConfigurationKeys.GENERATE_NOT_NULL_PARAMETER_ASSERTIONS, false), true);
        KotlinCodegenFacade.compileCorrectFiles(generationState, CompilationErrorHandler.THROW_EXCEPTION);
        CompilerPluginContext context = new CompilerPluginContext(project, exhaust.getBindingContext(), environment.getSourceFiles());
        for (CompilerPlugin plugin : configuration.getList(CLIConfigurationKeys.COMPILER_PLUGINS)) {
            plugin.processFiles(context);
        }
        GenerationState generationState2 = generationState;
        if (generationState2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/KotlinToJVMBytecodeCompiler", "generate"));
        }
        return generationState2;
    }
}

