/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import jet.Function1;
import jet.Function2;
import jet.JetObject;
import jet.KotlinPackageFragment;
import jet.Unit;
import jet.runtime.Intrinsics;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage-ArraysJVM-6b82df2e;
import kotlin.KotlinPackage-StringsJVM-a330cb3a;
import kotlin.io.IoPackage$appendBytes$1;
import kotlin.io.IoPackage$copyTo$1;
import kotlin.io.IoPackage$readBytes$1;
import kotlin.io.IoPackage$readLines$1;
import kotlin.io.IoPackage$writeBytes$1;
import kotlin.io.IoPackage-JIO-882e1ff;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinPackageFragment(abiVersion=11)
public final class IoPackage-Files-251b5338 {
    @NotNull
    public static final void recurse(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="block") @NotNull Function1<? super File, ? extends Unit> block) {
        block.invoke($receiver);
        File[] children = $receiver.listFiles();
        boolean bl = true;
        if (children == null) {
            bl = false;
        }
        if (bl) {
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                IoPackage-Files-251b5338.recurse(child, block);
            }
        }
    }

    @NotNull
    public static final File getDirectory(@JetValueParameter(name="$receiver") File $receiver) {
        File file;
        if ($receiver.isDirectory()) {
            file = $receiver;
        } else {
            file = $receiver.getParentFile();
            if (file == null) {
                Intrinsics.throwNpe();
            }
        }
        return file;
    }

    @NotNull
    public static final String getCanonicalPath(@JetValueParameter(name="$receiver") File $receiver) {
        return $receiver.getCanonicalPath();
    }

    @NotNull
    public static final String getName(@JetValueParameter(name="$receiver") File $receiver) {
        return $receiver.getName();
    }

    @NotNull
    public static final String getPath(@JetValueParameter(name="$receiver") File $receiver) {
        return $receiver.getPath();
    }

    @NotNull
    public static final String getExtension(@JetValueParameter(name="$receiver") File $receiver) {
        String text = IoPackage-Files-251b5338.getName($receiver);
        int idx = KotlinPackage-StringsJVM-a330cb3a.lastIndexOf(text, '.');
        return idx >= 0 ? KotlinPackage-StringsJVM-a330cb3a.substring(text, idx + 1) : "";
    }

    public static final boolean isDescendant(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="file") @NotNull File file) {
        return KotlinPackage-StringsJVM-a330cb3a.startsWith(IoPackage-Files-251b5338.getCanonicalPath(IoPackage-Files-251b5338.getDirectory(file)), IoPackage-Files-251b5338.getCanonicalPath(IoPackage-Files-251b5338.getDirectory($receiver)));
    }

    @NotNull
    public static final String relativePath(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="descendant") @NotNull File descendant) {
        String string;
        String prefix = IoPackage-Files-251b5338.getCanonicalPath(IoPackage-Files-251b5338.getDirectory($receiver));
        String answer = IoPackage-Files-251b5338.getCanonicalPath(descendant);
        if (KotlinPackage-StringsJVM-a330cb3a.startsWith(answer, prefix)) {
            int prefixSize = KotlinPackage-StringsJVM-a330cb3a.getSize(prefix);
            string = KotlinPackage-StringsJVM-a330cb3a.getSize(answer) > prefixSize ? KotlinPackage-StringsJVM-a330cb3a.substring(answer, prefixSize + 1) : "";
        } else {
            string = answer;
        }
        return string;
    }

    @NotNull
    public static final FileReader reader(@JetValueParameter(name="$receiver") File $receiver) {
        return new FileReader($receiver);
    }

    @NotNull
    public static final byte[] readBytes(@JetValueParameter(name="$receiver") File $receiver) {
        return (byte[])IoPackage-JIO-882e1ff.use((Closeable)new FileInputStream($receiver), new IoPackage$readBytes$1($receiver));
    }

    @NotNull
    public static final void writeBytes(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="data") @NotNull byte[] data2) {
        IoPackage-JIO-882e1ff.use((Closeable)new FileOutputStream($receiver), new IoPackage$writeBytes$1(data2));
    }

    @NotNull
    public static final void appendBytes(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="data") @NotNull byte[] data2) {
        IoPackage-JIO-882e1ff.use((Closeable)new FileOutputStream($receiver, true), new IoPackage$appendBytes$1(data2));
    }

    @NotNull
    public static final String readText(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="encoding") @NotNull String encoding) {
        return KotlinPackage-ArraysJVM-6b82df2e.toString(IoPackage-Files-251b5338.readBytes($receiver), encoding);
    }

    public static /* synthetic */ String readText$default(File file, String string, int n) {
        if ((n & 1) != 0) {
            string = Charset.defaultCharset().name();
        }
        return IoPackage-Files-251b5338.readText(file, string);
    }

    @NotNull
    public static final String readText(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="encoding") @NotNull Charset encoding) {
        return KotlinPackage-ArraysJVM-6b82df2e.toString(IoPackage-Files-251b5338.readBytes($receiver), encoding);
    }

    @NotNull
    public static final void writeText(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="text") @NotNull String text, @JetValueParameter(name="encoding") @NotNull String encoding) {
        IoPackage-Files-251b5338.writeBytes($receiver, KotlinPackage-StringsJVM-a330cb3a.toByteArray(text, encoding));
    }

    public static /* synthetic */ void writeText$default(File file, String string, String string2, int n) {
        if ((n & 2) != 0) {
            string2 = Charset.defaultCharset().name();
        }
        IoPackage-Files-251b5338.writeText(file, string, string2);
    }

    @NotNull
    public static final void writeText(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="text") @NotNull String text, @JetValueParameter(name="encoding") @NotNull Charset encoding) {
        IoPackage-Files-251b5338.writeBytes($receiver, KotlinPackage-StringsJVM-a330cb3a.toByteArray(text, encoding));
    }

    @NotNull
    public static final void appendText(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="text") @NotNull String text, @JetValueParameter(name="encoding") @NotNull Charset encoding) {
        IoPackage-Files-251b5338.appendBytes($receiver, KotlinPackage-StringsJVM-a330cb3a.toByteArray(text, encoding));
    }

    @NotNull
    public static final void appendText(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="text") @NotNull String text, @JetValueParameter(name="encoding") @NotNull String encoding) {
        IoPackage-Files-251b5338.appendBytes($receiver, KotlinPackage-StringsJVM-a330cb3a.toByteArray(text, encoding));
    }

    public static /* synthetic */ void appendText$default(File file, String string, String string2, int n) {
        if ((n & 2) != 0) {
            string2 = Charset.defaultCharset().name();
        }
        IoPackage-Files-251b5338.appendText(file, string, string2);
    }

    public static final long copyTo(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="file") @NotNull File file, @JetValueParameter(name="bufferSize") int bufferSize) {
        IoPackage-Files-251b5338.getDirectory(file).mkdirs();
        FileInputStream input = new FileInputStream($receiver);
        return ((Number)IoPackage-JIO-882e1ff.use((Closeable)input, new IoPackage$copyTo$1(input, bufferSize, file))).longValue();
    }

    public static /* synthetic */ long copyTo$default(File file, File file2, int n, int n2) {
        if ((n2 & 2) != 0) {
            n = IoPackage-JIO-882e1ff.defaultBufferSize;
        }
        return IoPackage-Files-251b5338.copyTo(file, file2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final void forEachBlock(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="closure") @NotNull Function2<? super byte[], ? super Integer, ? extends Unit> closure) {
        byte[] arr = new byte[4096];
        FileInputStream fis = new FileInputStream($receiver);
        try {
            int size;
            while ((size = fis.read(arr)) != -1) {
                Unit unit;
                if (size > 0) {
                    closure.invoke((byte[])arr, (Integer)size);
                    unit = Unit.VALUE;
                    continue;
                }
                unit = Unit.VALUE;
            }
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final void forEachLine(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="charset") @NotNull String charset, @JetValueParameter(name="closure") @NotNull Function1<? super String, ? extends Unit> closure) {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream($receiver), charset));
        try {
            IoPackage-JIO-882e1ff.forEachLine(reader, closure);
        }
        finally {
            reader.close();
        }
    }

    public static /* synthetic */ void forEachLine$default(File file, String string, Function1 function1, int n) {
        if ((n & 1) != 0) {
            string = "UTF-8";
        }
        IoPackage-Files-251b5338.forEachLine(file, string, function1);
    }

    @NotNull
    public static final List<String> readLines(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="charset") @NotNull String charset) {
        ArrayList rs = new ArrayList();
        IoPackage-Files-251b5338.forEachLine($receiver, charset, new IoPackage$readLines$1(rs));
        return rs;
    }

    public static /* synthetic */ List readLines$default(File file, String string, int n) {
        if ((n & 1) != 0) {
            string = "UTF-8";
        }
        return IoPackage-Files-251b5338.readLines(file, string);
    }

    @Nullable
    public static final File[] listFiles(@JetValueParameter(name="$receiver") File $receiver, @JetValueParameter(name="filter") @NotNull Function1<? super File, ? extends Boolean> filter) {
        return $receiver.listFiles((FileFilter)((Object)new JetObject(filter){
            final /* synthetic */ Function1 $filter;

            public boolean accept(@JetValueParameter(name="file") @NotNull File file) {
                return (Boolean)this.$filter.invoke(file);
            }
            {
                this.$filter = $shared_var$0;
            }
        }));
    }
}

