/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.xmlb.Binding;
import org.jdom.Element;
import org.jdom.Text;

class TagBindingWrapper
implements Binding {
    private final Binding binding;
    private final String myTagName;
    private final String myAttributeName;

    public TagBindingWrapper(Binding binding, String tagName, String attributeName) {
        this.binding = binding;
        assert (binding.getBoundNodeType().isAssignableFrom(Text.class));
        this.myTagName = tagName;
        this.myAttributeName = attributeName;
    }

    @Override
    public Object deserialize(Object context, Object ... nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/xmlb/TagBindingWrapper", "deserialize"));
        }
        assert (nodes.length == 1);
        Element e = (Element)nodes[0];
        Object[] childNodes = !this.myAttributeName.isEmpty() ? new Object[]{e.getAttribute(this.myAttributeName)} : JDOMUtil.getContent(e);
        return this.binding.deserialize(context, childNodes);
    }

    @Override
    public boolean isBoundTo(Object node) {
        return node instanceof Element && ((Element)node).getName().equals(this.myTagName);
    }

    @Override
    public Class getBoundNodeType() {
        return Element.class;
    }

    @Override
    public void init() {
    }
}

