/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.LambdaExpressionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.PsiMethodReferenceCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ExpressionCompatibilityConstraint
extends InputOutputConstraintFormula {
    private final PsiExpression myExpression;
    private PsiType myT;

    public ExpressionCompatibilityConstraint(@NotNull PsiExpression expression, @NotNull PsiType type) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/graphInference/constraints/ExpressionCompatibilityConstraint", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/graphInference/constraints/ExpressionCompatibilityConstraint", "<init>"));
        }
        this.myExpression = expression;
        this.myT = type;
    }

    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        PsiExpression expression;
        if (!PsiPolyExpressionUtil.isPolyExpression(this.myExpression)) {
            if (session.isProperType(this.myT)) {
                return TypeConversionUtil.areTypesAssignmentCompatible(this.myT, this.myExpression);
            }
            PsiType exprType = this.myExpression.getType();
            if (exprType != null && !exprType.equals(PsiType.NULL)) {
                constraints.add(new TypeCompatibilityConstraint(this.myT, exprType));
            }
            return true;
        }
        if (this.myExpression instanceof PsiParenthesizedExpression && (expression = ((PsiParenthesizedExpression)this.myExpression).getExpression()) != null) {
            constraints.add(new ExpressionCompatibilityConstraint(expression, this.myT));
            return true;
        }
        if (this.myExpression instanceof PsiConditionalExpression) {
            PsiExpression elseExpression;
            PsiExpression thenExpression = ((PsiConditionalExpression)this.myExpression).getThenExpression();
            if (thenExpression != null) {
                constraints.add(new ExpressionCompatibilityConstraint(thenExpression, this.myT));
            }
            if ((elseExpression = ((PsiConditionalExpression)this.myExpression).getElseExpression()) != null) {
                constraints.add(new ExpressionCompatibilityConstraint(elseExpression, this.myT));
            }
            return true;
        }
        if (this.myExpression instanceof PsiCallExpression) {
            PsiExpressionList argumentList = ((PsiCallExpression)this.myExpression).getArgumentList();
            if (argumentList != null) {
                PsiElement psiClass;
                PsiJavaCodeReferenceElement classReference;
                Pair<PsiMethod, PsiSubstitutor> pair = MethodCandidateInfo.getCurrentMethod(argumentList);
                if (pair != null) {
                    return true;
                }
                JavaResolveResult resolveResult = ((PsiCallExpression)this.myExpression).resolveMethodGenerics();
                PsiMethod method = (PsiMethod)resolveResult.getElement();
                PsiType returnType = null;
                PsiTypeParameter[] typeParams = null;
                if (method != null && !method.isConstructor()) {
                    returnType = method.getReturnType();
                    if (returnType != null) {
                        typeParams = method.getTypeParameters();
                    }
                } else if (this.myExpression instanceof PsiNewExpression && (classReference = ((PsiNewExpression)this.myExpression).getClassOrAnonymousClassReference()) != null && (psiClass = classReference.resolve()) instanceof PsiClass) {
                    returnType = JavaPsiFacade.getElementFactory(argumentList.getProject()).createType((PsiClass)psiClass, PsiSubstitutor.EMPTY);
                    typeParams = ((PsiClass)psiClass).getTypeParameters();
                }
                if (typeParams != null) {
                    for (PsiTypeParameter typeParam : typeParams) {
                        session.addCapturedVariable(typeParam);
                    }
                    PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
                    if (method != null) {
                        InferenceSession callSession = new InferenceSession(typeParams, ((MethodCandidateInfo)resolveResult).getSiteSubstitutor(), this.myExpression.getManager());
                        PsiExpression[] args = argumentList.getExpressions();
                        PsiParameter[] parameters = method.getParameterList().getParameters();
                        callSession.initExpressionConstraints(parameters, args, this.myExpression);
                        substitutor = callSession.infer(parameters, args, this.myExpression, true);
                    }
                    constraints.add(new TypeCompatibilityConstraint(GenericsUtil.eliminateWildcards(this.myT, false), substitutor.substitute(returnType)));
                }
            }
            return true;
        }
        if (this.myExpression instanceof PsiMethodReferenceExpression) {
            constraints.add(new PsiMethodReferenceCompatibilityConstraint((PsiMethodReferenceExpression)this.myExpression, this.myT));
            return true;
        }
        if (this.myExpression instanceof PsiLambdaExpression) {
            constraints.add(new LambdaExpressionCompatibilityConstraint((PsiLambdaExpression)this.myExpression, this.myT));
            return true;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionCompatibilityConstraint that = (ExpressionCompatibilityConstraint)o;
        if (!this.myExpression.equals(that.myExpression)) {
            return false;
        }
        return this.myT.equals(that.myT);
    }

    public int hashCode() {
        int result = this.myExpression.hashCode();
        result = 31 * result + this.myT.hashCode();
        return result;
    }

    @Override
    public PsiExpression getExpression() {
        return this.myExpression;
    }

    @Override
    public PsiType getT() {
        return this.myT;
    }

    @Override
    protected void setT(PsiType t) {
        this.myT = t;
    }

    @Override
    protected InputOutputConstraintFormula createSelfConstraint(PsiType type, PsiExpression expression) {
        return new ExpressionCompatibilityConstraint(expression, type);
    }

    @Override
    protected void collectReturnTypeVariables(InferenceSession session, PsiExpression psiExpression, PsiType returnType, Set<InferenceVariable> result) {
        if (psiExpression instanceof PsiLambdaExpression && returnType != PsiType.VOID) {
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)psiExpression);
            for (PsiExpression expression : returnExpressions) {
                Set<InferenceVariable> resultInputVars = this.createSelfConstraint(returnType, expression).getInputVariables(session);
                if (resultInputVars == null) continue;
                result.addAll(resultInputVars);
            }
        }
    }
}

