/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.operation;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.operation.AssignmentTranslator;
import org.jetbrains.k2js.translate.reference.CallBuilder;
import org.jetbrains.k2js.translate.utils.BindingUtils;

public final class OverloadedAssignmentTranslator
extends AssignmentTranslator {
    @NotNull
    private final FunctionDescriptor operationDescriptor;

    @NotNull
    public static JsExpression doTranslate(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/operation/OverloadedAssignmentTranslator", "doTranslate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/operation/OverloadedAssignmentTranslator", "doTranslate"));
        }
        JsExpression jsExpression = new OverloadedAssignmentTranslator(expression, context).translate();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/OverloadedAssignmentTranslator", "doTranslate"));
        }
        return jsExpression;
    }

    private OverloadedAssignmentTranslator(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/operation/OverloadedAssignmentTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/operation/OverloadedAssignmentTranslator", "<init>"));
        }
        super(expression, context);
        FunctionDescriptor functionDescriptor = BindingUtils.getFunctionDescriptorForOperationExpression(context.bindingContext(), expression);
        assert (functionDescriptor != null) : "";
        this.operationDescriptor = functionDescriptor;
    }

    @NotNull
    private JsExpression translate() {
        if (this.isVariableReassignment) {
            JsExpression jsExpression = this.reassignment();
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/OverloadedAssignmentTranslator", "translate"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = this.overloadedMethodInvocation();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/OverloadedAssignmentTranslator", "translate"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression reassignment() {
        JsExpression jsExpression = this.accessTranslator.translateAsSet(this.overloadedMethodInvocation());
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/OverloadedAssignmentTranslator", "reassignment"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression overloadedMethodInvocation() {
        JsExpression jsExpression = CallBuilder.build(this.context()).descriptor(this.operationDescriptor).receiver(this.accessTranslator.translateAsGet()).args(this.right).translate();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/OverloadedAssignmentTranslator", "overloadedMethodInvocation"));
        }
        return jsExpression;
    }
}

