/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.operation;

import com.google.common.collect.ImmutableBiMap;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

public final class OperatorTable {
    private static final Map<JetToken, JsBinaryOperator> binaryOperatorsMap = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put(JetTokens.PLUS, JsBinaryOperator.ADD)).put(JetTokens.MINUS, JsBinaryOperator.SUB)).put(JetTokens.MUL, JsBinaryOperator.MUL)).put(JetTokens.DIV, JsBinaryOperator.DIV)).put(JetTokens.EQ, JsBinaryOperator.ASG)).put(JetTokens.GT, JsBinaryOperator.GT)).put(JetTokens.GTEQ, JsBinaryOperator.GTE)).put(JetTokens.LT, JsBinaryOperator.LT)).put(JetTokens.LTEQ, JsBinaryOperator.LTE)).put(JetTokens.ANDAND, JsBinaryOperator.AND)).put(JetTokens.OROR, JsBinaryOperator.OR)).put(JetTokens.PERC, JsBinaryOperator.MOD)).put(JetTokens.PLUSEQ, JsBinaryOperator.ASG_ADD)).put(JetTokens.MINUSEQ, JsBinaryOperator.ASG_SUB)).put(JetTokens.DIVEQ, JsBinaryOperator.ASG_DIV)).put(JetTokens.MULTEQ, JsBinaryOperator.ASG_MUL)).put(JetTokens.PERCEQ, JsBinaryOperator.ASG_MOD)).build();
    private static final ImmutableBiMap<JetToken, JsUnaryOperator> unaryOperatorsMap = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put(JetTokens.PLUSPLUS, JsUnaryOperator.INC)).put(JetTokens.MINUSMINUS, JsUnaryOperator.DEC)).put(JetTokens.EXCL, JsUnaryOperator.NOT)).put(JetTokens.MINUS, JsUnaryOperator.NEG)).put(JetTokens.PLUS, JsUnaryOperator.POS)).build();

    private OperatorTable() {
    }

    public static boolean hasCorrespondingBinaryOperator(@NotNull JetToken token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "org/jetbrains/k2js/translate/operation/OperatorTable", "hasCorrespondingBinaryOperator"));
        }
        return binaryOperatorsMap.containsKey(token);
    }

    @NotNull
    public static JsBinaryOperator getBinaryOperator(@NotNull JetToken token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "org/jetbrains/k2js/translate/operation/OperatorTable", "getBinaryOperator"));
        }
        assert (JetTokens.OPERATIONS.contains(token)) : "Token should represent an operation!";
        JsBinaryOperator jsBinaryOperator = binaryOperatorsMap.get(token);
        if (jsBinaryOperator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/OperatorTable", "getBinaryOperator"));
        }
        return jsBinaryOperator;
    }

    @NotNull
    public static JsUnaryOperator getUnaryOperator(@NotNull JetToken token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "org/jetbrains/k2js/translate/operation/OperatorTable", "getUnaryOperator"));
        }
        assert (JetTokens.OPERATIONS.contains(token)) : "Token should represent an operation!";
        JsUnaryOperator jsUnaryOperator = (JsUnaryOperator)unaryOperatorsMap.get(token);
        if (jsUnaryOperator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/OperatorTable", "getUnaryOperator"));
        }
        return jsUnaryOperator;
    }
}

