/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.lang;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import jet.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.AbstractDescriptorFinder;
import org.jetbrains.jet.descriptors.serialization.ClassData;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.NameSerializationUtil;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotationDeserializer;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedPackageMemberScope;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.AbstractNamespaceDescriptorImpl;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.lang.BuiltInsSerializationUtil;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.storage.NotNullLazyValue;
import org.jetbrains.jet.storage.StorageManager;

class BuiltinsNamespaceDescriptorImpl
extends AbstractNamespaceDescriptorImpl {
    private final DeserializedPackageMemberScope members;
    private final NameResolver nameResolver;

    public BuiltinsNamespaceDescriptorImpl(@NotNull StorageManager storageManager, @NotNull NamespaceDescriptor containingDeclaration) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/lang/types/lang/BuiltinsNamespaceDescriptorImpl", "<init>"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/types/lang/BuiltinsNamespaceDescriptorImpl", "<init>"));
        }
        super(containingDeclaration, Collections.<AnnotationDescriptor>emptyList(), KotlinBuiltIns.BUILT_INS_PACKAGE_NAME);
        this.nameResolver = NameSerializationUtil.deserializeNameResolver(BuiltinsNamespaceDescriptorImpl.getStream(BuiltInsSerializationUtil.getNameTableFilePath(this)));
        this.members = new DeserializedPackageMemberScope(storageManager, this, AnnotationDeserializer.UNSUPPORTED, new BuiltInsDescriptorFinder(storageManager), this.loadPackage(), this.nameResolver);
    }

    @NotNull
    private ProtoBuf.Package loadPackage() {
        ProtoBuf.Package package_;
        String packageFilePath = BuiltInsSerializationUtil.getPackageFilePath(this);
        InputStream stream = BuiltinsNamespaceDescriptorImpl.getStream(packageFilePath);
        try {
            package_ = ProtoBuf.Package.parseFrom(stream);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (package_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsNamespaceDescriptorImpl", "loadPackage"));
        }
        return package_;
    }

    @Override
    @NotNull
    public JetScope getMemberScope() {
        DeserializedPackageMemberScope deserializedPackageMemberScope = this.members;
        if (deserializedPackageMemberScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsNamespaceDescriptorImpl", "getMemberScope"));
        }
        return deserializedPackageMemberScope;
    }

    @Override
    @NotNull
    public FqName getFqName() {
        FqName fqName = KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME;
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsNamespaceDescriptorImpl", "getFqName"));
        }
        return fqName;
    }

    @NotNull
    private static InputStream getStream(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/jet/lang/types/lang/BuiltinsNamespaceDescriptorImpl", "getStream"));
        }
        InputStream stream = BuiltinsNamespaceDescriptorImpl.getStreamNullable(path);
        if (stream == null) {
            throw new IllegalStateException("Resource not found in classpath: " + path);
        }
        InputStream inputStream = stream;
        if (inputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsNamespaceDescriptorImpl", "getStream"));
        }
        return inputStream;
    }

    @Nullable
    private static InputStream getStreamNullable(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/jet/lang/types/lang/BuiltinsNamespaceDescriptorImpl", "getStreamNullable"));
        }
        return KotlinBuiltIns.class.getClassLoader().getResourceAsStream(path);
    }

    private class BuiltInsDescriptorFinder
    extends AbstractDescriptorFinder {
        private final NotNullLazyValue<Collection<Name>> classNames;

        public BuiltInsDescriptorFinder(@NotNull StorageManager storageManager) {
            if (storageManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/lang/types/lang/BuiltinsNamespaceDescriptorImpl$BuiltInsDescriptorFinder", "<init>"));
            }
            super(storageManager, AnnotationDeserializer.UNSUPPORTED);
            this.classNames = storageManager.createLazyValue(new Function0<Collection<Name>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                @Override
                @NotNull
                public Collection<Name> invoke() {
                    InputStream in = BuiltinsNamespaceDescriptorImpl.getStream(BuiltInsSerializationUtil.getClassNamesFilePath(BuiltinsNamespaceDescriptorImpl.this));
                    DataInputStream data2 = new DataInputStream(in);
                    int size = data2.readInt();
                    ArrayList<Name> result = new ArrayList<Name>(size);
                    for (int i = 0; i < size; ++i) {
                        result.add(BuiltinsNamespaceDescriptorImpl.this.nameResolver.getName(data2.readInt()));
                    }
                    ArrayList<Name> arrayList = result;
                    data2.close();
                    ArrayList<Name> arrayList2 = arrayList;
                    if (arrayList2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsNamespaceDescriptorImpl$BuiltInsDescriptorFinder$1", "invoke"));
                    }
                    return arrayList2;
                    {
                        catch (Throwable throwable) {
                            try {
                                data2.close();
                                throw throwable;
                            }
                            catch (IOException e) {
                                throw new IllegalStateException(e);
                            }
                        }
                    }
                }
            });
        }

        @Override
        @Nullable
        protected ClassData getClassData(@NotNull ClassId classId) {
            if (classId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/jet/lang/types/lang/BuiltinsNamespaceDescriptorImpl$BuiltInsDescriptorFinder", "getClassData"));
            }
            InputStream stream = BuiltinsNamespaceDescriptorImpl.getStreamNullable(BuiltInsSerializationUtil.getClassMetadataPath(classId));
            if (stream == null) {
                return null;
            }
            try {
                ProtoBuf.Class classProto = ProtoBuf.Class.parseFrom(stream);
                Name expectedShortName = classId.getRelativeClassName().shortName();
                Name actualShortName = BuiltinsNamespaceDescriptorImpl.this.nameResolver.getClassId(classProto.getFqName()).getRelativeClassName().shortName();
                if (!actualShortName.isSpecial() && !actualShortName.equals(expectedShortName)) {
                    return null;
                }
                return new ClassData(BuiltinsNamespaceDescriptorImpl.this.nameResolver, classProto);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        @Nullable
        public NamespaceDescriptor findPackage(@NotNull FqName fqName) {
            if (fqName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/types/lang/BuiltinsNamespaceDescriptorImpl$BuiltInsDescriptorFinder", "findPackage"));
            }
            return fqName.equals(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME) ? BuiltinsNamespaceDescriptorImpl.this : null;
        }

        @Override
        @NotNull
        public Collection<Name> getClassNames(@NotNull FqName packageName) {
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/jet/lang/types/lang/BuiltinsNamespaceDescriptorImpl$BuiltInsDescriptorFinder", "getClassNames"));
            }
            Collection<Name> collection = packageName.equals(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME) ? this.classNames.invoke() : Collections.emptyList();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/lang/BuiltinsNamespaceDescriptorImpl$BuiltInsDescriptorFinder", "getClassNames"));
            }
            return collection;
        }
    }
}

