/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.types.JetType;

public class JetTypeInfo {
    private final JetType type;
    private final DataFlowInfo dataFlowInfo;

    @NotNull
    public static JetTypeInfo create(@Nullable JetType type, @NotNull DataFlowInfo dataFlowInfo) {
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/types/JetTypeInfo", "create"));
        }
        JetTypeInfo jetTypeInfo = new JetTypeInfo(type, dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/JetTypeInfo", "create"));
        }
        return jetTypeInfo;
    }

    private JetTypeInfo(@Nullable JetType type, @NotNull DataFlowInfo dataFlowInfo) {
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/types/JetTypeInfo", "<init>"));
        }
        this.type = type;
        this.dataFlowInfo = dataFlowInfo;
    }

    @Nullable
    public JetType getType() {
        return this.type;
    }

    @NotNull
    public DataFlowInfo getDataFlowInfo() {
        DataFlowInfo dataFlowInfo = this.dataFlowInfo;
        if (dataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/JetTypeInfo", "getDataFlowInfo"));
        }
        return dataFlowInfo;
    }
}

