/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;

public class DeserializedResolverUtils {
    private DeserializedResolverUtils() {
    }

    @NotNull
    public static FqName kotlinFqNameToJavaFqName(@NotNull FqNameUnsafe kotlinFqName) {
        if (kotlinFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinFqName", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "kotlinFqNameToJavaFqName"));
        }
        ArrayList<String> correctedSegments = new ArrayList<String>();
        for (Name segment : kotlinFqName.pathSegments()) {
            if (segment.asString().startsWith("<class-object-for")) {
                correctedSegments.add("object");
                continue;
            }
            assert (!segment.isSpecial());
            correctedSegments.add(segment.asString());
        }
        FqName fqName = FqName.fromSegments(correctedSegments);
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "kotlinFqNameToJavaFqName"));
        }
        return fqName;
    }

    @NotNull
    public static FqNameUnsafe naiveKotlinFqName(@NotNull ClassDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "naiveKotlinFqName"));
        }
        DeclarationDescriptor containing = descriptor.getContainingDeclaration();
        if (containing instanceof ClassDescriptor) {
            FqNameUnsafe fqNameUnsafe = DeserializedResolverUtils.naiveKotlinFqName((ClassDescriptor)containing).child(descriptor.getName());
            if (fqNameUnsafe == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "naiveKotlinFqName"));
            }
            return fqNameUnsafe;
        }
        if (containing instanceof NamespaceDescriptor) {
            FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFQName(containing).child(descriptor.getName());
            if (fqNameUnsafe == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/DeserializedResolverUtils", "naiveKotlinFqName"));
            }
            return fqNameUnsafe;
        }
        throw new IllegalArgumentException("Class doesn't have a FQ name: " + descriptor);
    }
}

