/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorFactory;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JavaClassFinder;
import org.jetbrains.jet.lang.resolve.java.descriptor.ClassDescriptorFromJvmBytecode;
import org.jetbrains.jet.lang.resolve.java.descriptor.JavaClassDescriptor;
import org.jetbrains.jet.lang.resolve.java.descriptor.JavaEnumClassObjectDescriptor;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaFunctionResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaMemberResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaNamespaceResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaResolverCache;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaSupertypeResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaTypeParameterResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.PostponedTasks;
import org.jetbrains.jet.lang.resolve.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.jet.lang.resolve.java.scope.JavaClassNonStaticMembersScope;
import org.jetbrains.jet.lang.resolve.java.scope.JavaEnumClassObjectScope;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.kotlin.DeserializedDescriptorResolver;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinClassFinder;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public final class JavaClassResolver {
    @NotNull
    private final Map<FqNameUnsafe, ClassDescriptor> classDescriptorCache = new HashMap<FqNameUnsafe, ClassDescriptor>();
    @NotNull
    private final Set<FqNameUnsafe> unresolvedCache = new HashSet<FqNameUnsafe>();
    private JavaResolverCache cache;
    private JavaTypeParameterResolver typeParameterResolver;
    private JavaMemberResolver memberResolver;
    private JavaAnnotationResolver annotationResolver;
    private JavaClassFinder javaClassFinder;
    private JavaNamespaceResolver namespaceResolver;
    private JavaSupertypeResolver supertypesResolver;
    private JavaFunctionResolver functionResolver;
    private DeserializedDescriptorResolver deserializedDescriptorResolver;
    private KotlinClassFinder kotlinClassFinder;

    public void setCache(JavaResolverCache cache) {
        this.cache = cache;
    }

    public void setDeserializedDescriptorResolver(DeserializedDescriptorResolver deserializedDescriptorResolver) {
        this.deserializedDescriptorResolver = deserializedDescriptorResolver;
    }

    public void setTypeParameterResolver(JavaTypeParameterResolver typeParameterResolver) {
        this.typeParameterResolver = typeParameterResolver;
    }

    public void setMemberResolver(JavaMemberResolver memberResolver) {
        this.memberResolver = memberResolver;
    }

    public void setAnnotationResolver(JavaAnnotationResolver annotationResolver) {
        this.annotationResolver = annotationResolver;
    }

    public void setJavaClassFinder(JavaClassFinder javaClassFinder) {
        this.javaClassFinder = javaClassFinder;
    }

    public void setNamespaceResolver(JavaNamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }

    public void setSupertypesResolver(JavaSupertypeResolver supertypesResolver) {
        this.supertypesResolver = supertypesResolver;
    }

    public void setFunctionResolver(JavaFunctionResolver functionResolver) {
        this.functionResolver = functionResolver;
    }

    public void setKotlinClassFinder(KotlinClassFinder kotlinClassFinder) {
        this.kotlinClassFinder = kotlinClassFinder;
    }

    @Nullable
    public ClassDescriptor resolveClass(@NotNull FqName qualifiedName, @NotNull DescriptorSearchRule searchRule) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "resolveClass"));
        }
        if (searchRule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchRule", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "resolveClass"));
        }
        PostponedTasks postponedTasks = new PostponedTasks();
        ClassDescriptor classDescriptor = this.resolveClass(qualifiedName, searchRule, postponedTasks);
        postponedTasks.performTasks();
        return classDescriptor;
    }

    @Nullable
    public ClassDescriptor resolveClass(@NotNull FqName qualifiedName, @NotNull DescriptorSearchRule searchRule, @NotNull PostponedTasks tasks) {
        ClassDescriptor kotlinClassDescriptor;
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "resolveClass"));
        }
        if (searchRule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchRule", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "resolveClass"));
        }
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "resolveClass"));
        }
        if (JavaClassResolver.isTraitImplementation(qualifiedName)) {
            return null;
        }
        ClassDescriptor builtinClassDescriptor = JavaClassResolver.getKotlinBuiltinClassDescriptor(qualifiedName);
        if (builtinClassDescriptor != null) {
            return builtinClassDescriptor;
        }
        if (searchRule == DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES && (kotlinClassDescriptor = this.cache.getClassResolvedFromSource(qualifiedName)) != null) {
            return kotlinClassDescriptor;
        }
        FqNameUnsafe fqName = JavaClassResolver.javaClassToKotlinFqName(qualifiedName);
        ClassDescriptor cachedDescriptor = this.classDescriptorCache.get(fqName);
        if (cachedDescriptor != null) {
            return cachedDescriptor;
        }
        if (this.unresolvedCache.contains(fqName)) {
            return null;
        }
        return this.doResolveClass(qualifiedName, tasks);
    }

    @Nullable
    private static ClassDescriptor getKotlinBuiltinClassDescriptor(@NotNull FqName qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "getKotlinBuiltinClassDescriptor"));
        }
        if (!qualifiedName.firstSegmentIs(KotlinBuiltIns.BUILT_INS_PACKAGE_NAME)) {
            return null;
        }
        List<Name> segments = qualifiedName.pathSegments();
        if (segments.size() < 2) {
            return null;
        }
        JetScope scope = KotlinBuiltIns.getInstance().getBuiltInsScope();
        int size = segments.size();
        for (int i = 1; i < size; ++i) {
            ClassifierDescriptor classifier = scope.getClassifier(segments.get(i));
            if (classifier == null) {
                return null;
            }
            assert (classifier instanceof ClassDescriptor) : "Unexpected classifier in built-ins: " + classifier;
            scope = ((ClassDescriptor)classifier).getUnsubstitutedInnerClassesScope();
        }
        return (ClassDescriptor)scope.getContainingDeclaration();
    }

    private ClassDescriptor doResolveClass(@NotNull FqName qualifiedName, @NotNull PostponedTasks tasks) {
        ClassDescriptor deserializedDescriptor;
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "doResolveClass"));
        }
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "doResolveClass"));
        }
        KotlinJvmBinaryClass kotlinClass = this.kotlinClassFinder.find(qualifiedName);
        if (kotlinClass != null && (deserializedDescriptor = this.deserializedDescriptorResolver.resolveClass(kotlinClass)) != null) {
            this.cache(JavaClassResolver.javaClassToKotlinFqName(qualifiedName), deserializedDescriptor);
            return deserializedDescriptor;
        }
        JavaClass javaClass = this.javaClassFinder.findClass(qualifiedName);
        if (javaClass == null) {
            this.cacheNegativeValue(JavaClassResolver.javaClassToKotlinFqName(qualifiedName));
            return null;
        }
        ClassDescriptor alreadyResolved = this.cache.getClass(javaClass);
        if (alreadyResolved != null) {
            return alreadyResolved;
        }
        ClassOrNamespaceDescriptor containingDeclaration = this.resolveParentDescriptor(qualifiedName, javaClass.getOuterClass());
        ClassDescriptor cachedDescriptor = this.classDescriptorCache.get(JavaClassResolver.javaClassToKotlinFqName(qualifiedName));
        if (cachedDescriptor != null) {
            return cachedDescriptor;
        }
        assert (!this.unresolvedCache.contains(qualifiedName.toUnsafe())) : "We can resolve the class, so it can't be 'unresolved' during parent resolution";
        this.checkFqNamesAreConsistent(javaClass, qualifiedName);
        assert (javaClass.getOriginKind() != JavaClass.OriginKind.KOTLIN_LIGHT_CLASS) : "Trying to resolve a light class as a regular PsiClass: " + javaClass.getFqName();
        return this.doCreateClassDescriptor(qualifiedName, javaClass, tasks, containingDeclaration);
    }

    private void cacheNegativeValue(@NotNull FqNameUnsafe fqNameUnsafe) {
        if (fqNameUnsafe == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqNameUnsafe", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "cacheNegativeValue"));
        }
        if (this.unresolvedCache.contains(fqNameUnsafe) || this.classDescriptorCache.containsKey(fqNameUnsafe)) {
            throw new IllegalStateException("rewrite at " + fqNameUnsafe);
        }
        this.unresolvedCache.add(fqNameUnsafe);
    }

    private static boolean isTraitImplementation(@NotNull FqName qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "isTraitImplementation"));
        }
        return qualifiedName.asString().endsWith("$$TImpl");
    }

    @NotNull
    private JavaClassDescriptor doCreateClassDescriptor(@NotNull FqName fqName, @NotNull JavaClass javaClass, @NotNull PostponedTasks taskList, @NotNull ClassOrNamespaceDescriptor containingDeclaration) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "doCreateClassDescriptor"));
        }
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "doCreateClassDescriptor"));
        }
        if (taskList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskList", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "doCreateClassDescriptor"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "doCreateClassDescriptor"));
        }
        ClassDescriptorFromJvmBytecode classDescriptor = new ClassDescriptorFromJvmBytecode(containingDeclaration, javaClass.getName(), JavaClassResolver.determineClassKind(javaClass), JavaClassResolver.isInnerClass(javaClass));
        this.cache(JavaClassResolver.javaClassToKotlinFqName(fqName), classDescriptor);
        JavaTypeParameterResolver.Initializer typeParameterInitializer = this.typeParameterResolver.resolveTypeParameters(classDescriptor, javaClass);
        classDescriptor.setTypeParameterDescriptors(typeParameterInitializer.getDescriptors());
        ArrayList<JetType> supertypes = new ArrayList<JetType>();
        classDescriptor.setSupertypes(supertypes);
        classDescriptor.setVisibility(javaClass.getVisibility());
        classDescriptor.setModality(JavaClassResolver.determineClassModality(javaClass));
        classDescriptor.createTypeConstructor();
        JavaClassNonStaticMembersScope scope = new JavaClassNonStaticMembersScope(classDescriptor, javaClass, this.memberResolver);
        classDescriptor.setScopeForMemberLookup(scope);
        classDescriptor.setScopeForConstructorResolve(scope);
        typeParameterInitializer.initialize();
        List<TypeParameterDescriptor> classTypeParameters = classDescriptor.getTypeConstructor().getParameters();
        supertypes.addAll(this.supertypesResolver.getSupertypes(classDescriptor, javaClass, classTypeParameters));
        if (javaClass.isEnum()) {
            JavaEnumClassObjectDescriptor enumClassObject = this.createEnumClassObject(classDescriptor, javaClass);
            JavaClassResolver.createEnumSyntheticMethods(enumClassObject, classDescriptor.getDefaultType());
            this.cache(JavaClassResolver.getFqNameForClassObject(javaClass), enumClassObject);
            classDescriptor.getBuilder().setClassObjectDescriptor(enumClassObject);
        }
        classDescriptor.setAnnotations(this.annotationResolver.resolveAnnotations(javaClass, taskList));
        this.cache.recordClass(javaClass, classDescriptor);
        JavaMethod samInterfaceMethod = SingleAbstractMethodUtils.getSamInterfaceMethod(javaClass);
        if (samInterfaceMethod != null) {
            SimpleFunctionDescriptor abstractMethod = this.resolveFunctionOfSamInterface(samInterfaceMethod, classDescriptor);
            classDescriptor.setFunctionTypeForSamInterface(SingleAbstractMethodUtils.getFunctionTypeForAbstractMethod(abstractMethod));
        }
        ClassDescriptorFromJvmBytecode classDescriptorFromJvmBytecode = classDescriptor;
        if (classDescriptorFromJvmBytecode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "doCreateClassDescriptor"));
        }
        return classDescriptorFromJvmBytecode;
    }

    @NotNull
    private static ClassKind determineClassKind(@NotNull JavaClass klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "determineClassKind"));
        }
        if (klass.isInterface()) {
            ClassKind classKind = klass.isAnnotationType() ? ClassKind.ANNOTATION_CLASS : ClassKind.TRAIT;
            if (classKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "determineClassKind"));
            }
            return classKind;
        }
        ClassKind classKind = klass.isEnum() ? ClassKind.ENUM_CLASS : ClassKind.CLASS;
        if (classKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "determineClassKind"));
        }
        return classKind;
    }

    @NotNull
    private static Modality determineClassModality(@NotNull JavaClass klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "determineClassModality"));
        }
        Modality modality = klass.isAnnotationType() ? Modality.FINAL : Modality.convertFromFlags(klass.isAbstract() || klass.isInterface(), !klass.isFinal());
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "determineClassModality"));
        }
        return modality;
    }

    @NotNull
    private static FqNameUnsafe getFqNameForClassObject(@NotNull JavaClass javaClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "getFqNameForClassObject"));
        }
        FqName fqName = javaClass.getFqName();
        assert (fqName != null) : "Reading java class with no qualified name";
        FqNameUnsafe fqNameUnsafe = fqName.toUnsafe().child(DescriptorUtils.getClassObjectName(javaClass.getName()));
        if (fqNameUnsafe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "getFqNameForClassObject"));
        }
        return fqNameUnsafe;
    }

    @NotNull
    private SimpleFunctionDescriptor resolveFunctionOfSamInterface(@NotNull JavaMethod samInterfaceMethod, @NotNull JavaClassDescriptor samInterface) {
        if (samInterfaceMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "samInterfaceMethod", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "resolveFunctionOfSamInterface"));
        }
        if (samInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "samInterface", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "resolveFunctionOfSamInterface"));
        }
        JavaClass methodContainer = samInterfaceMethod.getContainingClass();
        FqName containerFqName = methodContainer.getFqName();
        assert (containerFqName != null) : "qualified name is null for " + methodContainer;
        if (DescriptorUtils.getFQName(samInterface).equalsTo(containerFqName)) {
            SimpleFunctionDescriptor abstractMethod = this.functionResolver.resolveFunctionMutely(samInterfaceMethod, samInterface);
            assert (abstractMethod != null) : "couldn't resolve method " + samInterfaceMethod;
            SimpleFunctionDescriptor simpleFunctionDescriptor = abstractMethod;
            if (simpleFunctionDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "resolveFunctionOfSamInterface"));
            }
            return simpleFunctionDescriptor;
        }
        SimpleFunctionDescriptor simpleFunctionDescriptor = JavaClassResolver.findFunctionWithMostSpecificReturnType(TypeUtils.getAllSupertypes(samInterface.getDefaultType()));
        if (simpleFunctionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "resolveFunctionOfSamInterface"));
        }
        return simpleFunctionDescriptor;
    }

    @NotNull
    private static SimpleFunctionDescriptor findFunctionWithMostSpecificReturnType(@NotNull Set<JetType> supertypes) {
        if (supertypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "findFunctionWithMostSpecificReturnType"));
        }
        ArrayList<SimpleFunctionDescriptor> candidates = new ArrayList<SimpleFunctionDescriptor>(supertypes.size());
        for (JetType supertype : supertypes) {
            List<CallableMemberDescriptor> abstractMembers = SingleAbstractMethodUtils.getAbstractMembers(supertype);
            if (abstractMembers.isEmpty()) continue;
            candidates.add((SimpleFunctionDescriptor)abstractMembers.get(0));
        }
        if (candidates.isEmpty()) {
            throw new IllegalStateException("Couldn't find abstract method in supertypes " + supertypes);
        }
        SimpleFunctionDescriptor currentMostSpecificType = (SimpleFunctionDescriptor)candidates.get(0);
        for (SimpleFunctionDescriptor candidate : candidates) {
            JetType candidateReturnType = candidate.getReturnType();
            JetType currentMostSpecificReturnType = currentMostSpecificType.getReturnType();
            assert (candidateReturnType != null && currentMostSpecificReturnType != null) : candidate + ", " + currentMostSpecificReturnType;
            if (!JetTypeChecker.INSTANCE.isSubtypeOf(candidateReturnType, currentMostSpecificReturnType)) continue;
            currentMostSpecificType = candidate;
        }
        SimpleFunctionDescriptor simpleFunctionDescriptor = currentMostSpecificType;
        if (simpleFunctionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "findFunctionWithMostSpecificReturnType"));
        }
        return simpleFunctionDescriptor;
    }

    private void cache(@NotNull FqNameUnsafe fqName, @Nullable ClassDescriptor classDescriptor) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "cache"));
        }
        if (classDescriptor == null) {
            this.cacheNegativeValue(fqName);
        } else {
            ClassDescriptor oldValue = this.classDescriptorCache.put(fqName, classDescriptor);
            assert (oldValue == null);
        }
    }

    private void checkFqNamesAreConsistent(@NotNull JavaClass javaClass, @NotNull FqName desiredFqName) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "checkFqNamesAreConsistent"));
        }
        if (desiredFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desiredFqName", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "checkFqNamesAreConsistent"));
        }
        FqName fqName = javaClass.getFqName();
        assert (desiredFqName.equals(fqName)) : "Inconsistent FQ names: " + fqName + ", " + desiredFqName;
        FqNameUnsafe correctedName = JavaClassResolver.javaClassToKotlinFqName(fqName);
        if (this.classDescriptorCache.containsKey(correctedName) || this.unresolvedCache.contains(correctedName)) {
            throw new IllegalStateException("Cache already contains FQ name: " + fqName.asString());
        }
    }

    @NotNull
    private ClassOrNamespaceDescriptor resolveParentDescriptor(@NotNull FqName childClassFQName, JavaClass parentClass) {
        if (childClassFQName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childClassFQName", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "resolveParentDescriptor"));
        }
        if (parentClass != null) {
            FqName parentFqName = parentClass.getFqName();
            ClassDescriptor parentClassDescriptor = this.resolveClass(parentFqName, DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES);
            if (parentClassDescriptor == null) {
                throw new IllegalStateException("Could not resolve " + parentFqName + " required to be parent for " + childClassFQName);
            }
            ClassDescriptor classDescriptor = parentClassDescriptor;
            if (classDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "resolveParentDescriptor"));
            }
            return classDescriptor;
        }
        FqName parentFqName = childClassFQName.parent();
        NamespaceDescriptor parentNamespace = this.namespaceResolver.resolveNamespace(parentFqName, DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES);
        if (parentNamespace == null) {
            throw new IllegalStateException("Could not resolve " + parentFqName + " required to be parent for " + childClassFQName);
        }
        NamespaceDescriptor namespaceDescriptor = parentNamespace;
        if (namespaceDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "resolveParentDescriptor"));
        }
        return namespaceDescriptor;
    }

    @NotNull
    private static FqNameUnsafe javaClassToKotlinFqName(@NotNull FqName rawFqName) {
        if (rawFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawFqName", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "javaClassToKotlinFqName"));
        }
        ArrayList<Name> correctedSegments = new ArrayList<Name>();
        for (Name segment : rawFqName.pathSegments()) {
            if ("object".equals(segment.asString())) {
                assert (!correctedSegments.isEmpty());
                Name previous = (Name)correctedSegments.get(correctedSegments.size() - 1);
                correctedSegments.add(DescriptorUtils.getClassObjectName(previous));
                continue;
            }
            correctedSegments.add(segment);
        }
        FqNameUnsafe fqNameUnsafe = FqNameUnsafe.fromSegments(correctedSegments);
        if (fqNameUnsafe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "javaClassToKotlinFqName"));
        }
        return fqNameUnsafe;
    }

    private static boolean isInnerClass(@NotNull JavaClass javaClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "isInnerClass"));
        }
        return javaClass.getOuterClass() != null && !javaClass.isStatic();
    }

    private static void createEnumSyntheticMethods(@NotNull JavaEnumClassObjectDescriptor classObject, @NotNull JetType enumType) {
        if (classObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObject", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "createEnumSyntheticMethods"));
        }
        if (enumType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumType", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "createEnumSyntheticMethods"));
        }
        JetType valuesReturnType = KotlinBuiltIns.getInstance().getArrayType(enumType);
        SimpleFunctionDescriptor valuesMethod = DescriptorFactory.createEnumClassObjectValuesMethod(classObject, valuesReturnType);
        classObject.getBuilder().addFunctionDescriptor(valuesMethod);
        SimpleFunctionDescriptor valueOfMethod = DescriptorFactory.createEnumClassObjectValueOfMethod(classObject, enumType);
        classObject.getBuilder().addFunctionDescriptor(valueOfMethod);
    }

    @NotNull
    private JavaEnumClassObjectDescriptor createEnumClassObject(@NotNull ClassDescriptor enumClass, @NotNull JavaClass javaClass) {
        if (enumClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClass", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "createEnumClassObject"));
        }
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "createEnumClassObject"));
        }
        JavaEnumClassObjectDescriptor classObject = new JavaEnumClassObjectDescriptor(enumClass);
        classObject.setModality(Modality.FINAL);
        classObject.setVisibility(enumClass.getVisibility());
        classObject.setTypeParameterDescriptors(Collections.<TypeParameterDescriptor>emptyList());
        classObject.createTypeConstructor();
        JavaEnumClassObjectScope scope = new JavaEnumClassObjectScope((ClassOrNamespaceDescriptor)classObject, javaClass, this.memberResolver);
        WritableScopeImpl writableScope = new WritableScopeImpl(scope, classObject, RedeclarationHandler.THROW_EXCEPTION, "Enum class object scope");
        writableScope.changeLockLevel(WritableScope.LockLevel.BOTH);
        classObject.setScopeForMemberLookup(writableScope);
        JavaEnumClassObjectDescriptor javaEnumClassObjectDescriptor = classObject;
        if (javaEnumClassObjectDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/resolver/JavaClassResolver", "createEnumClassObject"));
        }
        return javaEnumClassObjectDescriptor;
    }
}

