/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.util;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetCallElement;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.JetValueArgumentName;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;

public class CallMaker {
    public static Call makeCallWithExpressions(@NotNull JetElement callElement, @NotNull ReceiverValue explicitReceiver, @Nullable ASTNode callOperationNode, @NotNull JetExpression calleeExpression, @NotNull List<JetExpression> argumentExpressions) {
        if (callElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makeCallWithExpressions"));
        }
        if (explicitReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiver", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makeCallWithExpressions"));
        }
        if (calleeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calleeExpression", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makeCallWithExpressions"));
        }
        if (argumentExpressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentExpressions", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makeCallWithExpressions"));
        }
        return CallMaker.makeCallWithExpressions(callElement, explicitReceiver, callOperationNode, calleeExpression, argumentExpressions, Call.CallType.DEFAULT);
    }

    public static Call makeCallWithExpressions(@NotNull JetElement callElement, @NotNull ReceiverValue explicitReceiver, @Nullable ASTNode callOperationNode, @NotNull JetExpression calleeExpression, @NotNull List<JetExpression> argumentExpressions, @NotNull Call.CallType callType) {
        if (callElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makeCallWithExpressions"));
        }
        if (explicitReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiver", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makeCallWithExpressions"));
        }
        if (calleeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calleeExpression", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makeCallWithExpressions"));
        }
        if (argumentExpressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentExpressions", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makeCallWithExpressions"));
        }
        if (callType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callType", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makeCallWithExpressions"));
        }
        ArrayList<ValueArgument> arguments = Lists.newArrayList();
        for (JetExpression argumentExpression : argumentExpressions) {
            arguments.add(CallMaker.makeValueArgument(argumentExpression, calleeExpression));
        }
        return CallMaker.makeCall(callElement, explicitReceiver, callOperationNode, calleeExpression, arguments, callType);
    }

    public static Call makeCall(JetElement callElement, ReceiverValue explicitReceiver, @Nullable ASTNode callOperationNode, JetExpression calleeExpression, List<? extends ValueArgument> arguments) {
        return CallMaker.makeCall(callElement, explicitReceiver, callOperationNode, calleeExpression, arguments, Call.CallType.DEFAULT);
    }

    public static Call makeCall(JetElement callElement, ReceiverValue explicitReceiver, @Nullable ASTNode callOperationNode, JetExpression calleeExpression, List<? extends ValueArgument> arguments, Call.CallType callType) {
        return new CallImpl(callElement, explicitReceiver, callOperationNode, calleeExpression, arguments, callType);
    }

    public static Call makeCall(@NotNull ReceiverValue leftAsReceiver, JetBinaryExpression expression) {
        if (leftAsReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftAsReceiver", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makeCall"));
        }
        return CallMaker.makeCallWithExpressions(expression, leftAsReceiver, null, expression.getOperationReference(), Collections.singletonList(expression.getRight()));
    }

    public static Call makeCall(@NotNull ReceiverValue baseAsReceiver, JetUnaryExpression expression) {
        if (baseAsReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseAsReceiver", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makeCall"));
        }
        return CallMaker.makeCall(expression, baseAsReceiver, null, expression.getOperationReference(), Collections.emptyList());
    }

    public static Call makeArraySetCall(@NotNull ReceiverValue arrayAsReceiver, @NotNull JetArrayAccessExpression arrayAccessExpression, @NotNull JetExpression rightHandSide, @NotNull Call.CallType callType) {
        if (arrayAsReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAsReceiver", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makeArraySetCall"));
        }
        if (arrayAccessExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAccessExpression", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makeArraySetCall"));
        }
        if (rightHandSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightHandSide", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makeArraySetCall"));
        }
        if (callType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callType", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makeArraySetCall"));
        }
        ArrayList<JetExpression> arguments = Lists.newArrayList(arrayAccessExpression.getIndexExpressions());
        arguments.add(rightHandSide);
        return CallMaker.makeCallWithExpressions(arrayAccessExpression, arrayAsReceiver, null, arrayAccessExpression, arguments, callType);
    }

    public static Call makeArrayGetCall(@NotNull ReceiverValue arrayAsReceiver, @NotNull JetArrayAccessExpression arrayAccessExpression, @NotNull Call.CallType callType) {
        if (arrayAsReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAsReceiver", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makeArrayGetCall"));
        }
        if (arrayAccessExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAccessExpression", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makeArrayGetCall"));
        }
        if (callType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callType", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makeArrayGetCall"));
        }
        return CallMaker.makeCallWithExpressions(arrayAccessExpression, arrayAsReceiver, null, arrayAccessExpression, arrayAccessExpression.getIndexExpressions(), callType);
    }

    public static ValueArgument makeValueArgument(@NotNull JetExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makeValueArgument"));
        }
        return CallMaker.makeValueArgument(expression, expression);
    }

    public static ValueArgument makeValueArgument(@Nullable JetExpression expression, @NotNull PsiElement reportErrorsOn) {
        if (reportErrorsOn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportErrorsOn", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makeValueArgument"));
        }
        return new ExpressionValueArgument(expression, reportErrorsOn);
    }

    public static Call makePropertyCall(@NotNull ReceiverValue explicitReceiver, @Nullable ASTNode callOperationNode, @NotNull JetSimpleNameExpression nameExpression) {
        if (explicitReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiver", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makePropertyCall"));
        }
        if (nameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameExpression", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makePropertyCall"));
        }
        return CallMaker.makeCallWithExpressions(nameExpression, explicitReceiver, callOperationNode, nameExpression, Collections.<JetExpression>emptyList());
    }

    public static Call makeCall(final @NotNull ReceiverValue explicitReceiver, final @Nullable ASTNode callOperationNode, final @NotNull JetCallElement callElement) {
        if (explicitReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiver", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makeCall"));
        }
        if (callElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makeCall"));
        }
        return new Call(){

            @Override
            public ASTNode getCallOperationNode() {
                return callOperationNode;
            }

            @Override
            @NotNull
            public ReceiverValue getExplicitReceiver() {
                ReceiverValue receiverValue = explicitReceiver;
                if (receiverValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker$1", "getExplicitReceiver"));
                }
                return receiverValue;
            }

            @Override
            @NotNull
            public ReceiverValue getThisObject() {
                ReceiverValue receiverValue = ReceiverValue.NO_RECEIVER;
                if (receiverValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker$1", "getThisObject"));
                }
                return receiverValue;
            }

            @Override
            @Nullable
            public JetExpression getCalleeExpression() {
                return callElement.getCalleeExpression();
            }

            @Override
            @Nullable
            public JetValueArgumentList getValueArgumentList() {
                return callElement.getValueArgumentList();
            }

            @Override
            @NotNull
            public List<? extends ValueArgument> getValueArguments() {
                List<? extends ValueArgument> list2 = callElement.getValueArguments();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker$1", "getValueArguments"));
                }
                return list2;
            }

            @Override
            @NotNull
            public List<JetExpression> getFunctionLiteralArguments() {
                List<JetExpression> list2 = callElement.getFunctionLiteralArguments();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker$1", "getFunctionLiteralArguments"));
                }
                return list2;
            }

            @Override
            @NotNull
            public List<JetTypeProjection> getTypeArguments() {
                List<JetTypeProjection> list2 = callElement.getTypeArguments();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker$1", "getTypeArguments"));
                }
                return list2;
            }

            @Override
            @Nullable
            public JetTypeArgumentList getTypeArgumentList() {
                return callElement.getTypeArgumentList();
            }

            @Override
            @NotNull
            public PsiElement getCallElement() {
                JetCallElement jetCallElement = callElement;
                if (jetCallElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker$1", "getCallElement"));
                }
                return jetCallElement;
            }

            public String toString() {
                return callElement.getText();
            }

            @Override
            @NotNull
            public Call.CallType getCallType() {
                Call.CallType callType = Call.CallType.DEFAULT;
                if (callType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker$1", "getCallType"));
                }
                return callType;
            }
        };
    }

    public static Call makeCall(@NotNull JetElement callElement, @NotNull ReceiverValue explicitReceiver) {
        if (callElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makeCall"));
        }
        if (explicitReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiver", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker", "makeCall"));
        }
        return new CallImpl(callElement, explicitReceiver, null, null, Collections.emptyList());
    }

    private static class CallImpl
    implements Call {
        private final PsiElement callElement;
        private final ReceiverValue explicitReceiver;
        private final ASTNode callOperationNode;
        private final JetExpression calleeExpression;
        private final List<? extends ValueArgument> valueArguments;
        private final Call.CallType callType;

        protected CallImpl(@NotNull PsiElement callElement, @NotNull ReceiverValue explicitReceiver, @Nullable ASTNode callOperationNode, @Nullable JetExpression calleeExpression, @NotNull List<? extends ValueArgument> valueArguments) {
            if (callElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker$CallImpl", "<init>"));
            }
            if (explicitReceiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiver", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker$CallImpl", "<init>"));
            }
            if (valueArguments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArguments", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker$CallImpl", "<init>"));
            }
            this(callElement, explicitReceiver, callOperationNode, calleeExpression, valueArguments, Call.CallType.DEFAULT);
        }

        protected CallImpl(@NotNull PsiElement callElement, @NotNull ReceiverValue explicitReceiver, @Nullable ASTNode callOperationNode, @Nullable JetExpression calleeExpression, @NotNull List<? extends ValueArgument> valueArguments, @NotNull Call.CallType callType) {
            if (callElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker$CallImpl", "<init>"));
            }
            if (explicitReceiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "explicitReceiver", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker$CallImpl", "<init>"));
            }
            if (valueArguments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArguments", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker$CallImpl", "<init>"));
            }
            if (callType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callType", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker$CallImpl", "<init>"));
            }
            this.callElement = callElement;
            this.explicitReceiver = explicitReceiver;
            this.callOperationNode = callOperationNode;
            this.calleeExpression = calleeExpression;
            this.valueArguments = valueArguments;
            this.callType = callType;
        }

        @Override
        public ASTNode getCallOperationNode() {
            return this.callOperationNode;
        }

        @Override
        @NotNull
        public ReceiverValue getExplicitReceiver() {
            ReceiverValue receiverValue = this.explicitReceiver;
            if (receiverValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker$CallImpl", "getExplicitReceiver"));
            }
            return receiverValue;
        }

        @Override
        @NotNull
        public ReceiverValue getThisObject() {
            ReceiverValue receiverValue = ReceiverValue.NO_RECEIVER;
            if (receiverValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker$CallImpl", "getThisObject"));
            }
            return receiverValue;
        }

        @Override
        public JetExpression getCalleeExpression() {
            return this.calleeExpression;
        }

        @Override
        @NotNull
        public List<? extends ValueArgument> getValueArguments() {
            List<? extends ValueArgument> list2 = this.valueArguments;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker$CallImpl", "getValueArguments"));
            }
            return list2;
        }

        @Override
        @NotNull
        public PsiElement getCallElement() {
            PsiElement psiElement = this.callElement;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker$CallImpl", "getCallElement"));
            }
            return psiElement;
        }

        @Override
        public JetValueArgumentList getValueArgumentList() {
            return null;
        }

        @Override
        @NotNull
        public List<JetExpression> getFunctionLiteralArguments() {
            List<JetExpression> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker$CallImpl", "getFunctionLiteralArguments"));
            }
            return list2;
        }

        @Override
        @NotNull
        public List<JetTypeProjection> getTypeArguments() {
            List<JetTypeProjection> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker$CallImpl", "getTypeArguments"));
            }
            return list2;
        }

        @Override
        public JetTypeArgumentList getTypeArgumentList() {
            return null;
        }

        public String toString() {
            return this.getCallElement().getText();
        }

        @Override
        @NotNull
        public Call.CallType getCallType() {
            Call.CallType callType = this.callType;
            if (callType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker$CallImpl", "getCallType"));
            }
            return callType;
        }
    }

    private static class ExpressionValueArgument
    implements ValueArgument {
        private final JetExpression expression;
        private final PsiElement reportErrorsOn;

        private ExpressionValueArgument(@Nullable JetExpression expression, @NotNull PsiElement reportErrorsOn) {
            if (reportErrorsOn == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reportErrorsOn", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker$ExpressionValueArgument", "<init>"));
            }
            this.expression = expression;
            this.reportErrorsOn = expression == null ? reportErrorsOn : expression;
        }

        @Override
        public JetExpression getArgumentExpression() {
            return this.expression;
        }

        @Override
        public JetValueArgumentName getArgumentName() {
            return null;
        }

        @Override
        public boolean isNamed() {
            return false;
        }

        @Override
        @NotNull
        public PsiElement asElement() {
            PsiElement psiElement = this.reportErrorsOn;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/util/CallMaker$ExpressionValueArgument", "asElement"));
            }
            return psiElement;
        }

        @Override
        public LeafPsiElement getSpreadElement() {
            return null;
        }
    }
}

