/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.inference;

import java.text.MessageFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.calls.inference.SubtypingConstraint;
import org.jetbrains.jet.lang.types.JetType;

public enum ConstraintType implements Comparable<ConstraintType>
{
    RECEIVER("{0} is not a subtype of the expected receiver type {1}"),
    VALUE_ARGUMENT("Type mismatch: argument type is {0}, but {1} was expected"),
    EXPECTED_TYPE("Resulting type is {0} but {1} was expected"),
    PARAMETER_BOUND("Type parameter bound is not satisfied: {0} is not a subtype of {1}");

    private final String errorMessageTemplate;

    private ConstraintType(@NotNull String errorMessageTemplate) {
        if (errorMessageTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessageTemplate", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintType", "<init>"));
        }
        this.errorMessageTemplate = errorMessageTemplate;
    }

    @NotNull
    public SubtypingConstraint assertSubtyping(@NotNull JetType subtype, @NotNull JetType supertype) {
        if (subtype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtype", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintType", "assertSubtyping"));
        }
        if (supertype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertype", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintType", "assertSubtyping"));
        }
        SubtypingConstraint subtypingConstraint = new SubtypingConstraint(this, subtype, supertype);
        if (subtypingConstraint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintType", "assertSubtyping"));
        }
        return subtypingConstraint;
    }

    @NotNull
    public String makeErrorMessage(@NotNull SubtypingConstraint constraint) {
        if (constraint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraint", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintType", "makeErrorMessage"));
        }
        String string = MessageFormat.format(this.errorMessageTemplate, constraint.getSubtype(), constraint.getSupertype());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintType", "makeErrorMessage"));
        }
        return string;
    }
}

