/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.calls.CallResolverExtension;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.context.ContextDependency;
import org.jetbrains.jet.lang.resolve.calls.context.ExpressionPosition;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.jet.lang.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.LabelResolver;

public abstract class ResolutionContext<Context extends ResolutionContext<Context>> {
    public final BindingTrace trace;
    public final JetScope scope;
    public final JetType expectedType;
    public final DataFlowInfo dataFlowInfo;
    public final ExpressionPosition expressionPosition;
    public final ContextDependency contextDependency;
    public final ResolutionResultsCache resolutionResultsCache;
    public final LabelResolver labelResolver;
    public final CallResolverExtension callResolverExtension;

    protected ResolutionContext(@NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull JetType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull ExpressionPosition expressionPosition, @NotNull ContextDependency contextDependency, @NotNull ResolutionResultsCache resolutionResultsCache, @NotNull LabelResolver labelResolver, @NotNull CallResolverExtension callResolverExtension) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "<init>"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "<init>"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "<init>"));
        }
        if (expressionPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionPosition", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "<init>"));
        }
        if (contextDependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextDependency", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "<init>"));
        }
        if (resolutionResultsCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionResultsCache", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "<init>"));
        }
        if (labelResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelResolver", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "<init>"));
        }
        if (callResolverExtension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callResolverExtension", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "<init>"));
        }
        this.trace = trace;
        this.scope = scope;
        this.expectedType = expectedType;
        this.dataFlowInfo = dataFlowInfo;
        this.expressionPosition = expressionPosition;
        this.contextDependency = contextDependency;
        this.resolutionResultsCache = resolutionResultsCache;
        this.labelResolver = labelResolver;
        this.callResolverExtension = callResolverExtension;
    }

    protected abstract Context create(@NotNull BindingTrace var1, @NotNull JetScope var2, @NotNull DataFlowInfo var3, @NotNull JetType var4, @NotNull ExpressionPosition var5, @NotNull ContextDependency var6, @NotNull ResolutionResultsCache var7, @NotNull LabelResolver var8);

    protected abstract Context self();

    public Context replaceBindingTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "replaceBindingTrace"));
        }
        if (this.trace == trace) {
            return this.self();
        }
        return this.create(trace, this.scope, this.dataFlowInfo, this.expectedType, this.expressionPosition, this.contextDependency, this.resolutionResultsCache, this.labelResolver);
    }

    @NotNull
    public Context replaceExpressionPosition(@NotNull ExpressionPosition expressionPosition) {
        if (expressionPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionPosition", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "replaceExpressionPosition"));
        }
        if (expressionPosition == this.expressionPosition) {
            Context Context2 = this.self();
            if (Context2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "replaceExpressionPosition"));
            }
            return Context2;
        }
        Context Context3 = this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, expressionPosition, this.contextDependency, this.resolutionResultsCache, this.labelResolver);
        if (Context3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "replaceExpressionPosition"));
        }
        return Context3;
    }

    @NotNull
    public Context replaceDataFlowInfo(@NotNull DataFlowInfo newDataFlowInfo) {
        if (newDataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDataFlowInfo", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "replaceDataFlowInfo"));
        }
        if (newDataFlowInfo == this.dataFlowInfo) {
            Context Context2 = this.self();
            if (Context2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "replaceDataFlowInfo"));
            }
            return Context2;
        }
        Context Context3 = this.create(this.trace, this.scope, newDataFlowInfo, this.expectedType, this.expressionPosition, this.contextDependency, this.resolutionResultsCache, this.labelResolver);
        if (Context3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "replaceDataFlowInfo"));
        }
        return Context3;
    }

    @NotNull
    public Context replaceExpectedType(@Nullable JetType newExpectedType) {
        if (newExpectedType == null) {
            Context Context2 = this.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
            if (Context2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "replaceExpectedType"));
            }
            return Context2;
        }
        if (this.expectedType == newExpectedType) {
            Context Context3 = this.self();
            if (Context3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "replaceExpectedType"));
            }
            return Context3;
        }
        Context Context4 = this.create(this.trace, this.scope, this.dataFlowInfo, newExpectedType, this.expressionPosition, this.contextDependency, this.resolutionResultsCache, this.labelResolver);
        if (Context4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "replaceExpectedType"));
        }
        return Context4;
    }

    @NotNull
    public Context replaceScope(@NotNull JetScope newScope) {
        if (newScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newScope", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "replaceScope"));
        }
        if (newScope == this.scope) {
            Context Context2 = this.self();
            if (Context2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "replaceScope"));
            }
            return Context2;
        }
        Context Context3 = this.create(this.trace, newScope, this.dataFlowInfo, this.expectedType, this.expressionPosition, this.contextDependency, this.resolutionResultsCache, this.labelResolver);
        if (Context3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "replaceScope"));
        }
        return Context3;
    }

    @NotNull
    public Context replaceContextDependency(@NotNull ContextDependency newContextDependency) {
        if (newContextDependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContextDependency", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "replaceContextDependency"));
        }
        if (newContextDependency == this.contextDependency) {
            Context Context2 = this.self();
            if (Context2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "replaceContextDependency"));
            }
            return Context2;
        }
        Context Context3 = this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, this.expressionPosition, newContextDependency, this.resolutionResultsCache, this.labelResolver);
        if (Context3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "replaceContextDependency"));
        }
        return Context3;
    }

    @NotNull
    public Context replaceResolutionResultsCache(@NotNull ResolutionResultsCache newResolutionResultsCache) {
        if (newResolutionResultsCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newResolutionResultsCache", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "replaceResolutionResultsCache"));
        }
        if (newResolutionResultsCache == this.resolutionResultsCache) {
            Context Context2 = this.self();
            if (Context2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "replaceResolutionResultsCache"));
            }
            return Context2;
        }
        Context Context3 = this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, this.expressionPosition, this.contextDependency, newResolutionResultsCache, this.labelResolver);
        if (Context3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "replaceResolutionResultsCache"));
        }
        return Context3;
    }

    public Context replaceTraceAndCache(@NotNull TemporaryTraceAndCache traceAndCache) {
        if (traceAndCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceAndCache", "org/jetbrains/jet/lang/resolve/calls/context/ResolutionContext", "replaceTraceAndCache"));
        }
        return ((ResolutionContext)this.replaceBindingTrace(traceAndCache.trace)).replaceResolutionResultsCache(traceAndCache.cache);
    }
}

