/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.resolve.calls.CallResolverExtension;
import org.jetbrains.jet.lang.resolve.calls.CompositeExtension;
import org.jetbrains.jet.lang.resolve.calls.NeedSyntheticCallResolverExtension;
import org.jetbrains.jet.lang.resolve.calls.TypeParameterAsReifiedCheck;

public class CallResolverExtensionProvider {
    private static final CompositeExtension DEFAULT = new CompositeExtension(Arrays.asList(new NeedSyntheticCallResolverExtension(), new TypeParameterAsReifiedCheck()));
    private WeakReference<Map<DeclarationDescriptor, List<CallResolverExtension>>> extensionsCache;

    @NotNull
    public CallResolverExtension createExtension(@Nullable DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            CompositeExtension compositeExtension = DEFAULT;
            if (compositeExtension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolverExtensionProvider", "createExtension"));
            }
            return compositeExtension;
        }
        CompositeExtension compositeExtension = new CompositeExtension(this.createExtensions(descriptor));
        if (compositeExtension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolverExtensionProvider", "createExtension"));
        }
        return compositeExtension;
    }

    @NotNull
    private List<CallResolverExtension> createExtensions(@NotNull DeclarationDescriptor declaration) {
        ArrayList<CallResolverExtension> extensions;
        Map<DeclarationDescriptor, List<CallResolverExtension>> map;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/calls/CallResolverExtensionProvider", "createExtensions"));
        }
        if (this.extensionsCache == null || (map = (Map)this.extensionsCache.get()) == null) {
            map = new HashMap();
            this.extensionsCache = new WeakReference(map);
        }
        if ((extensions = (ArrayList<CallResolverExtension>)map.get(declaration)) != null) {
            ArrayList<CallResolverExtension> arrayList = extensions;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolverExtensionProvider", "createExtensions"));
            }
            return arrayList;
        }
        extensions = new ArrayList<CallResolverExtension>();
        DeclarationDescriptor parent = declaration.getContainingDeclaration();
        if (parent != null) {
            extensions.addAll(this.createExtensions(parent));
            extensions.remove(extensions.size() - 1);
        }
        this.appendExtensionsFor(declaration, extensions);
        List<CallResolverExtension> immutableResult = Collections.unmodifiableList(extensions);
        map.put(declaration, immutableResult);
        List<CallResolverExtension> list2 = immutableResult;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallResolverExtensionProvider", "createExtensions"));
        }
        return list2;
    }

    private void appendExtensionsFor(DeclarationDescriptor declarationDescriptor, List<CallResolverExtension> extensions) {
        extensions.add(DEFAULT);
    }
}

