/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.ElementBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptorLite;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceLikeBuilder;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetConstructorCalleeExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetNamedDeclarationStub;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetNamespaceHeader;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.ImportsResolver;
import org.jetbrains.jet.lang.resolve.ScriptHeaderResolver;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.renderer.DescriptorRenderer;

public class DeclarationResolver {
    @NotNull
    private AnnotationResolver annotationResolver;
    @NotNull
    private TopDownAnalysisContext context;
    @NotNull
    private ImportsResolver importsResolver;
    @NotNull
    private DescriptorResolver descriptorResolver;
    @NotNull
    private ScriptHeaderResolver scriptHeaderResolver;
    @NotNull
    private BindingTrace trace;

    public void setAnnotationResolver(@NotNull AnnotationResolver annotationResolver) {
        if (annotationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationResolver", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "setAnnotationResolver"));
        }
        this.annotationResolver = annotationResolver;
    }

    public void setContext(@NotNull TopDownAnalysisContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "setContext"));
        }
        this.context = context;
    }

    public void setImportsResolver(@NotNull ImportsResolver importsResolver) {
        if (importsResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importsResolver", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "setImportsResolver"));
        }
        this.importsResolver = importsResolver;
    }

    public void setDescriptorResolver(@NotNull DescriptorResolver descriptorResolver) {
        if (descriptorResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorResolver", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "setDescriptorResolver"));
        }
        this.descriptorResolver = descriptorResolver;
    }

    public void setTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "setTrace"));
        }
        this.trace = trace;
    }

    public void setScriptHeaderResolver(@NotNull ScriptHeaderResolver scriptHeaderResolver) {
        if (scriptHeaderResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptHeaderResolver", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "setScriptHeaderResolver"));
        }
        this.scriptHeaderResolver = scriptHeaderResolver;
    }

    public void process(@NotNull JetScope rootScope) {
        if (rootScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootScope", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "process"));
        }
        this.checkModifiersAndAnnotationsInNamespaceHeaders();
        this.resolveAnnotationConstructors();
        this.resolveConstructorHeaders();
        this.resolveAnnotationStubsOnClassesAndConstructors();
        this.resolveFunctionAndPropertyHeaders();
        this.createFunctionsForDataClasses();
        this.importsResolver.processMembersImports(rootScope);
        this.checkRedeclarationsInNamespaces();
        this.checkRedeclarationsInInnerClassNames();
    }

    private void checkModifiersAndAnnotationsInNamespaceHeaders() {
        for (JetFile file : this.context.getNamespaceDescriptors().keySet()) {
            PsiElement firstChild;
            JetNamespaceHeader namespaceHeader = file.getNamespaceHeader();
            if (namespaceHeader == null || !((firstChild = namespaceHeader.getFirstChild()) instanceof JetModifierList)) continue;
            JetModifierList modifierList = (JetModifierList)firstChild;
            for (JetAnnotationEntry annotationEntry : modifierList.getAnnotationEntries()) {
                JetReferenceExpression reference;
                JetConstructorCalleeExpression calleeExpression = annotationEntry.getCalleeExpression();
                if (calleeExpression == null || (reference = calleeExpression.getConstructorReferenceExpression()) == null) continue;
                this.trace.report(Errors.UNRESOLVED_REFERENCE.on(reference, reference));
            }
            for (ASTNode node : modifierList.getModifierNodes()) {
                this.trace.report(Errors.ILLEGAL_MODIFIER.on(node.getPsi(), (JetKeywordToken)node.getElementType()));
            }
        }
    }

    private void resolveAnnotationConstructors() {
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            MutableClassDescriptor classDescriptor = entry.getValue();
            if (!DescriptorUtils.isAnnotationClass(classDescriptor)) continue;
            this.processPrimaryConstructor(classDescriptor, entry.getKey());
        }
    }

    private void resolveConstructorHeaders() {
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            MutableClassDescriptor classDescriptor = entry.getValue();
            if (DescriptorUtils.isAnnotationClass(classDescriptor)) continue;
            this.processPrimaryConstructor(classDescriptor, entry.getKey());
        }
    }

    private void resolveAnnotationStubsOnClassesAndConstructors() {
        MutableClassDescriptor descriptor;
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            JetClass jetClass = entry.getKey();
            descriptor = entry.getValue();
            this.resolveAnnotationsForClassOrObject(this.annotationResolver, jetClass, descriptor);
        }
        for (Map.Entry<JetNamedDeclarationStub, MutableClassDescriptor> entry : this.context.getObjects().entrySet()) {
            JetObjectDeclaration objectDeclaration = (JetObjectDeclaration)entry.getKey();
            descriptor = entry.getValue();
            this.resolveAnnotationsForClassOrObject(this.annotationResolver, objectDeclaration, descriptor);
        }
    }

    private void resolveAnnotationsForClassOrObject(AnnotationResolver annotationResolver, JetClassOrObject jetClass, MutableClassDescriptor descriptor) {
        JetModifierList modifierList = jetClass.getModifierList();
        if (modifierList != null) {
            descriptor.getAnnotations().addAll(annotationResolver.resolveAnnotationsWithoutArguments(descriptor.getScopeForSupertypeResolution(), modifierList, this.trace));
        }
    }

    private void resolveFunctionAndPropertyHeaders() {
        MutableClassDescriptor classDescriptor;
        for (Map.Entry<JetFile, WritableScope> entry : this.context.getNamespaceScopes().entrySet()) {
            JetFile namespace = entry.getKey();
            WritableScope namespaceScope = entry.getValue();
            NamespaceLikeBuilder namespaceDescriptor = this.context.getNamespaceDescriptors().get(namespace).getBuilder();
            this.resolveFunctionAndPropertyHeaders(namespace.getDeclarations(), namespaceScope, namespaceScope, namespaceScope, namespaceDescriptor);
        }
        for (Map.Entry<ElementBase, Object> entry : this.context.getClasses().entrySet()) {
            JetClass jetClass = (JetClass)entry.getKey();
            classDescriptor = (MutableClassDescriptor)entry.getValue();
            JetClassBody jetClassBody = jetClass.getBody();
            if (classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS && jetClassBody != null) {
                this.trace.report(Errors.ANNOTATION_CLASS_WITH_BODY.on(jetClassBody));
            }
            this.resolveFunctionAndPropertyHeaders(jetClass.getDeclarations(), classDescriptor.getScopeForMemberResolution(), classDescriptor.getScopeForInitializers(), classDescriptor.getScopeForMemberResolution(), classDescriptor.getBuilder());
        }
        for (Map.Entry<ElementBase, Object> entry : this.context.getObjects().entrySet()) {
            JetObjectDeclaration object2 = (JetObjectDeclaration)entry.getKey();
            classDescriptor = (MutableClassDescriptor)entry.getValue();
            this.resolveFunctionAndPropertyHeaders(object2.getDeclarations(), classDescriptor.getScopeForMemberResolution(), classDescriptor.getScopeForInitializers(), classDescriptor.getScopeForMemberResolution(), classDescriptor.getBuilder());
        }
        this.scriptHeaderResolver.resolveScriptDeclarations();
    }

    private void resolveFunctionAndPropertyHeaders(@NotNull List<JetDeclaration> declarations, final @NotNull JetScope scopeForFunctions, final @NotNull JetScope scopeForPropertyInitializers, final @NotNull JetScope scopeForPropertyAccessors, final @NotNull NamespaceLikeBuilder namespaceLike) {
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveFunctionAndPropertyHeaders"));
        }
        if (scopeForFunctions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForFunctions", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveFunctionAndPropertyHeaders"));
        }
        if (scopeForPropertyInitializers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForPropertyInitializers", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveFunctionAndPropertyHeaders"));
        }
        if (scopeForPropertyAccessors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeForPropertyAccessors", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveFunctionAndPropertyHeaders"));
        }
        if (namespaceLike == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceLike", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "resolveFunctionAndPropertyHeaders"));
        }
        for (JetDeclaration declaration : declarations) {
            declaration.accept(new JetVisitorVoid(){

                @Override
                public void visitNamedFunction(JetNamedFunction function) {
                    SimpleFunctionDescriptor functionDescriptor = DeclarationResolver.this.descriptorResolver.resolveFunctionDescriptor(namespaceLike.getOwnerForChildren(), scopeForFunctions, function, DeclarationResolver.this.trace, DeclarationResolver.this.context.getOuterDataFlowInfo());
                    namespaceLike.addFunctionDescriptor(functionDescriptor);
                    DeclarationResolver.this.context.getFunctions().put(function, functionDescriptor);
                    DeclarationResolver.this.context.registerDeclaringScope(function, scopeForFunctions);
                }

                @Override
                public void visitProperty(JetProperty property2) {
                    JetPropertyAccessor setter;
                    PropertyDescriptor propertyDescriptor = DeclarationResolver.this.descriptorResolver.resolvePropertyDescriptor(namespaceLike.getOwnerForChildren(), scopeForPropertyInitializers, property2, DeclarationResolver.this.trace, DeclarationResolver.this.context.getOuterDataFlowInfo());
                    namespaceLike.addPropertyDescriptor(propertyDescriptor);
                    DeclarationResolver.this.context.getProperties().put(property2, propertyDescriptor);
                    DeclarationResolver.this.context.registerDeclaringScope(property2, scopeForPropertyInitializers);
                    JetPropertyAccessor getter = property2.getGetter();
                    if (getter != null) {
                        DeclarationResolver.this.context.registerDeclaringScope(getter, scopeForPropertyAccessors);
                    }
                    if ((setter = property2.getSetter()) != null) {
                        DeclarationResolver.this.context.registerDeclaringScope(setter, scopeForPropertyAccessors);
                    }
                }

                @Override
                public void visitObjectDeclaration(JetObjectDeclaration declaration) {
                    PropertyDescriptor propertyDescriptor = DeclarationResolver.this.descriptorResolver.resolveObjectDeclarationAsPropertyDescriptor(scopeForFunctions, namespaceLike.getOwnerForChildren(), declaration, DeclarationResolver.this.context.getObjects().get(declaration), DeclarationResolver.this.trace);
                    namespaceLike.addPropertyDescriptor(propertyDescriptor);
                }

                @Override
                public void visitEnumEntry(JetEnumEntry enumEntry) {
                    MutableClassDescriptorLite classObjectDescriptor = ((MutableClassDescriptorLite)namespaceLike.getOwnerForChildren()).getClassObjectDescriptor();
                    assert (classObjectDescriptor != null);
                    PropertyDescriptor propertyDescriptor = DeclarationResolver.this.descriptorResolver.resolveObjectDeclarationAsPropertyDescriptor(scopeForFunctions, classObjectDescriptor, enumEntry, DeclarationResolver.this.context.getClasses().get(enumEntry), DeclarationResolver.this.trace);
                    classObjectDescriptor.getBuilder().addPropertyDescriptor(propertyDescriptor);
                }
            });
        }
    }

    private void createFunctionsForDataClasses() {
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            JetClass jetClass = entry.getKey();
            MutableClassDescriptor classDescriptor = entry.getValue();
            if (!jetClass.hasPrimaryConstructor() || !KotlinBuiltIns.getInstance().isData(classDescriptor)) continue;
            ConstructorDescriptor constructor = DescriptorUtils.getConstructorOfDataClass(classDescriptor);
            this.createComponentFunctions(classDescriptor, constructor);
            this.createCopyFunction(classDescriptor, constructor);
        }
    }

    private void createComponentFunctions(@NotNull MutableClassDescriptor classDescriptor, @NotNull ConstructorDescriptor constructorDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "createComponentFunctions"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "createComponentFunctions"));
        }
        int parameterIndex = 0;
        for (ValueParameterDescriptor parameter : constructorDescriptor.getValueParameters()) {
            PropertyDescriptor property2;
            if (parameter.getType().isError() || (property2 = this.trace.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameter)) == null) continue;
            SimpleFunctionDescriptor functionDescriptor = DescriptorResolver.createComponentFunctionDescriptor(++parameterIndex, property2, parameter, classDescriptor, this.trace);
            classDescriptor.getBuilder().addFunctionDescriptor(functionDescriptor);
        }
    }

    private void createCopyFunction(@NotNull MutableClassDescriptor classDescriptor, @NotNull ConstructorDescriptor constructorDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "createCopyFunction"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "createCopyFunction"));
        }
        SimpleFunctionDescriptor functionDescriptor = DescriptorResolver.createCopyFunctionDescriptor(constructorDescriptor.getValueParameters(), classDescriptor, this.trace);
        classDescriptor.getBuilder().addFunctionDescriptor(functionDescriptor);
    }

    private void processPrimaryConstructor(MutableClassDescriptor classDescriptor, JetClass klass) {
        JetScope memberScope;
        ConstructorDescriptorImpl constructorDescriptor;
        JetParameterList primaryConstructorParameterList;
        if (classDescriptor.getKind() == ClassKind.TRAIT && (primaryConstructorParameterList = klass.getPrimaryConstructorParameterList()) != null) {
            this.trace.report(Errors.CONSTRUCTOR_IN_TRAIT.on(primaryConstructorParameterList));
        }
        if ((constructorDescriptor = this.descriptorResolver.resolvePrimaryConstructorDescriptor(memberScope = classDescriptor.getScopeForSupertypeResolution(), classDescriptor, klass, this.trace)) != null) {
            List<ValueParameterDescriptor> valueParameterDescriptors = constructorDescriptor.getValueParameters();
            List<JetParameter> primaryConstructorParameters = klass.getPrimaryConstructorParameters();
            assert (valueParameterDescriptors.size() == primaryConstructorParameters.size());
            ArrayList<ValueParameterDescriptor> notProperties = new ArrayList<ValueParameterDescriptor>();
            for (ValueParameterDescriptor valueParameterDescriptor : valueParameterDescriptors) {
                JetParameter parameter = primaryConstructorParameters.get(valueParameterDescriptor.getIndex());
                if (parameter.getValOrVarNode() != null) {
                    PropertyDescriptor propertyDescriptor = this.descriptorResolver.resolvePrimaryConstructorParameterToAProperty(classDescriptor, valueParameterDescriptor, memberScope, parameter, this.trace);
                    classDescriptor.getBuilder().addPropertyDescriptor(propertyDescriptor);
                    this.context.getPrimaryConstructorParameterProperties().put(parameter, propertyDescriptor);
                    continue;
                }
                notProperties.add(valueParameterDescriptor);
            }
            if (classDescriptor.getKind() != ClassKind.TRAIT) {
                classDescriptor.setPrimaryConstructor(constructorDescriptor);
                classDescriptor.addConstructorParametersToInitializersScope(notProperties);
            }
        }
    }

    private void checkRedeclarationsInNamespaces() {
        for (NamespaceDescriptorImpl descriptor : Sets.newHashSet(this.context.getNamespaceDescriptors().values())) {
            Multimap<Name, DeclarationDescriptor> simpleNameDescriptors = descriptor.getMemberScope().getDeclaredDescriptorsAccessibleBySimpleName();
            for (Name name : simpleNameDescriptors.keySet()) {
                Collection<DeclarationDescriptor> descriptors = Collections2.filter(simpleNameDescriptors.get(name), new Predicate<DeclarationDescriptor>(){

                    @Override
                    public boolean apply(@Nullable DeclarationDescriptor descriptor) {
                        if (descriptor instanceof PropertyDescriptor) {
                            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
                            return propertyDescriptor.getReceiverParameter() == null;
                        }
                        return true;
                    }
                });
                if (descriptors.size() <= 1) continue;
                for (DeclarationDescriptor declarationDescriptor : descriptors) {
                    for (PsiElement declaration : this.getDeclarationsByDescriptor(declarationDescriptor)) {
                        assert (declaration != null) : "Null declaration for descriptor: " + declarationDescriptor + " " + (declarationDescriptor != null ? DescriptorRenderer.TEXT.render(declarationDescriptor) : "");
                        this.trace.report(Errors.REDECLARATION.on(declaration, declarationDescriptor.getName().asString()));
                    }
                }
            }
        }
    }

    private Collection<PsiElement> getDeclarationsByDescriptor(DeclarationDescriptor declarationDescriptor) {
        Collection<PsiElement> declarations;
        if (declarationDescriptor instanceof NamespaceDescriptor) {
            final NamespaceDescriptor namespace = (NamespaceDescriptor)declarationDescriptor;
            Collection<JetFile> files = this.trace.get(BindingContext.NAMESPACE_TO_FILES, namespace);
            if (files == null) {
                throw new IllegalStateException("declarations corresponding to " + namespace + " are not found");
            }
            declarations = Collections2.transform(files, new Function<JetFile, PsiElement>(){

                @Override
                public PsiElement apply(@Nullable JetFile file) {
                    assert (file != null) : "File is null for namespace " + namespace;
                    return file.getNamespaceHeader().getNameIdentifier();
                }
            });
        } else {
            declarations = Collections.singletonList(BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), declarationDescriptor));
        }
        return declarations;
    }

    private void checkRedeclarationsInInnerClassNames() {
        Iterable<MutableClassDescriptor> classesAndObjects = Iterables.concat(this.context.getClasses().values(), this.context.getObjects().values());
        for (MutableClassDescriptor classDescriptor : classesAndObjects) {
            Collection<DeclarationDescriptor> classObjDescriptors;
            if (classDescriptor.getKind() == ClassKind.CLASS_OBJECT) continue;
            Collection<DeclarationDescriptor> allDescriptors = classDescriptor.getScopeForMemberLookup().getOwnDeclaredDescriptors();
            MutableClassDescriptorLite classObj = classDescriptor.getClassObjectDescriptor();
            if (classObj != null && !(classObjDescriptors = classObj.getScopeForMemberLookup().getOwnDeclaredDescriptors()).isEmpty()) {
                allDescriptors = Lists.newArrayList(allDescriptors);
                allDescriptors.addAll(classObjDescriptors);
            }
            HashMultimap<Name, DeclarationDescriptor> descriptorMap = HashMultimap.create();
            for (DeclarationDescriptor desc : allDescriptors) {
                if (!(desc instanceof ClassDescriptor) && !(desc instanceof PropertyDescriptor)) continue;
                descriptorMap.put(desc.getName(), desc);
            }
            this.reportRedeclarations(descriptorMap);
        }
    }

    private void reportRedeclarations(@NotNull Multimap<Name, DeclarationDescriptor> descriptorMap) {
        if (descriptorMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorMap", "org/jetbrains/jet/lang/resolve/DeclarationResolver", "reportRedeclarations"));
        }
        HashSet<Pair<PsiElement, Name>> redeclarations = Sets.newHashSet();
        for (Name name : descriptorMap.keySet()) {
            Collection<DeclarationDescriptor> descriptors = descriptorMap.get(name);
            if (descriptors.size() <= 1) continue;
            for (DeclarationDescriptor descriptor : descriptors) {
                if (!(descriptor instanceof ClassDescriptor)) continue;
                for (DeclarationDescriptor descriptor2 : descriptors) {
                    if (descriptor == descriptor2) continue;
                    redeclarations.add(Pair.create(BindingContextUtils.classDescriptorToDeclaration(this.trace.getBindingContext(), (ClassDescriptor)descriptor), descriptor.getName()));
                    if (!(descriptor2 instanceof PropertyDescriptor)) continue;
                    redeclarations.add(Pair.create(BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), descriptor2), descriptor2.getName()));
                }
            }
        }
        for (Pair pair : redeclarations) {
            this.trace.report(Errors.REDECLARATION.on((PsiElement)pair.getFirst(), ((Name)pair.getSecond()).asString()));
        }
    }
}

