/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ClassDescriptorBase;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceLikeBuilder;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceLikeBuilderDummy;
import org.jetbrains.jet.lang.resolve.DescriptorFactory;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.InnerClassesScopeWrapper;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeConstructorImpl;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.renderer.DescriptorRenderer;

public abstract class MutableClassDescriptorLite
extends ClassDescriptorBase {
    private List<AnnotationDescriptor> annotations;
    private List<TypeParameterDescriptor> typeParameters;
    private Collection<JetType> supertypes;
    private TypeConstructor typeConstructor;
    private Modality modality;
    private Visibility visibility;
    private final boolean isInner;
    private MutableClassDescriptorLite classObjectDescriptor;
    private JetType classObjectType;
    private final ClassKind kind;
    private JetScope scopeForMemberLookup;
    private JetScope innerClassesScope;
    private ReceiverParameterDescriptor implicitReceiver;
    private NamespaceLikeBuilder builder;

    public MutableClassDescriptorLite(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Name name, @NotNull ClassKind kind, boolean isInner) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptorLite", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptorLite", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptorLite", "<init>"));
        }
        super(containingDeclaration, name);
        this.annotations = Lists.newArrayList();
        this.supertypes = Lists.newArrayList();
        this.builder = null;
        this.kind = kind;
        this.isInner = isInner;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        TypeConstructor typeConstructor = this.typeConstructor;
        if (typeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptorLite", "getTypeConstructor"));
        }
        return typeConstructor;
    }

    public void setScopeForMemberLookup(JetScope scopeForMemberLookup) {
        this.scopeForMemberLookup = scopeForMemberLookup;
        this.innerClassesScope = new InnerClassesScopeWrapper(scopeForMemberLookup);
    }

    public void createTypeConstructor() {
        assert (this.typeConstructor == null) : this.typeConstructor;
        this.typeConstructor = new TypeConstructorImpl(this, Collections.<AnnotationDescriptor>emptyList(), !this.getModality().isOverridable(), this.getName().asString(), this.typeParameters, this.supertypes);
    }

    private WritableScope getScopeForMemberLookupAsWritableScope() {
        return (WritableScope)this.scopeForMemberLookup;
    }

    @Override
    @NotNull
    public JetScope getScopeForMemberLookup() {
        JetScope jetScope = this.scopeForMemberLookup;
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptorLite", "getScopeForMemberLookup"));
        }
        return jetScope;
    }

    @Override
    public JetType getClassObjectType() {
        if (this.classObjectType == null && this.classObjectDescriptor != null) {
            this.classObjectType = this.classObjectDescriptor.getDefaultType();
        }
        return this.classObjectType;
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        ClassKind classKind = this.kind;
        if (classKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptorLite", "getKind"));
        }
        return classKind;
    }

    public void setModality(Modality modality) {
        this.modality = modality;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Override
    @NotNull
    public Modality getModality() {
        Modality modality = this.modality;
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptorLite", "getModality"));
        }
        return modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = this.visibility;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptorLite", "getVisibility"));
        }
        return visibility;
    }

    @Override
    public boolean isInner() {
        return this.isInner;
    }

    public Collection<JetType> getSupertypes() {
        return this.supertypes;
    }

    public void setSupertypes(@NotNull Collection<JetType> supertypes) {
        if (supertypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptorLite", "setSupertypes"));
        }
        this.supertypes = supertypes;
    }

    @Override
    @Nullable
    public MutableClassDescriptorLite getClassObjectDescriptor() {
        return this.classObjectDescriptor;
    }

    @Override
    @NotNull
    public JetScope getUnsubstitutedInnerClassesScope() {
        JetScope jetScope = this.innerClassesScope;
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptorLite", "getUnsubstitutedInnerClassesScope"));
        }
        return jetScope;
    }

    public void addSupertype(@NotNull JetType supertype) {
        if (supertype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertype", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptorLite", "addSupertype"));
        }
        assert (!supertype.isError()) : "Error types must be filtered out in DescriptorResolver";
        if (TypeUtils.getClassDescriptor(supertype) != null) {
            this.supertypes.add(supertype);
        }
    }

    public void setTypeParameterDescriptors(List<TypeParameterDescriptor> typeParameters) {
        if (this.typeParameters != null) {
            throw new IllegalStateException();
        }
        this.typeParameters = new ArrayList<TypeParameterDescriptor>();
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
            this.typeParameters.add(typeParameterDescriptor);
        }
    }

    public void lockScopes() {
        this.getScopeForMemberLookupAsWritableScope().changeLockLevel(WritableScope.LockLevel.READING);
        if (this.classObjectDescriptor != null) {
            this.classObjectDescriptor.lockScopes();
        }
    }

    @Override
    @NotNull
    public ReceiverParameterDescriptor getThisAsReceiverParameter() {
        if (this.implicitReceiver == null) {
            this.implicitReceiver = DescriptorFactory.createLazyReceiverParameterDescriptor(this);
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = this.implicitReceiver;
        if (receiverParameterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptorLite", "getThisAsReceiverParameter"));
        }
        return receiverParameterDescriptor;
    }

    public String toString() {
        try {
            return DescriptorRenderer.TEXT.render(this) + "[" + this.getClass().getCanonicalName() + "@" + System.identityHashCode(this) + "]";
        }
        catch (Throwable e) {
            return super.toString();
        }
    }

    @Override
    public List<AnnotationDescriptor> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<AnnotationDescriptor> annotations) {
        this.annotations = annotations;
    }

    public NamespaceLikeBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new NamespaceLikeBuilderDummy(){

                @Override
                @NotNull
                public DeclarationDescriptor getOwnerForChildren() {
                    MutableClassDescriptorLite mutableClassDescriptorLite = MutableClassDescriptorLite.this;
                    if (mutableClassDescriptorLite == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptorLite$1", "getOwnerForChildren"));
                    }
                    return mutableClassDescriptorLite;
                }

                @Override
                public void addClassifierDescriptor(@NotNull MutableClassDescriptorLite classDescriptor) {
                    if (classDescriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptorLite$1", "addClassifierDescriptor"));
                    }
                    MutableClassDescriptorLite.this.getScopeForMemberLookupAsWritableScope().addClassifierDescriptor(classDescriptor);
                }

                @Override
                public void addObjectDescriptor(@NotNull MutableClassDescriptorLite objectDescriptor) {
                    if (objectDescriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectDescriptor", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptorLite$1", "addObjectDescriptor"));
                    }
                    MutableClassDescriptorLite.this.getScopeForMemberLookupAsWritableScope().addObjectDescriptor(objectDescriptor);
                }

                @Override
                public void addFunctionDescriptor(@NotNull SimpleFunctionDescriptor functionDescriptor) {
                    if (functionDescriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptorLite$1", "addFunctionDescriptor"));
                    }
                    MutableClassDescriptorLite.this.getScopeForMemberLookupAsWritableScope().addFunctionDescriptor(functionDescriptor);
                }

                @Override
                public void addPropertyDescriptor(@NotNull PropertyDescriptor propertyDescriptor) {
                    if (propertyDescriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptorLite$1", "addPropertyDescriptor"));
                    }
                    MutableClassDescriptorLite.this.getScopeForMemberLookupAsWritableScope().addPropertyDescriptor(propertyDescriptor);
                }

                @Override
                public NamespaceLikeBuilder.ClassObjectStatus setClassObjectDescriptor(@NotNull MutableClassDescriptorLite classObjectDescriptor) {
                    if (classObjectDescriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObjectDescriptor", "org/jetbrains/jet/lang/descriptors/impl/MutableClassDescriptorLite$1", "setClassObjectDescriptor"));
                    }
                    if (MutableClassDescriptorLite.this.getKind().isObject() || MutableClassDescriptorLite.this.isInner()) {
                        return NamespaceLikeBuilder.ClassObjectStatus.NOT_ALLOWED;
                    }
                    if (MutableClassDescriptorLite.this.classObjectDescriptor != null) {
                        return NamespaceLikeBuilder.ClassObjectStatus.DUPLICATE;
                    }
                    assert (classObjectDescriptor.getKind() == ClassKind.CLASS_OBJECT);
                    MutableClassDescriptorLite.this.classObjectDescriptor = classObjectDescriptor;
                    return NamespaceLikeBuilder.ClassObjectStatus.OK;
                }
            };
        }
        return this.builder;
    }
}

