/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.cfg.GenerationTrigger;
import org.jetbrains.jet.lang.cfg.JetControlFlowBuilder;
import org.jetbrains.jet.lang.cfg.Label;
import org.jetbrains.jet.lang.cfg.LoopInfo;
import org.jetbrains.jet.lang.cfg.pseudocode.Pseudocode;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetThrowExpression;
import org.jetbrains.jet.lang.psi.JetVariableDeclaration;

public class JetControlFlowBuilderAdapter
implements JetControlFlowBuilder {
    @Nullable
    protected JetControlFlowBuilder builder;

    @Override
    public void read(@NotNull JetElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "read"));
        }
        assert (this.builder != null);
        this.builder.read(element);
    }

    @Override
    public void readUnit(@NotNull JetExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "readUnit"));
        }
        assert (this.builder != null);
        this.builder.readUnit(expression);
    }

    @Override
    @NotNull
    public Label createUnboundLabel() {
        assert (this.builder != null);
        Label label = this.builder.createUnboundLabel();
        if (label == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "createUnboundLabel"));
        }
        return label;
    }

    @Override
    @NotNull
    public Label createUnboundLabel(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "createUnboundLabel"));
        }
        assert (this.builder != null);
        Label label = this.builder.createUnboundLabel(name);
        if (label == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "createUnboundLabel"));
        }
        return label;
    }

    @Override
    public void bindLabel(@NotNull Label label) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "bindLabel"));
        }
        assert (this.builder != null);
        this.builder.bindLabel(label);
    }

    @Override
    public void jump(@NotNull Label label) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "jump"));
        }
        assert (this.builder != null);
        this.builder.jump(label);
    }

    @Override
    public void jumpOnFalse(@NotNull Label label) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "jumpOnFalse"));
        }
        assert (this.builder != null);
        this.builder.jumpOnFalse(label);
    }

    @Override
    public void jumpOnTrue(@NotNull Label label) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "jumpOnTrue"));
        }
        assert (this.builder != null);
        this.builder.jumpOnTrue(label);
    }

    @Override
    public void nondeterministicJump(Label label) {
        assert (this.builder != null);
        this.builder.nondeterministicJump(label);
    }

    @Override
    public void nondeterministicJump(List<Label> labels) {
        assert (this.builder != null);
        this.builder.nondeterministicJump(labels);
    }

    @Override
    public void jumpToError() {
        assert (this.builder != null);
        this.builder.jumpToError();
    }

    @Override
    public void throwException(@NotNull JetThrowExpression throwExpression) {
        if (throwExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwExpression", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "throwException"));
        }
        assert (this.builder != null);
        this.builder.throwException(throwExpression);
    }

    @Override
    public Label getEntryPoint(@NotNull JetElement labelElement) {
        if (labelElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelElement", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "getEntryPoint"));
        }
        assert (this.builder != null);
        return this.builder.getEntryPoint(labelElement);
    }

    @Override
    public Label getExitPoint(@NotNull JetElement labelElement) {
        if (labelElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelElement", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "getExitPoint"));
        }
        assert (this.builder != null);
        return this.builder.getExitPoint(labelElement);
    }

    @Override
    public LoopInfo enterLoop(@NotNull JetExpression expression, @Nullable Label loopExitPoint, Label conditionEntryPoint) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "enterLoop"));
        }
        assert (this.builder != null);
        return this.builder.enterLoop(expression, loopExitPoint, conditionEntryPoint);
    }

    @Override
    public void exitLoop(@NotNull JetExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "exitLoop"));
        }
        assert (this.builder != null);
        this.builder.exitLoop(expression);
    }

    @Override
    @Nullable
    public JetElement getCurrentLoop() {
        assert (this.builder != null);
        return this.builder.getCurrentLoop();
    }

    @Override
    public void enterTryFinally(@NotNull GenerationTrigger trigger) {
        if (trigger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trigger", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "enterTryFinally"));
        }
        assert (this.builder != null);
        this.builder.enterTryFinally(trigger);
    }

    @Override
    public void exitTryFinally() {
        assert (this.builder != null);
        this.builder.exitTryFinally();
    }

    @Override
    public void enterSubroutine(@NotNull JetElement subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "enterSubroutine"));
        }
        assert (this.builder != null);
        this.builder.enterSubroutine(subroutine);
    }

    @Override
    public Pseudocode exitSubroutine(@NotNull JetElement subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "exitSubroutine"));
        }
        assert (this.builder != null);
        return this.builder.exitSubroutine(subroutine);
    }

    @Override
    @NotNull
    public JetElement getCurrentSubroutine() {
        assert (this.builder != null);
        JetElement jetElement = this.builder.getCurrentSubroutine();
        if (jetElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "getCurrentSubroutine"));
        }
        return jetElement;
    }

    @Override
    @Nullable
    public JetElement getReturnSubroutine() {
        assert (this.builder != null);
        return this.builder.getReturnSubroutine();
    }

    @Override
    public void returnValue(@NotNull JetExpression returnExpression, @NotNull JetElement subroutine) {
        if (returnExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnExpression", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "returnValue"));
        }
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "returnValue"));
        }
        assert (this.builder != null);
        this.builder.returnValue(returnExpression, subroutine);
    }

    @Override
    public void returnNoValue(@NotNull JetElement returnExpression, @NotNull JetElement subroutine) {
        if (returnExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnExpression", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "returnNoValue"));
        }
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "returnNoValue"));
        }
        assert (this.builder != null);
        this.builder.returnNoValue(returnExpression, subroutine);
    }

    @Override
    public void unsupported(JetElement element) {
        assert (this.builder != null);
        this.builder.unsupported(element);
    }

    @Override
    public void write(@NotNull JetElement assignment, @NotNull JetElement lValue) {
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "write"));
        }
        if (lValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lValue", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "write"));
        }
        assert (this.builder != null);
        this.builder.write(assignment, lValue);
    }

    @Override
    public void declare(@NotNull JetParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "declare"));
        }
        assert (this.builder != null);
        this.builder.declare(parameter);
    }

    @Override
    public void declare(@NotNull JetVariableDeclaration property2) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "declare"));
        }
        assert (this.builder != null);
        this.builder.declare(property2);
    }

    @Override
    public void repeatPseudocode(@NotNull Label startLabel, @NotNull Label finishLabel) {
        if (startLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startLabel", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "repeatPseudocode"));
        }
        if (finishLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishLabel", "org/jetbrains/jet/lang/cfg/JetControlFlowBuilderAdapter", "repeatPseudocode"));
        }
        assert (this.builder != null);
        this.builder.repeatPseudocode(startLabel, finishLabel);
    }
}

