/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.AnnotationVisitor;
import org.jetbrains.asm4.ClassVisitor;
import org.jetbrains.asm4.FieldVisitor;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.jet.codegen.JvmSerializationBindings;

public abstract class ClassBuilder {
    protected static final MethodVisitor EMPTY_METHOD_VISITOR = new MethodVisitor(262144){};
    protected static final FieldVisitor EMPTY_FIELD_VISITOR = new FieldVisitor(262144){};
    private String thisName;
    private final JvmSerializationBindings serializationBindings = new JvmSerializationBindings();

    @NotNull
    public FieldVisitor newField(@Nullable PsiElement origin, int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable Object value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/ClassBuilder", "newField"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/jet/codegen/ClassBuilder", "newField"));
        }
        FieldVisitor visitor = this.getVisitor().visitField(access, name, desc, signature, value);
        if (visitor == null) {
            FieldVisitor fieldVisitor = EMPTY_FIELD_VISITOR;
            if (fieldVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassBuilder", "newField"));
            }
            return fieldVisitor;
        }
        FieldVisitor fieldVisitor = visitor;
        if (fieldVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassBuilder", "newField"));
        }
        return fieldVisitor;
    }

    @NotNull
    public MethodVisitor newMethod(@Nullable PsiElement origin, int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/ClassBuilder", "newMethod"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/jet/codegen/ClassBuilder", "newMethod"));
        }
        MethodVisitor visitor = this.getVisitor().visitMethod(access, name, desc, signature, exceptions);
        if (visitor == null) {
            MethodVisitor methodVisitor = EMPTY_METHOD_VISITOR;
            if (methodVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassBuilder", "newMethod"));
            }
            return methodVisitor;
        }
        MethodVisitor methodVisitor = visitor;
        if (methodVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassBuilder", "newMethod"));
        }
        return methodVisitor;
    }

    @NotNull
    public JvmSerializationBindings getSerializationBindings() {
        JvmSerializationBindings jvmSerializationBindings = this.serializationBindings;
        if (jvmSerializationBindings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassBuilder", "getSerializationBindings"));
        }
        return jvmSerializationBindings;
    }

    @NotNull
    public AnnotationVisitor newAnnotation(@NotNull String desc, boolean visible) {
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/jet/codegen/ClassBuilder", "newAnnotation"));
        }
        AnnotationVisitor annotationVisitor = this.getVisitor().visitAnnotation(desc, visible);
        if (annotationVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassBuilder", "newAnnotation"));
        }
        return annotationVisitor;
    }

    public void done() {
        this.getVisitor().visitEnd();
    }

    @NotNull
    public abstract ClassVisitor getVisitor();

    public void defineClass(@Nullable PsiElement origin, int version, int access, @NotNull String name, @Nullable String signature, @NotNull String superName, @NotNull String[] interfaces) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/ClassBuilder", "defineClass"));
        }
        if (superName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superName", "org/jetbrains/jet/codegen/ClassBuilder", "defineClass"));
        }
        if (interfaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interfaces", "org/jetbrains/jet/codegen/ClassBuilder", "defineClass"));
        }
        this.thisName = name;
        this.getVisitor().visit(version, access, name, signature, superName, interfaces);
    }

    public void visitSource(@NotNull String name, @Nullable String debug) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/ClassBuilder", "visitSource"));
        }
        this.getVisitor().visitSource(name, debug);
    }

    public void visitOuterClass(@NotNull String owner, @Nullable String name, @Nullable String desc) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/codegen/ClassBuilder", "visitOuterClass"));
        }
        this.getVisitor().visitOuterClass(owner, name, desc);
    }

    public void visitInnerClass(@NotNull String name, @Nullable String outerName, @Nullable String innerName, int access) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/ClassBuilder", "visitInnerClass"));
        }
        this.getVisitor().visitInnerClass(name, outerName, innerName, access);
    }

    @NotNull
    public String getThisName() {
        assert (this.thisName != null) : "This name isn't set";
        String string = this.thisName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassBuilder", "getThisName"));
        }
        return string;
    }

    public static class Concrete
    extends ClassBuilder {
        private final ClassVisitor v;

        public Concrete(@NotNull ClassVisitor v) {
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/ClassBuilder$Concrete", "<init>"));
            }
            this.v = v;
        }

        @Override
        @NotNull
        public ClassVisitor getVisitor() {
            ClassVisitor classVisitor = this.v;
            if (classVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassBuilder$Concrete", "getVisitor"));
            }
            return classVisitor;
        }
    }
}

