/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.analyzer;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;
import org.jetbrains.jet.lang.types.ErrorUtils;

public class AnalyzeExhaust {
    public static final AnalyzeExhaust EMPTY = AnalyzeExhaust.success(BindingContext.EMPTY, ErrorUtils.getErrorModule());
    private final BindingContext bindingContext;
    private final Throwable error;
    private final BodiesResolveContext bodiesResolveContext;
    private final ModuleDescriptor moduleDescriptor;

    public static AnalyzeExhaust success(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor module) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/analyzer/AnalyzeExhaust", "success"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/analyzer/AnalyzeExhaust", "success"));
        }
        return new AnalyzeExhaust(bindingContext, module, null, null);
    }

    public static AnalyzeExhaust success(@NotNull BindingContext bindingContext, @Nullable BodiesResolveContext bodiesResolveContext, @NotNull ModuleDescriptor module) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/analyzer/AnalyzeExhaust", "success"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/analyzer/AnalyzeExhaust", "success"));
        }
        return new AnalyzeExhaust(bindingContext, module, bodiesResolveContext, null);
    }

    public static AnalyzeExhaust error(@NotNull BindingContext bindingContext, @NotNull Throwable error) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/analyzer/AnalyzeExhaust", "error"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "org/jetbrains/jet/analyzer/AnalyzeExhaust", "error"));
        }
        return new AnalyzeExhaust(bindingContext, ErrorUtils.getErrorModule(), null, error);
    }

    private AnalyzeExhaust(@NotNull BindingContext bindingContext, @NotNull ModuleDescriptor moduleDescriptor, @Nullable BodiesResolveContext bodiesResolveContext, @Nullable Throwable error) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/analyzer/AnalyzeExhaust", "<init>"));
        }
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDescriptor", "org/jetbrains/jet/analyzer/AnalyzeExhaust", "<init>"));
        }
        this.bindingContext = bindingContext;
        this.error = error;
        this.bodiesResolveContext = bodiesResolveContext;
        this.moduleDescriptor = moduleDescriptor;
    }

    @Nullable
    public BodiesResolveContext getBodiesResolveContext() {
        return this.bodiesResolveContext;
    }

    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext = this.bindingContext;
        if (bindingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/analyzer/AnalyzeExhaust", "getBindingContext"));
        }
        return bindingContext;
    }

    @NotNull
    public Throwable getError() {
        if (this.error == null) {
            throw new IllegalStateException("Should be called only for error analyze result");
        }
        Throwable throwable = this.error;
        if (throwable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/analyzer/AnalyzeExhaust", "getError"));
        }
        return throwable;
    }

    public boolean isError() {
        return this.error != null;
    }

    public void throwIfError() {
        if (this.isError()) {
            throw new IllegalStateException("failed to analyze: " + this.error, this.error);
        }
    }

    @NotNull
    public ModuleDescriptor getModuleDescriptor() {
        ModuleDescriptor moduleDescriptor = this.moduleDescriptor;
        if (moduleDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/analyzer/AnalyzeExhaust", "getModuleDescriptor"));
        }
        return moduleDescriptor;
    }
}

