/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntArrayList;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class URLUtil {
    private static final Pattern DATA_URI_PATTERN = Pattern.compile("data:([^,;]+/[^,;]+)(;charset=[^,;]+)?(;base64)?,(.+)");

    @NotNull
    public static InputStream openStream(@NotNull URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/io/URLUtil", "openStream"));
        }
        String protocol = url.getProtocol();
        InputStream inputStream = protocol.equals("jar") ? URLUtil.openJarStream(url) : url.openStream();
        if (inputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "openStream"));
        }
        return inputStream;
    }

    @NotNull
    private static InputStream openJarStream(@NotNull URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/io/URLUtil", "openJarStream"));
        }
        Pair<String, String> paths = URLUtil.splitJarUrl(url.getFile());
        if (paths == null) {
            throw new MalformedURLException(url.getFile());
        }
        final ZipFile zipFile = new ZipFile(FileUtil.unquote((String)paths.first));
        ZipEntry zipEntry = zipFile.getEntry((String)paths.second);
        if (zipEntry == null) {
            throw new FileNotFoundException("Entry " + (String)paths.second + " not found in " + (String)paths.first);
        }
        FilterInputStream filterInputStream = new FilterInputStream(zipFile.getInputStream(zipEntry)){

            @Override
            public void close() throws IOException {
                super.close();
                zipFile.close();
            }
        };
        if (filterInputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "openJarStream"));
        }
        return filterInputStream;
    }

    @Nullable
    public static Pair<String, String> splitJarUrl(@NotNull String fullPath) {
        if (fullPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/io/URLUtil", "splitJarUrl"));
        }
        int delimiter = fullPath.indexOf("!/");
        if (delimiter >= 0) {
            String resourcePath = fullPath.substring(delimiter + 2);
            String jarPath = fullPath.substring(0, delimiter);
            if (StringUtil.startsWithConcatenation(jarPath, "file", ":")) {
                jarPath = jarPath.substring("file".length() + 1);
                return Pair.create(jarPath, resourcePath);
            }
        }
        return null;
    }

    @NotNull
    public static String unescapePercentSequences(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/io/URLUtil", "unescapePercentSequences"));
        }
        if (s.indexOf(37) == -1) {
            String string = s;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "unescapePercentSequences"));
            }
            return string;
        }
        StringBuilder decoded = new StringBuilder();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '%') {
                TIntArrayList bytes = new TIntArrayList();
                while (i + 2 < len && s.charAt(i) == '%') {
                    int d1 = URLUtil.decode(s.charAt(i + 1));
                    int d2 = URLUtil.decode(s.charAt(i + 2));
                    if (d1 == -1 || d2 == -1) break;
                    bytes.add((d1 & 0xF) << 4 | d2 & 0xF);
                    i += 3;
                }
                if (!bytes.isEmpty()) {
                    byte[] bytesArray = new byte[bytes.size()];
                    for (int j = 0; j < bytes.size(); ++j) {
                        bytesArray[j] = (byte)bytes.getQuick(j);
                    }
                    decoded.append(new String(bytesArray, Charset.forName("UTF-8")));
                    continue;
                }
            }
            decoded.append(c);
            ++i;
        }
        String string = decoded.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/URLUtil", "unescapePercentSequences"));
        }
        return string;
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }
}

