/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.Consumer;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.ShareableKey;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SLRUMap<K, V> {
    protected final LinkedHashMap<K, V> myProtectedQueue;
    protected final LinkedHashMap<K, V> myProbationalQueue;
    private final int myProtectedQueueSize;
    private final int myProbationalQueueSize;
    private int probationalHits = 0;
    private int protectedHits = 0;
    private int misses = 0;
    private static final int FACTOR = Integer.getInteger("idea.slru.factor", 1);

    public SLRUMap(int protectedQueueSize, int probationalQueueSize) {
        this(protectedQueueSize, probationalQueueSize, EqualityPolicy.CANONICAL);
    }

    public SLRUMap(int protectedQueueSize, int probationalQueueSize, EqualityPolicy hashingStrategy) {
        this.myProtectedQueueSize = protectedQueueSize * FACTOR;
        this.myProbationalQueueSize = probationalQueueSize * FACTOR;
        this.myProtectedQueue = new LinkedHashMap<K, V>(10, 0.6f, hashingStrategy){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest, K key, V value) {
                if (this.size() > SLRUMap.this.myProtectedQueueSize) {
                    SLRUMap.this.myProbationalQueue.put(key, value);
                    return true;
                }
                return false;
            }
        };
        this.myProbationalQueue = new LinkedHashMap<K, V>(10, 0.6f, hashingStrategy){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest, K key, V value) {
                if (this.size() > SLRUMap.this.myProbationalQueueSize) {
                    SLRUMap.this.onDropFromCache(key, value);
                    return true;
                }
                return false;
            }
        };
    }

    @Nullable
    public V get(K key) {
        V value = this.myProtectedQueue.get(key);
        if (value != null) {
            ++this.protectedHits;
            return value;
        }
        value = this.myProbationalQueue.remove(key);
        if (value != null) {
            ++this.probationalHits;
            this.putToProtectedQueue(key, value);
            return value;
        }
        ++this.misses;
        return null;
    }

    protected void putToProtectedQueue(K key, V value) {
        this.myProtectedQueue.put(this.getStableKey(key), value);
    }

    public void put(K key, @NotNull V value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/SLRUMap", "put"));
        }
        V oldValue = this.myProtectedQueue.remove(key);
        if (oldValue != null) {
            this.onDropFromCache(key, oldValue);
        }
        if ((oldValue = this.myProbationalQueue.put(this.getStableKey(key), value)) != null) {
            this.onDropFromCache(key, oldValue);
        }
    }

    protected void onDropFromCache(K key, V value) {
    }

    public boolean remove(K key) {
        V value = this.myProtectedQueue.remove(key);
        if (value != null) {
            this.onDropFromCache(key, value);
            return true;
        }
        value = this.myProbationalQueue.remove(key);
        if (value != null) {
            this.onDropFromCache(key, value);
            return true;
        }
        return false;
    }

    public void iterateKeys(Consumer<K> keyConsumer) {
        for (K key : this.myProtectedQueue.keySet()) {
            keyConsumer.consume(key);
        }
        for (K key : this.myProbationalQueue.keySet()) {
            keyConsumer.consume(key);
        }
    }

    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>(this.myProtectedQueue.entrySet());
        set.addAll(this.myProbationalQueue.entrySet());
        return set;
    }

    public void clear() {
        for (Map.Entry<K, V> entry : this.myProtectedQueue.entrySet()) {
            this.onDropFromCache(entry.getKey(), entry.getValue());
        }
        this.myProtectedQueue.clear();
        for (Map.Entry<K, V> entry : this.myProbationalQueue.entrySet()) {
            this.onDropFromCache(entry.getKey(), entry.getValue());
        }
        this.myProbationalQueue.clear();
    }

    protected K getStableKey(K key) {
        if (key instanceof ShareableKey) {
            return (K)((ShareableKey)key).getStableCopy();
        }
        return key;
    }
}

