/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class FileContentUtilCore {
    public static void reparseFiles(final @NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/FileContentUtilCore", "reparseFiles"));
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                THashSet events = new THashSet();
                for (VirtualFile file : files) {
                    FileContentUtilCore.saveOrReload(file, events);
                }
                ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES).before(new ArrayList(events));
                ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES).after(new ArrayList(events));
            }
        });
    }

    private static void saveOrReload(VirtualFile virtualFile, Collection<VFilePropertyChangeEvent> events) {
        Document document;
        if (virtualFile == null || virtualFile.isDirectory() || !virtualFile.isValid()) {
            return;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        if (documentManager.isFileModified(virtualFile) && (document = documentManager.getDocument(virtualFile)) != null) {
            documentManager.saveDocument(document);
        }
        events.add(new VFilePropertyChangeEvent("FileContentUtilCore.saveOrReload", virtualFile, "name", virtualFile.getName(), virtualFile.getName(), false));
    }
}

