/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConcurrencyUtil {
    @NotNull
    public static <K, V> V cacheOrGet(@NotNull ConcurrentMap<K, V> map, @NotNull K key, @NotNull V defaultValue) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ConcurrencyUtil", "cacheOrGet"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/ConcurrencyUtil", "cacheOrGet"));
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/ConcurrencyUtil", "cacheOrGet"));
        }
        Object v = map.get(key);
        if (v != null) {
            Object v2 = v;
            if (v2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil", "cacheOrGet"));
            }
            return v2;
        }
        V prev = map.putIfAbsent(key, defaultValue);
        V v3 = prev == null ? defaultValue : prev;
        if (v3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil", "cacheOrGet"));
        }
        return v3;
    }

    @NotNull
    public static ScheduledThreadPoolExecutor newSingleScheduledThreadExecutor(@NonNls @NotNull String threadFactoryName, int threadPriority) {
        if (threadFactoryName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ConcurrencyUtil", "newSingleScheduledThreadExecutor"));
        }
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, ConcurrencyUtil.newNamedThreadFactory(threadFactoryName, true, threadPriority));
        executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = executor;
        if (scheduledThreadPoolExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil", "newSingleScheduledThreadExecutor"));
        }
        return scheduledThreadPoolExecutor;
    }

    @NotNull
    public static ThreadFactory newNamedThreadFactory(final @NonNls @NotNull String threadName, final boolean isDaemon, final int threadPriority) {
        if (threadName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ConcurrencyUtil", "newNamedThreadFactory"));
        }
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                if (r == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ConcurrencyUtil$1", "newThread"));
                }
                Thread thread2 = new Thread(r, threadName);
                thread2.setDaemon(isDaemon);
                thread2.setPriority(threadPriority);
                Thread thread3 = thread2;
                if (thread3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil$1", "newThread"));
                }
                return thread3;
            }
        };
        if (threadFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil", "newNamedThreadFactory"));
        }
        return threadFactory;
    }

    @NotNull
    public static ThreadFactory newNamedThreadFactory(final @NonNls @NotNull String threadName) {
        if (threadName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ConcurrencyUtil", "newNamedThreadFactory"));
        }
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                if (r == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ConcurrencyUtil$2", "newThread"));
                }
                Thread thread2 = new Thread(r, threadName);
                if (thread2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil$2", "newThread"));
                }
                return thread2;
            }
        };
        if (threadFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ConcurrencyUtil", "newNamedThreadFactory"));
        }
        return threadFactory;
    }
}

