/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.infos;

import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import org.jetbrains.annotations.NotNull;

public class CandidateInfo
implements JavaResolveResult {
    public static final CandidateInfo[] EMPTY_ARRAY = new CandidateInfo[0];
    private final PsiElement myPlace;
    private final PsiClass myAccessClass;
    private final PsiElement myCandidate;
    private Boolean myAccessProblem;
    private final boolean myStaticsProblem;
    protected final PsiSubstitutor mySubstitutor;
    private final PsiElement myCurrentFileResolveContext;
    private boolean myPackagePrefixPackageReference;
    public static final JavaResolveResult[] RESOLVE_RESULT_FOR_PACKAGE_PREFIX_PACKAGE = new JavaResolveResult[]{CandidateInfo.createCandidateInfoForPackagePrefixPart()};

    private CandidateInfo(PsiElement candidate, PsiSubstitutor substitutor, Boolean accessProblem, boolean staticsProblem, PsiElement currFileContext, PsiElement place, PsiClass accessClass) {
        this.myAccessProblem = null;
        this.myCandidate = candidate;
        this.myAccessProblem = accessProblem;
        this.myStaticsProblem = staticsProblem;
        this.mySubstitutor = substitutor;
        this.myCurrentFileResolveContext = currFileContext;
        this.myAccessClass = accessClass;
        this.myPlace = place;
    }

    public CandidateInfo(PsiElement candidate, PsiSubstitutor substitutor, boolean accessProblem, boolean staticsProblem, PsiElement currFileContext) {
        this(candidate, substitutor, accessProblem ? Boolean.TRUE : Boolean.FALSE, staticsProblem, currFileContext, null, null);
    }

    public CandidateInfo(PsiElement candidate, PsiSubstitutor substitutor, boolean accessProblem, boolean staticsProblem) {
        this(candidate, substitutor, accessProblem, staticsProblem, null);
    }

    public CandidateInfo(PsiElement candidate, PsiSubstitutor substitutor, PsiElement place, boolean staticsProblem) {
        this(candidate, substitutor, place, null, staticsProblem, null);
    }

    public CandidateInfo(PsiElement candidate, PsiSubstitutor substitutor, PsiElement place, PsiClass accessClass, boolean staticsProblem, PsiElement currFileContext) {
        this(candidate, substitutor, null, staticsProblem, currFileContext, place, accessClass);
    }

    public CandidateInfo(PsiElement candidate, PsiSubstitutor substitutor) {
        this(candidate, substitutor, null, null, false, null);
    }

    public CandidateInfo(@NotNull CandidateInfo candidate, PsiSubstitutor newSubstitutor) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/infos/CandidateInfo", "<init>"));
        }
        this(candidate.myCandidate, newSubstitutor, candidate.myPlace, null, candidate.myStaticsProblem, candidate.myCurrentFileResolveContext);
        this.myAccessProblem = candidate.myAccessProblem;
    }

    @Override
    public boolean isValidResult() {
        return this.isAccessible() && this.isStaticsScopeCorrect();
    }

    @Override
    public boolean isPackagePrefixPackageReference() {
        return this.myPackagePrefixPackageReference;
    }

    @Override
    public PsiElement getElement() {
        return this.myCandidate;
    }

    @Override
    public PsiSubstitutor getSubstitutor() {
        return this.mySubstitutor;
    }

    @Override
    public boolean isAccessible() {
        if (this.myAccessProblem == null) {
            boolean accessProblem = false;
            if (this.myPlace != null && this.myCandidate instanceof PsiMember) {
                PsiMember member = (PsiMember)this.myCandidate;
                boolean bl = accessProblem = !JavaPsiFacade.getInstance(this.myPlace.getProject()).getResolveHelper().isAccessible(member, member.getModifierList(), this.myPlace, this.myAccessClass, this.myCurrentFileResolveContext);
                if (!accessProblem && member.hasModifierProperty("private") && this.myPlace instanceof PsiReferenceExpression && JavaVersionService.getInstance().isAtLeast(this.myPlace, JavaSdkVersion.JDK_1_7)) {
                    accessProblem = this.isAccessedThroughTypeParameterBound();
                }
            }
            this.myAccessProblem = accessProblem ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.myAccessProblem == false;
    }

    private boolean isAccessedThroughTypeParameterBound() {
        JavaResolveResult resolveResult;
        PsiElement element;
        PsiExpression qualifierExpression = ((PsiReferenceExpression)this.myPlace).getQualifierExpression();
        if (qualifierExpression instanceof PsiMethodCallExpression && (element = (resolveResult = ((PsiMethodCallExpression)qualifierExpression).resolveMethodGenerics()).getElement()) instanceof PsiMethod) {
            PsiType returnType = ((PsiMethod)element).getReturnType();
            PsiType substitutedReturnType = resolveResult.getSubstitutor().substitute(returnType);
            if (substitutedReturnType instanceof PsiCapturedWildcardType || substitutedReturnType instanceof PsiWildcardType) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isStaticsScopeCorrect() {
        return !this.myStaticsProblem;
    }

    @Override
    public PsiElement getCurrentFileResolveScope() {
        return this.myCurrentFileResolveContext;
    }

    private void setPackagePrefixPackageReference(boolean packagePrefixPackageReference) {
        this.myPackagePrefixPackageReference = packagePrefixPackageReference;
    }

    public static CandidateInfo createCandidateInfoForPackagePrefixPart() {
        CandidateInfo candidateInfo = new CandidateInfo(null, PsiSubstitutor.EMPTY, false, false);
        candidateInfo.setPackagePrefixPackageReference(true);
        return candidateInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CandidateInfo that = (CandidateInfo)o;
        if (this.myPackagePrefixPackageReference != that.myPackagePrefixPackageReference) {
            return false;
        }
        if (this.myStaticsProblem != that.myStaticsProblem) {
            return false;
        }
        if (this.myAccessClass != null ? !this.myAccessClass.equals(that.myAccessClass) : that.myAccessClass != null) {
            return false;
        }
        if (this.myAccessProblem != null ? !this.myAccessProblem.equals(that.myAccessProblem) : that.myAccessProblem != null) {
            return false;
        }
        if (this.myCandidate != null ? !this.myCandidate.equals(that.myCandidate) : that.myCandidate != null) {
            return false;
        }
        if (this.myCurrentFileResolveContext != null ? !this.myCurrentFileResolveContext.equals(that.myCurrentFileResolveContext) : that.myCurrentFileResolveContext != null) {
            return false;
        }
        if (this.myPlace != null ? !this.myPlace.equals(that.myPlace) : that.myPlace != null) {
            return false;
        }
        return !(this.mySubstitutor != null ? !this.mySubstitutor.equals(that.mySubstitutor) : that.mySubstitutor != null);
    }

    public int hashCode() {
        int result = this.myPlace != null ? this.myPlace.hashCode() : 0;
        result = 31 * result + (this.myAccessClass != null ? this.myAccessClass.hashCode() : 0);
        result = 31 * result + (this.myCandidate != null ? this.myCandidate.hashCode() : 0);
        result = 31 * result + (this.myAccessProblem != null ? this.myAccessProblem.hashCode() : 0);
        result = 31 * result + (this.myStaticsProblem ? 1 : 0);
        result = 31 * result + (this.mySubstitutor != null ? this.mySubstitutor.hashCode() : 0);
        result = 31 * result + (this.myCurrentFileResolveContext != null ? this.myCurrentFileResolveContext.hashCode() : 0);
        result = 31 * result + (this.myPackagePrefixPackageReference ? 1 : 0);
        return result;
    }
}

