/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.calls.CallResolverExtension;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public class NeedSyntheticCallResolverExtension
implements CallResolverExtension {
    @Override
    public <F extends CallableDescriptor> void run(@NotNull OverloadResolutionResultsImpl<F> results, @NotNull BasicCallResolutionContext context) {
        ResolvedCall resolvedCall;
        Object targetDescriptor;
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/jet/lang/resolve/calls/NeedSyntheticCallResolverExtension", "run"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/NeedSyntheticCallResolverExtension", "run"));
        }
        if (results.isSingleResult() && this.needSyntheticAccessor(context.scope, (CallableDescriptor)(targetDescriptor = (resolvedCall = results.getResultingCall()).getResultingDescriptor()))) {
            context.trace.record(BindingContext.NEED_SYNTHETIC_ACCESSOR, (CallableMemberDescriptor)targetDescriptor.getOriginal(), Boolean.TRUE);
        }
    }

    private boolean needSyntheticAccessor(JetScope invokationScope, CallableDescriptor targetDescriptor) {
        return targetDescriptor instanceof CallableMemberDescriptor && targetDescriptor.getVisibility() == Visibilities.PRIVATE && targetDescriptor.getContainingDeclaration() != invokationScope.getContainingDeclaration().getContainingDeclaration();
    }
}

