/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceDescriptorParent;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamespaceHeader;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.NamespaceFactory;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;

public class NamespaceFactoryImpl
implements NamespaceFactory {
    private ModuleDescriptorImpl moduleDescriptor;
    private BindingTrace trace;

    public void setModuleDescriptor(ModuleDescriptorImpl moduleDescriptor) {
        this.moduleDescriptor = moduleDescriptor;
    }

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    @NotNull
    public NamespaceDescriptorImpl createNamespaceDescriptorPathIfNeeded(@NotNull JetFile file, @NotNull JetScope outerScope, @NotNull RedeclarationHandler handler) {
        NamespaceDescriptorImpl namespaceDescriptor;
        NamespaceDescriptorImpl currentOwner;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/NamespaceFactoryImpl", "createNamespaceDescriptorPathIfNeeded"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/jet/lang/resolve/NamespaceFactoryImpl", "createNamespaceDescriptorPathIfNeeded"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/jet/lang/resolve/NamespaceFactoryImpl", "createNamespaceDescriptorPathIfNeeded"));
        }
        JetNamespaceHeader namespaceHeader = file.getNamespaceHeader();
        if (this.moduleDescriptor.getRootNamespaceDescriptorImpl() == null) {
            this.createRootNamespaceDescriptorIfNeeded(null, this.moduleDescriptor, null, handler);
        }
        if ((currentOwner = this.moduleDescriptor.getRootNamespaceDescriptorImpl()) == null) {
            throw new IllegalStateException("must be initialized 5 lines above");
        }
        for (JetSimpleNameExpression nameExpression : namespaceHeader.getParentNamespaceNames()) {
            Name namespaceName = Name.identifier(nameExpression.getReferencedName());
            NamespaceDescriptorImpl namespaceDescriptor2 = this.createNamespaceDescriptorIfNeeded(null, currentOwner, namespaceName, nameExpression, handler);
            this.trace.record(BindingContext.NAMESPACE_IS_SRC, namespaceDescriptor2, true);
            this.trace.record(BindingContext.RESOLUTION_SCOPE, nameExpression, outerScope);
            outerScope = namespaceDescriptor2.getMemberScope();
            currentOwner = namespaceDescriptor2;
        }
        if (namespaceHeader.isRoot()) {
            namespaceDescriptor = this.moduleDescriptor.getRootNamespaceDescriptorImpl();
            this.storeBindingForFileAndExpression(file, null, namespaceDescriptor);
        } else {
            Name name = namespaceHeader.getNameAsName();
            namespaceDescriptor = this.createNamespaceDescriptorIfNeeded(file, currentOwner, name, namespaceHeader.getLastPartExpression(), handler);
            this.trace.record(BindingContext.RESOLUTION_SCOPE, namespaceHeader, outerScope);
        }
        this.trace.record(BindingContext.NAMESPACE_IS_SRC, namespaceDescriptor, true);
        NamespaceDescriptorImpl namespaceDescriptorImpl = namespaceDescriptor;
        if (namespaceDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/NamespaceFactoryImpl", "createNamespaceDescriptorPathIfNeeded"));
        }
        return namespaceDescriptorImpl;
    }

    @Override
    @NotNull
    public NamespaceDescriptorImpl createNamespaceDescriptorPathIfNeeded(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/NamespaceFactoryImpl", "createNamespaceDescriptorPathIfNeeded"));
        }
        NamespaceDescriptorImpl owner = null;
        for (FqName pathElement : fqName.path()) {
            if (pathElement.isRoot()) {
                owner = this.createRootNamespaceDescriptorIfNeeded(null, this.moduleDescriptor, null, RedeclarationHandler.DO_NOTHING);
                continue;
            }
            assert (owner != null) : "Should never be null as first element in the path must be root";
            owner = this.createNamespaceDescriptorIfNeeded(null, owner, pathElement.shortName(), null, RedeclarationHandler.DO_NOTHING);
        }
        assert (owner != null) : "Should never be null as first element in the path must be root";
        NamespaceDescriptorImpl namespaceDescriptorImpl = owner;
        if (namespaceDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/NamespaceFactoryImpl", "createNamespaceDescriptorPathIfNeeded"));
        }
        return namespaceDescriptorImpl;
    }

    private NamespaceDescriptorImpl createRootNamespaceDescriptorIfNeeded(@Nullable JetFile file, @NotNull ModuleDescriptorImpl owner, @Nullable JetReferenceExpression expression, @NotNull RedeclarationHandler handler) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/NamespaceFactoryImpl", "createRootNamespaceDescriptorIfNeeded"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/jet/lang/resolve/NamespaceFactoryImpl", "createRootNamespaceDescriptorIfNeeded"));
        }
        FqName fqName = FqName.ROOT;
        NamespaceDescriptorImpl namespaceDescriptor = owner.getRootNamespaceDescriptorImpl();
        if (namespaceDescriptor == null) {
            namespaceDescriptor = this.createNewNamespaceDescriptor(owner, FqNameUnsafe.ROOT_NAME, expression, handler, fqName);
        }
        this.storeBindingForFileAndExpression(file, expression, namespaceDescriptor);
        return namespaceDescriptor;
    }

    @NotNull
    private NamespaceDescriptorImpl createNamespaceDescriptorIfNeeded(@Nullable JetFile file, @NotNull NamespaceDescriptorImpl owner, @NotNull Name name, @Nullable JetReferenceExpression expression, @NotNull RedeclarationHandler handler) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/NamespaceFactoryImpl", "createNamespaceDescriptorIfNeeded"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/NamespaceFactoryImpl", "createNamespaceDescriptorIfNeeded"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/jet/lang/resolve/NamespaceFactoryImpl", "createNamespaceDescriptorIfNeeded"));
        }
        FqName ownerFqName = DescriptorUtils.getFQName(owner).toSafe();
        FqName fqName = ownerFqName.child(name);
        NamespaceDescriptorImpl namespaceDescriptor = (NamespaceDescriptorImpl)owner.getMemberScope().getDeclaredNamespace(name);
        if (namespaceDescriptor == null) {
            namespaceDescriptor = this.createNewNamespaceDescriptor(owner, name, expression, handler, fqName);
        }
        this.storeBindingForFileAndExpression(file, expression, namespaceDescriptor);
        NamespaceDescriptorImpl namespaceDescriptorImpl = namespaceDescriptor;
        if (namespaceDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/NamespaceFactoryImpl", "createNamespaceDescriptorIfNeeded"));
        }
        return namespaceDescriptorImpl;
    }

    private NamespaceDescriptorImpl createNewNamespaceDescriptor(NamespaceDescriptorParent owner, Name name, PsiElement expression, RedeclarationHandler handler, FqName fqName) {
        NamespaceDescriptorImpl namespaceDescriptor = new NamespaceDescriptorImpl(owner, Collections.<AnnotationDescriptor>emptyList(), name);
        this.trace.record(BindingContext.FQNAME_TO_NAMESPACE_DESCRIPTOR, fqName, namespaceDescriptor);
        WritableScopeImpl scope = new WritableScopeImpl(JetScope.EMPTY, namespaceDescriptor, handler, "Namespace member scope");
        scope.changeLockLevel(WritableScope.LockLevel.BOTH);
        namespaceDescriptor.initialize(scope);
        scope.changeLockLevel(WritableScope.LockLevel.BOTH);
        this.moduleDescriptor.getModuleConfiguration().extendNamespaceScope(namespaceDescriptor, scope);
        owner.addNamespace(namespaceDescriptor);
        if (expression != null) {
            this.trace.record(BindingContext.NAMESPACE, expression, namespaceDescriptor);
        }
        return namespaceDescriptor;
    }

    private void storeBindingForFileAndExpression(@Nullable JetFile file, @Nullable JetReferenceExpression expression, @NotNull NamespaceDescriptor namespaceDescriptor) {
        if (namespaceDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceDescriptor", "org/jetbrains/jet/lang/resolve/NamespaceFactoryImpl", "storeBindingForFileAndExpression"));
        }
        if (expression != null) {
            this.trace.record(BindingContext.REFERENCE_TARGET, expression, namespaceDescriptor);
        }
        if (file != null) {
            this.trace.record(BindingContext.FILE_TO_NAMESPACE, file, namespaceDescriptor);
            Collection<JetFile> files = this.trace.get(BindingContext.NAMESPACE_TO_FILES, namespaceDescriptor);
            if (files == null) {
                files = Sets.newIdentityHashSet();
            }
            files.add(file);
            this.trace.record(BindingContext.NAMESPACE_TO_FILES, namespaceDescriptor, files);
        }
    }
}

