/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.stubs.PsiJetParameterStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementType;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lang.psi.stubs.impl.PsiJetParameterStubImpl;

public class JetParameterElementType
extends JetStubElementType<PsiJetParameterStub, JetParameter> {
    public JetParameterElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/jet/lang/psi/stubs/elements/JetParameterElementType", "<init>"));
        }
        super(debugName);
    }

    @Override
    public JetParameter createPsiFromAst(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/stubs/elements/JetParameterElementType", "createPsiFromAst"));
        }
        return new JetParameter(node);
    }

    @Override
    public JetParameter createPsi(@NotNull PsiJetParameterStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/stubs/elements/JetParameterElementType", "createPsi"));
        }
        return new JetParameter(stub, (IStubElementType)JetStubElementTypes.VALUE_PARAMETER);
    }

    @Override
    public PsiJetParameterStub createStub(@NotNull JetParameter psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/jet/lang/psi/stubs/elements/JetParameterElementType", "createStub"));
        }
        JetTypeReference typeReference = psi.getTypeReference();
        JetExpression defaultValue = psi.getDefaultValue();
        return new PsiJetParameterStubImpl((IStubElementType)JetStubElementTypes.VALUE_PARAMETER, parentStub, psi.getName(), psi.isMutable(), psi.isVarArg(), typeReference != null ? typeReference.getText() : null, defaultValue != null ? defaultValue.getText() : null);
    }

    @Override
    public boolean shouldCreateStub(ASTNode node) {
        return node.getElementType() == JetStubElementTypes.VALUE_PARAMETER;
    }

    @Override
    public void serialize(PsiJetParameterStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        dataStream.writeBoolean(stub.isMutable());
        dataStream.writeBoolean(stub.isVarArg());
        dataStream.writeName(stub.getTypeText());
        dataStream.writeName(stub.getDefaultValueText());
    }

    @Override
    public PsiJetParameterStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef name = dataStream.readName();
        boolean isMutable = dataStream.readBoolean();
        boolean isVarArg = dataStream.readBoolean();
        StringRef typeText = dataStream.readName();
        StringRef defaultValueText = dataStream.readName();
        return new PsiJetParameterStubImpl((IStubElementType)JetStubElementTypes.VALUE_PARAMETER, parentStub, name, isMutable, isVarArg, typeText, defaultValueText);
    }

    @Override
    public void indexStub(PsiJetParameterStub stub, IndexSink sink) {
    }
}

