/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.cfg.Label;
import org.jetbrains.jet.lang.cfg.pseudocode.AbstractJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;
import org.jetbrains.jet.lang.cfg.pseudocode.JetElementInstruction;
import org.jetbrains.jet.lang.psi.JetElement;

public class ReturnNoValueInstruction
extends AbstractJumpInstruction
implements JetElementInstruction {
    private final JetElement element;

    public ReturnNoValueInstruction(@NotNull JetElement element, Label targetLabel) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/pseudocode/ReturnNoValueInstruction", "<init>"));
        }
        super(targetLabel);
        this.element = element;
    }

    @Override
    @NotNull
    public JetElement getElement() {
        JetElement jetElement = this.element;
        if (jetElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/ReturnNoValueInstruction", "getElement"));
        }
        return jetElement;
    }

    @Override
    public void accept(InstructionVisitor visitor) {
        visitor.visitReturnNoValue(this);
    }

    public String toString() {
        return "ret " + this.getTargetLabel();
    }

    @Override
    protected AbstractJumpInstruction createCopy(@NotNull Label newLabel) {
        if (newLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLabel", "org/jetbrains/jet/lang/cfg/pseudocode/ReturnNoValueInstruction", "createCopy"));
        }
        return new ReturnNoValueInstruction(this.element, newLabel);
    }
}

