/*
 * Decompiled with CFR 0.152.
 */
package com.sampullara.cli;

import com.intellij.util.containers.ComparatorUtil;
import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;

public class ArgumentUtils {
    @NotNull
    public static <T> String convertArgumentsToString(T arguments, T defaultArguments) {
        StringBuilder result = new StringBuilder();
        ArgumentUtils.convertArgumentsToString(arguments, defaultArguments, arguments.getClass(), result);
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sampullara/cli/ArgumentUtils", "convertArgumentsToString"));
        }
        return string;
    }

    public static <T> void convertArgumentsToString(T arguments, T defaultArguments, Class clazz, StringBuilder result) {
        Class superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            ArgumentUtils.convertArgumentsToString(arguments, defaultArguments, superClazz, result);
        }
        for (Field field : clazz.getDeclaredFields()) {
            Object defaultValue;
            Object value;
            Argument argument = field.getAnnotation(Argument.class);
            if (argument == null) continue;
            try {
                value = field.get(arguments);
                defaultValue = field.get(defaultArguments);
            }
            catch (IllegalAccessException ignored) {
                continue;
            }
            if (ComparatorUtil.equalsNullable(value, defaultValue)) continue;
            String name = Args.getAlias(argument);
            if (name == null) {
                name = Args.getName(argument, field);
            }
            result.append("-").append(name).append(" ");
            Class<?> fieldType = field.getType();
            if (fieldType == Boolean.TYPE || fieldType == Boolean.class) continue;
            result.append(value).append(" ");
        }
    }
}

