/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilteringIterator<Dom, E extends Dom>
implements Iterator<E> {
    private final Iterator<Dom> myBaseIterator;
    private final Condition<Dom> myFilter;
    private boolean myNextObtained = false;
    private boolean myCurrentIsValid = false;
    private Dom myCurrent;
    private Boolean myCurrentPassedFilter = null;
    public static final Condition NOT_NULL = new Condition(){

        public boolean value(Object t) {
            return t != null;
        }
    };

    public FilteringIterator(Iterator<Dom> baseIterator, Condition<Dom> filter) {
        this.myBaseIterator = baseIterator;
        this.myFilter = filter;
    }

    private void obtainNext() {
        if (this.myNextObtained) {
            return;
        }
        boolean hasNext = this.myBaseIterator.hasNext();
        this.setCurrent(hasNext ? (Dom)this.myBaseIterator.next() : null);
        this.myCurrentIsValid = hasNext;
        this.myNextObtained = true;
    }

    @Override
    public boolean hasNext() {
        this.obtainNext();
        if (!this.myCurrentIsValid) {
            return false;
        }
        boolean value = this.isCurrentPassesFilter();
        while (!value && this.myBaseIterator.hasNext()) {
            Dom next = this.myBaseIterator.next();
            this.setCurrent(next);
            value = this.isCurrentPassesFilter();
        }
        return value;
    }

    private void setCurrent(Dom next) {
        this.myCurrent = next;
        this.myCurrentPassedFilter = null;
    }

    private boolean isCurrentPassesFilter() {
        if (this.myCurrentPassedFilter != null) {
            return this.myCurrentPassedFilter;
        }
        boolean passed = this.myFilter.value(this.myCurrent);
        this.myCurrentPassedFilter = passed;
        return passed;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Dom result = this.myCurrent;
        this.myNextObtained = false;
        return (E)result;
    }

    @Override
    public void remove() {
        if (this.myNextObtained) {
            throw new IllegalStateException();
        }
        this.myBaseIterator.remove();
    }
}

