/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.CommitToPsiFileAction;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.TextBlock;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.text.BlockSupport;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiDocumentManagerBase
extends PsiDocumentManager
implements DocumentListener {
    protected static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiDocumentManagerImpl");
    protected static final Key<PsiFile> HARD_REF_TO_PSI = new Key("HARD_REFERENCE_TO_PSI");
    protected static final Key<List<Runnable>> ACTION_AFTER_COMMIT = Key.create("ACTION_AFTER_COMMIT");
    protected final Project myProject;
    protected final PsiManager myPsiManager;
    protected final DocumentCommitProcessor myDocumentCommitProcessor;
    protected final Set<Document> myUncommittedDocuments;
    protected volatile boolean myIsCommitInProgress;
    protected final PsiToDocumentSynchronizer mySynchronizer;
    protected final List<PsiDocumentManager.Listener> myListeners;
    protected final SmartPointerManagerImpl mySmartPointerManager;
    private final Map<Object, Runnable> actionsWhenAllDocumentsAreCommitted;
    private static final Object PERFORM_ALWAYS_KEY = new Object(){

        @NonNls
        public String toString() {
            return "PERFORM_ALWAYS";
        }
    };

    public PsiDocumentManagerBase(@NotNull Project project, @NotNull PsiManager psiManager, @NotNull SmartPointerManager smartPointerManager, @NotNull MessageBus bus, @NonNls @NotNull DocumentCommitProcessor documentCommitProcessor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "<init>"));
        }
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiDocumentManagerBase", "<init>"));
        }
        if (smartPointerManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/PsiDocumentManagerBase", "<init>"));
        }
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/PsiDocumentManagerBase", "<init>"));
        }
        if (documentCommitProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/psi/impl/PsiDocumentManagerBase", "<init>"));
        }
        this.myUncommittedDocuments = Collections.synchronizedSet(new THashSet());
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.actionsWhenAllDocumentsAreCommitted = new LinkedHashMap<Object, Runnable>();
        this.myProject = project;
        this.myPsiManager = psiManager;
        this.myDocumentCommitProcessor = documentCommitProcessor;
        this.mySmartPointerManager = (SmartPointerManagerImpl)smartPointerManager;
        this.mySynchronizer = new PsiToDocumentSynchronizer(this, bus);
        this.myPsiManager.addPsiTreeChangeListener(this.mySynchronizer);
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    @NotNull
    public String getComponentName() {
        if ("PsiDocumentManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiDocumentManagerBase", "getComponentName"));
        }
        return "PsiDocumentManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @Override
    @Nullable
    public PsiFile getPsiFile(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "getPsiFile"));
        }
        PsiFile userData = document.getUserData(HARD_REF_TO_PSI);
        if (userData != null) {
            return userData;
        }
        PsiFile psiFile = this.getCachedPsiFile(document);
        if (psiFile != null) {
            return psiFile;
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        psiFile = this.getPsiFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        this.fireFileCreated(document, psiFile);
        return psiFile;
    }

    public static void cachePsi(@NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "cachePsi"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiDocumentManagerBase", "cachePsi"));
        }
        document.putUserData(HARD_REF_TO_PSI, file);
    }

    @Override
    public PsiFile getCachedPsiFile(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "getCachedPsiFile"));
        }
        PsiFile userData = document.getUserData(HARD_REF_TO_PSI);
        if (userData != null) {
            return userData;
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        return this.getCachedPsiFile(virtualFile);
    }

    @Nullable
    public FileViewProvider getCachedViewProvider(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "getCachedViewProvider"));
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        return ((PsiManagerEx)this.myPsiManager).getFileManager().findCachedViewProvider(virtualFile);
    }

    @Nullable
    protected PsiFile getCachedPsiFile(VirtualFile virtualFile) {
        return ((PsiManagerEx)this.myPsiManager).getFileManager().getCachedPsiFile(virtualFile);
    }

    @Nullable
    protected PsiFile getPsiFile(VirtualFile virtualFile) {
        return ((PsiManagerEx)this.myPsiManager).getFileManager().findFile(virtualFile);
    }

    @Override
    @Nullable
    public Document getDocument(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "getDocument"));
        }
        if (file instanceof PsiBinaryFile) {
            return null;
        }
        Document document = this.getCachedDocument(file);
        if (document != null) {
            if (!file.getViewProvider().isPhysical() && document.getUserData(HARD_REF_TO_PSI) == null) {
                PsiDocumentManagerBase.cachePsi(document, file);
            }
            return document;
        }
        if (!file.getViewProvider().isEventSystemEnabled()) {
            return null;
        }
        document = FileDocumentManager.getInstance().getDocument(file.getViewProvider().getVirtualFile());
        if (document != null) {
            if (document.getTextLength() != file.getTextLength()) {
                throw new AssertionError((Object)("Modified PSI with no document: " + file + "; physical=" + file.getViewProvider().isPhysical()));
            }
            if (!file.getViewProvider().isPhysical()) {
                PsiDocumentManagerBase.cachePsi(document, file);
            }
        }
        return document;
    }

    @Override
    public Document getCachedDocument(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "getCachedDocument"));
        }
        if (!file.isPhysical()) {
            return null;
        }
        VirtualFile vFile = file.getViewProvider().getVirtualFile();
        return FileDocumentManager.getInstance().getCachedDocument(vFile);
    }

    @Override
    public void commitAllDocuments() {
        Document[] documents;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myUncommittedDocuments.isEmpty()) {
            return;
        }
        for (Document document : documents = this.getUncommittedDocuments()) {
            this.commitDocument(document);
        }
        LOG.assertTrue(!this.hasUncommitedDocuments(), this.myUncommittedDocuments);
    }

    @Override
    public void performForCommittedDocument(@NotNull Document doc, @NotNull Runnable action) {
        Document document;
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "performForCommittedDocument"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiDocumentManagerBase", "performForCommittedDocument"));
        }
        Document document2 = document = doc instanceof DocumentWindow ? ((DocumentWindow)doc).getDelegate() : doc;
        if (this.isCommitted(document)) {
            action.run();
        } else {
            PsiDocumentManagerBase.addRunOnCommit(document, action);
        }
    }

    public boolean cancelAndRunWhenAllCommitted(@NonNls @NotNull Object key, @NotNull Runnable action) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "cancelAndRunWhenAllCommitted"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiDocumentManagerBase", "cancelAndRunWhenAllCommitted"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            action.run();
            return true;
        }
        if (this.myUncommittedDocuments.isEmpty()) {
            action.run();
            assert (this.actionsWhenAllDocumentsAreCommitted.isEmpty()) : this.actionsWhenAllDocumentsAreCommitted;
            return true;
        }
        this.actionsWhenAllDocumentsAreCommitted.put(key, action);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRunOnCommit(@NotNull Document document, @NotNull Runnable action) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "addRunOnCommit"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiDocumentManagerBase", "addRunOnCommit"));
        }
        Key<List<Runnable>> key = ACTION_AFTER_COMMIT;
        synchronized (key) {
            List<Runnable> list2 = document.getUserData(ACTION_AFTER_COMMIT);
            if (list2 == null) {
                list2 = new SmartList<Runnable>();
                document.putUserData(ACTION_AFTER_COMMIT, list2);
            }
            list2.add(action);
        }
    }

    @Override
    public void commitDocument(@NotNull Document doc) {
        Document document;
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "commitDocument"));
        }
        Document document2 = document = doc instanceof DocumentWindow ? ((DocumentWindow)doc).getDelegate() : doc;
        if (!this.isCommitted(document)) {
            this.doCommit(document);
        }
    }

    public boolean finishCommit(final @NotNull Document document, final @NotNull List<Processor<Document>> finishProcessors, final boolean synchronously, @NotNull Object reason) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "finishCommit"));
        }
        if (finishProcessors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiDocumentManagerBase", "finishCommit"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/PsiDocumentManagerBase", "finishCommit"));
        }
        assert (!this.myProject.isDisposed()) : "Already disposed";
        final boolean[] ok = new boolean[]{true};
        ApplicationManager.getApplication().runWriteAction(new CommitToPsiFileAction(document, this.myProject){

            @Override
            public void run() {
                ok[0] = PsiDocumentManagerBase.this.finishCommitInWriteAction(document, finishProcessors, synchronously);
            }
        });
        if (ok[0]) {
            InjectedLanguageManager injectedLanguageManager;
            if (!this.mySynchronizer.isDocumentAffectedByTransactions(document) && (injectedLanguageManager = InjectedLanguageManager.getInstance(this.myProject)) != null) {
                injectedLanguageManager.startRunInjectors(document, synchronously);
            }
            this.runAfterCommitActions(document);
            if (DebugUtil.DO_EXPENSIVE_CHECKS) {
                this.checkAllElementsValid(document, reason);
            }
        }
        return ok[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean finishCommitInWriteAction(@NotNull Document document, @NotNull List<Processor<Document>> finishProcessors, boolean synchronously) {
        boolean success;
        block10: {
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "finishCommitInWriteAction"));
            }
            if (finishProcessors == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiDocumentManagerBase", "finishCommitInWriteAction"));
            }
            if (this.myProject.isDisposed()) {
                return false;
            }
            assert (!(document instanceof DocumentWindow));
            this.myIsCommitInProgress = true;
            success = true;
            try {
                FileViewProvider viewProvider = this.getCachedViewProvider(document);
                if (viewProvider == null) break block10;
                for (Processor<Document> finishRunnable : finishProcessors) {
                    success = finishRunnable.process(document);
                    if (synchronously) assert (success);
                    if (success) continue;
                    break;
                }
                viewProvider.contentsSynchronized();
            }
            catch (Throwable throwable) {
                this.myDocumentCommitProcessor.log("in PDI.finishDoc: ", null, synchronously, success, this.myUncommittedDocuments);
                if (success) {
                    this.myUncommittedDocuments.remove(document);
                    this.myDocumentCommitProcessor.log("in PDI.finishDoc: removed doc", null, synchronously, success, this.myUncommittedDocuments);
                }
                this.myIsCommitInProgress = false;
                this.myDocumentCommitProcessor.log("in PDI.finishDoc: exit", null, synchronously, success, this.myUncommittedDocuments);
                throw throwable;
            }
        }
        this.myDocumentCommitProcessor.log("in PDI.finishDoc: ", null, synchronously, success, this.myUncommittedDocuments);
        if (success) {
            this.myUncommittedDocuments.remove(document);
            this.myDocumentCommitProcessor.log("in PDI.finishDoc: removed doc", null, synchronously, success, this.myUncommittedDocuments);
        }
        this.myIsCommitInProgress = false;
        this.myDocumentCommitProcessor.log("in PDI.finishDoc: exit", null, synchronously, success, this.myUncommittedDocuments);
        return success;
    }

    private void checkAllElementsValid(@NotNull Document document, final @NotNull Object reason) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "checkAllElementsValid"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiDocumentManagerBase", "checkAllElementsValid"));
        }
        final PsiFile psiFile = this.getCachedPsiFile(document);
        if (psiFile != null) {
            psiFile.accept(new PsiRecursiveElementWalkingVisitor(){

                @Override
                public void visitElement(PsiElement element) {
                    if (!element.isValid()) {
                        throw new AssertionError((Object)("Commit to '" + psiFile.getVirtualFile() + "' has led to invalid element: " + element + "; Reason: '" + reason + "'"));
                    }
                }
            });
        }
    }

    private void doCommit(final @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "doCommit"));
        }
        assert (!this.myIsCommitInProgress) : "Do not call commitDocument() from inside PSI change listener";
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (PsiDocumentManagerBase.this.getSynchronizer().isDocumentAffectedByTransactions(document)) {
                    return;
                }
                PsiDocumentManagerBase.this.myIsCommitInProgress = true;
                try {
                    PsiDocumentManagerBase.this.myDocumentCommitProcessor.commitSynchronously(document, PsiDocumentManagerBase.this.myProject);
                }
                finally {
                    PsiDocumentManagerBase.this.myIsCommitInProgress = false;
                }
                assert (!PsiDocumentManagerBase.this.isInUncommittedSet(document)) : "Document :" + document;
            }
        });
    }

    @Override
    public <T> T commitAndRunReadAction(final @NotNull Computable<T> computation) {
        if (computation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "commitAndRunReadAction"));
        }
        final Ref<Object> ref = Ref.create(null);
        this.commitAndRunReadAction(new Runnable(){

            @Override
            public void run() {
                ref.set(computation.compute());
            }
        });
        return ref.get();
    }

    @Override
    public void reparseFiles(@NotNull Collection<VirtualFile> files, boolean includeOpenFiles) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "reparseFiles"));
        }
        FileContentUtilCore.reparseFiles(files);
    }

    @Override
    public void commitAndRunReadAction(final @NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "commitAndRunReadAction"));
        }
        Application application = ApplicationManager.getApplication();
        if (SwingUtilities.isEventDispatchThread()) {
            this.commitAllDocuments();
            runnable2.run();
        } else {
            LOG.assertTrue(!ApplicationManager.getApplication().isReadAccessAllowed(), "Don't call commitAndRunReadAction inside ReadAction, it will cause a deadlock otherwise.");
            final Semaphore s1 = new Semaphore();
            final Semaphore s2 = new Semaphore();
            final boolean[] committed = new boolean[]{false};
            application.runReadAction(new Runnable(){

                @Override
                public void run() {
                    if (PsiDocumentManagerBase.this.myUncommittedDocuments.isEmpty()) {
                        runnable2.run();
                        committed[0] = true;
                    } else {
                        s1.down();
                        s2.down();
                        Runnable commitRunnable = new Runnable(){

                            @Override
                            public void run() {
                                PsiDocumentManagerBase.this.commitAllDocuments();
                                s1.up();
                                s2.waitFor();
                            }
                        };
                        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                        if (progressIndicator == null) {
                            ApplicationManager.getApplication().invokeLater(commitRunnable);
                        } else {
                            ApplicationManager.getApplication().invokeLater(commitRunnable, progressIndicator.getModalityState());
                        }
                    }
                }
            });
            if (!committed[0]) {
                s1.waitFor();
                application.runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        s2.up();
                        runnable2.run();
                    }
                });
            }
        }
    }

    @Override
    public boolean performWhenAllCommitted(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "performWhenAllCommitted"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (!this.myProject.isDisposed()) : "Already disposed: " + this.myProject;
        if (this.myUncommittedDocuments.isEmpty()) {
            action.run();
            return true;
        }
        CompositeRunnable actions = (CompositeRunnable)this.actionsWhenAllDocumentsAreCommitted.get(PERFORM_ALWAYS_KEY);
        if (actions == null) {
            actions = new CompositeRunnable();
            this.actionsWhenAllDocumentsAreCommitted.put(PERFORM_ALWAYS_KEY, actions);
        }
        actions.add(action);
        this.myDocumentCommitProcessor.log("PDI: added performWhenAllCommitted", null, false, action, this.myUncommittedDocuments);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAfterCommitActions(@NotNull Document document) {
        List<Runnable> list2;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "runAfterCommitActions"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Key<List<Runnable>> key = ACTION_AFTER_COMMIT;
        synchronized (key) {
            list2 = document.getUserData(ACTION_AFTER_COMMIT);
            if (list2 != null) {
                list2 = new ArrayList<Runnable>(list2);
                document.putUserData(ACTION_AFTER_COMMIT, null);
            }
        }
        if (list2 != null) {
            for (Runnable runnable2 : list2) {
                runnable2.run();
            }
        }
        if (!this.hasUncommitedDocuments() && !this.actionsWhenAllDocumentsAreCommitted.isEmpty()) {
            ArrayList<Object> keys = new ArrayList<Object>(this.actionsWhenAllDocumentsAreCommitted.keySet());
            for (Object e : keys) {
                Runnable action = this.actionsWhenAllDocumentsAreCommitted.remove(e);
                this.myDocumentCommitProcessor.log("Running after commit runnable: ", null, false, e, action);
                action.run();
            }
        }
    }

    @Override
    public void addListener(@NotNull PsiDocumentManager.Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "addListener"));
        }
        this.myListeners.add(listener);
    }

    @Override
    public void removeListener(@NotNull PsiDocumentManager.Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "removeListener"));
        }
        this.myListeners.remove(listener);
    }

    @Override
    public boolean isDocumentBlockedByPsi(@NotNull Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "isDocumentBlockedByPsi"));
        }
        return false;
    }

    @Override
    public void doPostponedOperationsAndUnblockDocument(@NotNull Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "doPostponedOperationsAndUnblockDocument"));
        }
    }

    protected void fireDocumentCreated(@NotNull Document document, PsiFile file) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "fireDocumentCreated"));
        }
        for (PsiDocumentManager.Listener listener : this.myListeners) {
            listener.documentCreated(document, file);
        }
    }

    private void fireFileCreated(Document document, PsiFile file) {
        for (PsiDocumentManager.Listener listener : this.myListeners) {
            listener.fileCreated(file, document);
        }
    }

    @Override
    @NotNull
    public Document[] getUncommittedDocuments() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Document[] documentArray = this.myUncommittedDocuments.toArray(new Document[this.myUncommittedDocuments.size()]);
        if (documentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiDocumentManagerBase", "getUncommittedDocuments"));
        }
        return documentArray;
    }

    boolean isInUncommittedSet(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "isInUncommittedSet"));
        }
        if (document instanceof DocumentWindow) {
            return this.isInUncommittedSet(((DocumentWindow)document).getDelegate());
        }
        return this.myUncommittedDocuments.contains(document);
    }

    @Override
    public boolean isUncommited(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "isUncommited"));
        }
        return !this.isCommitted(document);
    }

    @Override
    public boolean isCommitted(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "isCommitted"));
        }
        if (document instanceof DocumentWindow) {
            return this.isCommitted(((DocumentWindow)document).getDelegate());
        }
        if (this.getSynchronizer().isInSynchronization(document)) {
            return true;
        }
        return !((DocumentEx)document).isInEventsHandling() && !this.isInUncommittedSet(document);
    }

    @Override
    public boolean hasUncommitedDocuments() {
        return !this.myIsCommitInProgress && !this.myUncommittedDocuments.isEmpty();
    }

    @Override
    public void beforeDocumentChange(DocumentEvent event) {
        Document document = event.getDocument();
        FileViewProvider viewProvider = this.getCachedViewProvider(document);
        if (viewProvider == null) {
            return;
        }
        if (!this.isRelevant(viewProvider)) {
            return;
        }
        VirtualFile virtualFile = viewProvider.getVirtualFile();
        if (virtualFile.getFileType().isBinary()) {
            return;
        }
        List<PsiFile> files = viewProvider.getAllFiles();
        PsiFile psiCause = null;
        for (PsiFile file : files) {
            this.mySmartPointerManager.fastenBelts(file, event.getOffset(), null);
            if (!TextBlock.get(file).isLocked()) continue;
            psiCause = file;
        }
        if (psiCause == null) {
            this.beforeDocumentChangeOnUnlockedDocument(viewProvider);
        }
        ((SingleRootFileViewProvider)viewProvider).beforeDocumentChanged(psiCause);
    }

    protected void beforeDocumentChangeOnUnlockedDocument(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "beforeDocumentChangeOnUnlockedDocument"));
        }
    }

    @Override
    public void documentChanged(DocumentEvent event) {
        boolean forceCommit;
        Document document = event.getDocument();
        FileViewProvider viewProvider = this.getCachedViewProvider(document);
        if (viewProvider == null) {
            return;
        }
        if (!this.isRelevant(viewProvider)) {
            return;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        List<PsiFile> files = viewProvider.getAllFiles();
        boolean commitNecessary = true;
        for (PsiFile file : files) {
            this.mySmartPointerManager.unfastenBelts(file, event.getOffset());
            TextBlock textBlock = TextBlock.get(file);
            if (textBlock.isLocked()) {
                commitNecessary = false;
                continue;
            }
            textBlock.documentChanged(event);
            assert (file instanceof PsiFileImpl || "mock.file".equals(file.getName()) && ApplicationManager.getApplication().isUnitTestMode()) : event + "; file=" + file + "; allFiles=" + files + "; viewProvider=" + viewProvider;
        }
        boolean bl = forceCommit = ApplicationManager.getApplication().hasWriteAction(ExternalChangeAction.class) && (SystemProperties.getBooleanProperty("idea.force.commit.on.external.change", false) || ApplicationManager.getApplication().isHeadlessEnvironment());
        if (event.isWholeTextReplaced() && document.getTextLength() > 100000) {
            document.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, Boolean.TRUE);
        }
        if (commitNecessary) {
            assert (!(document instanceof DocumentWindow));
            this.myUncommittedDocuments.add(document);
            if (forceCommit) {
                this.commitDocument(document);
            } else if (!((DocumentEx)document).isInBulkUpdate()) {
                this.myDocumentCommitProcessor.commitAsynchronously(this.myProject, document, event);
            }
        }
    }

    private boolean isRelevant(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiDocumentManagerBase", "isRelevant"));
        }
        VirtualFile virtualFile = viewProvider.getVirtualFile();
        return !virtualFile.getFileType().isBinary() && viewProvider.getManager() == this.myPsiManager && !this.myPsiManager.getProject().isDisposed();
    }

    public static boolean checkConsistency(PsiFile psiFile, Document document) {
        int i;
        if (psiFile.getVirtualFile() == null) {
            return true;
        }
        CharSequence editorText = document.getCharsSequence();
        int documentLength = document.getTextLength();
        if (psiFile.textMatches(editorText)) {
            LOG.assertTrue(psiFile.getTextLength() == documentLength);
            return true;
        }
        char[] fileText = psiFile.textToCharArray();
        String error = "File '" + psiFile.getName() + "' text mismatch after reparse. " + "File length=" + fileText.length + "; Doc length=" + documentLength + "\n";
        for (i = 0; i < documentLength; ++i) {
            if (i >= fileText.length) {
                error = error + "editorText.length > psiText.length i=" + i + "\n";
                break;
            }
            if (i >= editorText.length()) {
                error = error + "editorText.length > psiText.length i=" + i + "\n";
                break;
            }
            if (editorText.charAt(i) == fileText[i]) continue;
            error = error + "first unequal char i=" + i + "\n";
            break;
        }
        error = error + "*********************************************\n";
        error = error + "Editor Text tail:(" + (documentLength - i) + ")\n";
        error = error + "*********************************************\n";
        error = error + "Psi Text tail:(" + (fileText.length - i) + ")\n";
        error = error + "*********************************************\n";
        if (document instanceof DocumentWindow) {
            error = error + "doc: '" + document.getText() + "'\n";
            error = error + "psi: '" + psiFile.getText() + "'\n";
            error = error + "ast: '" + psiFile.getNode().getText() + "'\n";
            error = error + psiFile.getLanguage() + "\n";
            PsiLanguageInjectionHost context = InjectedLanguageManager.getInstance(psiFile.getProject()).getInjectionHost(psiFile);
            if (context != null) {
                error = error + "context: " + context + "; text: '" + context.getText() + "'\n";
                error = error + "context file: " + context.getContainingFile() + "\n";
            }
            error = error + "document window ranges: " + Arrays.asList(((DocumentWindow)document).getHostRanges()) + "\n";
        }
        LOG.error(error);
        return false;
    }

    public void clearUncommittedDocuments() {
        this.myUncommittedDocuments.clear();
        this.mySynchronizer.cleanupForNextTest();
    }

    public PsiToDocumentSynchronizer getSynchronizer() {
        return this.mySynchronizer;
    }

    private static class CompositeRunnable
    extends ArrayList<Runnable>
    implements Runnable {
        private CompositeRunnable() {
        }

        @Override
        public void run() {
            for (Runnable runnable2 : this) {
                runnable2.run();
            }
        }
    }
}

