/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.utils;

import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.utils.Nulls;

public abstract class NullableMemoizedFunction<K, V>
implements NullableFunction<K, V> {
    private final Map<K, Object> cache;

    public static <K, V> NullableFunction<K, V> create(final @NotNull Function<K, V> compute) {
        return new NullableMemoizedFunction<K, V>(){

            @Override
            @Nullable
            protected V compute(@NotNull K input) {
                return compute.fun(input);
            }
        };
    }

    public NullableMemoizedFunction(@NotNull Map<K, Object> map) {
        this.cache = map;
    }

    public NullableMemoizedFunction() {
        this(new HashMap());
    }

    @Override
    @Nullable
    public V fun(@NotNull K input) {
        Object value = this.cache.get(input);
        if (value != null) {
            return Nulls.unescape(value);
        }
        V typedValue = this.compute(input);
        Object oldValue = this.cache.put(input, Nulls.escape(typedValue));
        assert (oldValue == null) : "Race condition detected";
        return typedValue;
    }

    @Nullable
    protected abstract V compute(@NotNull K var1);
}

