/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.google.common.collect.Multimap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.FunctionDescriptorUtil;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetAnnotatedExpression;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetCallableReferenceExpression;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetEscapeStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetLabelQualifiedInstanceExpression;
import org.jetbrains.jet.lang.psi.JetLiteralStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetRootNamespaceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetSuperExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetUserType;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.JetModuleUtil;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.CallExpressionResolver;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValue;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValueFactory;
import org.jetbrains.jet.lang.resolve.calls.autocasts.Nullability;
import org.jetbrains.jet.lang.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.jet.lang.resolve.calls.context.ExpressionPosition;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.jet.lang.resolve.calls.context.ResolveMode;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.jet.lang.resolve.calls.util.CallMaker;
import org.jetbrains.jet.lang.resolve.calls.util.ExpressionAsFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.constants.CharValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstantResolver;
import org.jetbrains.jet.lang.resolve.constants.ErrorValue;
import org.jetbrains.jet.lang.resolve.constants.StringValue;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.jet.lang.types.CommonSupertypes;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.SubstitutionUtils;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.checker.TypeCheckingProcedure;
import org.jetbrains.jet.lang.types.expressions.CoercionStrategy;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.LabelResolver;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.utils.ThrowingList;

public class BasicExpressionTypingVisitor
extends ExpressionTypingVisitor {
    protected BasicExpressionTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        super(facade);
    }

    @Override
    public JetTypeInfo visitSimpleNameExpression(JetSimpleNameExpression expression, ExpressionTypingContext context) {
        CallExpressionResolver callExpressionResolver = context.expressionTypingServices.getCallExpressionResolver();
        JetTypeInfo typeInfo = callExpressionResolver.getSimpleNameExpressionTypeInfo(expression, ReceiverValue.NO_RECEIVER, null, context);
        JetType type = DataFlowUtils.checkType(typeInfo.getType(), expression, context);
        ExpressionTypingUtils.checkCapturingInClosure(expression, context.trace, context.scope);
        return JetTypeInfo.create(type, typeInfo.getDataFlowInfo());
    }

    @Override
    public JetTypeInfo visitParenthesizedExpression(JetParenthesizedExpression expression, ExpressionTypingContext context) {
        return this.visitParenthesizedExpression(expression, context, false);
    }

    public JetTypeInfo visitParenthesizedExpression(JetParenthesizedExpression expression, ExpressionTypingContext context, boolean isStatement) {
        JetExpression innerExpression = expression.getExpression();
        if (innerExpression == null) {
            return JetTypeInfo.create(null, context.dataFlowInfo);
        }
        JetTypeInfo typeInfo = this.facade.getTypeInfo(innerExpression, (ExpressionTypingContext)context.replaceScope(context.scope), isStatement);
        return DataFlowUtils.checkType(typeInfo.getType(), expression, context, typeInfo.getDataFlowInfo());
    }

    @Override
    public JetTypeInfo visitConstantExpression(JetConstantExpression expression, ExpressionTypingContext context) {
        CompileTimeConstant<?> value;
        ASTNode node = expression.getNode();
        IElementType elementType = node.getElementType();
        String text = node.getText();
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        CompileTimeConstantResolver compileTimeConstantResolver = context.getCompileTimeConstantResolver();
        if (elementType == JetNodeTypes.INTEGER_CONSTANT) {
            value = compileTimeConstantResolver.getIntegerValue(text, context.expectedType);
        } else if (elementType == JetNodeTypes.FLOAT_CONSTANT) {
            value = compileTimeConstantResolver.getFloatValue(text, context.expectedType);
        } else if (elementType == JetNodeTypes.BOOLEAN_CONSTANT) {
            value = compileTimeConstantResolver.getBooleanValue(text, context.expectedType);
        } else if (elementType == JetNodeTypes.CHARACTER_CONSTANT) {
            value = compileTimeConstantResolver.getCharValue(text, context.expectedType);
        } else if (elementType == JetNodeTypes.NULL) {
            value = compileTimeConstantResolver.getNullValue(context.expectedType);
        } else {
            throw new IllegalArgumentException("Unsupported constant: " + expression);
        }
        if (value instanceof ErrorValue) {
            ErrorValue errorValue = (ErrorValue)value;
            context.trace.report(Errors.ERROR_COMPILE_TIME_VALUE.on(node.getPsi(), errorValue.getMessage()));
            return JetTypeInfo.create(ExpressionTypingUtils.getDefaultType(elementType), context.dataFlowInfo);
        }
        context.trace.record(BindingContext.COMPILE_TIME_VALUE, expression, value);
        return DataFlowUtils.checkType(value.getType(builtIns), expression, context, context.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitBinaryWithTypeRHSExpression(JetBinaryExpressionWithTypeRHS expression, ExpressionTypingContext context) {
        JetExpression left = expression.getLeft();
        JetTypeReference right = expression.getRight();
        JetType result = null;
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        if (right != null) {
            ExpressionTypingContext contextWithNoExpectedType;
            JetTypeInfo typeInfo;
            TemporaryBindingTrace temporaryTraceWithExpectedType;
            ExpressionTypingContext contextWithTemporaryTrace;
            JetTypeInfo typeInfo2;
            JetType targetType = context.expressionTypingServices.getTypeResolver().resolveType(context.scope, right, context.trace, true);
            IElementType operationType = expression.getOperationReference().getReferencedNameElementType();
            boolean tryWithNoExpectedType = true;
            if ((ExpressionTypingUtils.isTypeFlexible(left) || operationType == JetTokens.COLON) && (typeInfo2 = this.facade.getTypeInfo(left, contextWithTemporaryTrace = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceBindingTrace(temporaryTraceWithExpectedType = TemporaryBindingTrace.create(context.trace, "trace for resolve RHSExpression", expression))).replaceExpectedType(targetType))).getType() != null && BasicExpressionTypingVisitor.checkBinaryWithTypeRHS(expression, contextWithTemporaryTrace, targetType, typeInfo2.getType())) {
                temporaryTraceWithExpectedType.commit();
                dataFlowInfo = typeInfo2.getDataFlowInfo();
                tryWithNoExpectedType = false;
            }
            if (tryWithNoExpectedType && (typeInfo = this.facade.getTypeInfo(left, contextWithNoExpectedType = (ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE))).getType() != null) {
                BasicExpressionTypingVisitor.checkBinaryWithTypeRHS(expression, contextWithNoExpectedType, targetType, typeInfo.getType());
                dataFlowInfo = typeInfo.getDataFlowInfo();
                if (operationType == JetTokens.AS_KEYWORD) {
                    DataFlowValue value = DataFlowValueFactory.INSTANCE.createDataFlowValue(left, typeInfo.getType(), context.trace.getBindingContext());
                    dataFlowInfo = dataFlowInfo.establishSubtyping(value, targetType);
                }
            }
            result = operationType == JetTokens.AS_SAFE ? TypeUtils.makeNullable(targetType) : targetType;
        } else {
            dataFlowInfo = this.facade.getTypeInfo(left, (ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).getDataFlowInfo();
        }
        return DataFlowUtils.checkType(result, expression, context, dataFlowInfo);
    }

    private static boolean checkBinaryWithTypeRHS(JetBinaryExpressionWithTypeRHS expression, ExpressionTypingContext context, @NotNull JetType targetType, JetType actualType) {
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == JetTokens.COLON) {
            if (targetType != TypeUtils.NO_EXPECTED_TYPE && !JetTypeChecker.INSTANCE.isSubtypeOf(actualType, targetType)) {
                context.trace.report(Errors.TYPE_MISMATCH.on(expression.getLeft(), targetType, actualType));
                return false;
            }
            return true;
        }
        if (operationType == JetTokens.AS_KEYWORD || operationType == JetTokens.AS_SAFE) {
            BasicExpressionTypingVisitor.checkForCastImpossibility(expression, actualType, targetType, context);
            return true;
        }
        context.trace.report(Errors.UNSUPPORTED.on(operationSign, "binary operation with type RHS"));
        return false;
    }

    private static void checkForCastImpossibility(JetBinaryExpressionWithTypeRHS expression, JetType actualType, JetType targetType, ExpressionTypingContext context) {
        if (actualType == null || targetType == TypeUtils.NO_EXPECTED_TYPE) {
            return;
        }
        JetTypeChecker typeChecker = JetTypeChecker.INSTANCE;
        if (!typeChecker.isSubtypeOf(targetType, actualType)) {
            if (typeChecker.isSubtypeOf(actualType, targetType)) {
                context.trace.report(Errors.USELESS_CAST_STATIC_ASSERT_IS_FINE.on(expression.getOperationReference()));
            } else {
                context.trace.report(Errors.CAST_NEVER_SUCCEEDS.on(expression.getOperationReference()));
            }
        } else if (typeChecker.isSubtypeOf(actualType, targetType)) {
            context.trace.report(Errors.USELESS_CAST.on(expression.getOperationReference()));
        } else if (BasicExpressionTypingVisitor.isCastErased(actualType, targetType, typeChecker)) {
            context.trace.report(Errors.UNCHECKED_CAST.on(expression, actualType, targetType));
        }
    }

    public static boolean isCastErased(@NotNull JetType supertype, @NotNull JetType subtype, @NotNull JetTypeChecker typeChecker) {
        if (!(subtype.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor)) {
            return false;
        }
        if (ErrorUtils.isErrorType(supertype) || ErrorUtils.isErrorType(subtype)) {
            return false;
        }
        return BasicExpressionTypingVisitor.hasDowncastsInTypeArguments(supertype, subtype, typeChecker) || BasicExpressionTypingVisitor.hasErasedTypeArguments(supertype, subtype);
    }

    private static boolean hasDowncastsInTypeArguments(@NotNull JetType supertype, @NotNull JetType subtype, @NotNull JetTypeChecker typeChecker) {
        List<TypeParameterDescriptor> superParameters = supertype.getConstructor().getParameters();
        Multimap<TypeConstructor, TypeProjection> subtypeSubstitutionMap = SubstitutionUtils.buildDeepSubstitutionMultimap(subtype);
        for (int i = 0; i < superParameters.size(); ++i) {
            TypeProjection superArgument = supertype.getArguments().get(i);
            TypeParameterDescriptor parameter = superParameters.get(i);
            if (parameter.isReified()) continue;
            Collection<TypeProjection> substituted = subtypeSubstitutionMap.get(parameter.getTypeConstructor());
            for (TypeProjection substitutedArgument : substituted) {
                JetType superOut = TypeCheckingProcedure.getOutType(parameter, superArgument);
                JetType superIn = TypeCheckingProcedure.getInType(parameter, superArgument);
                JetType subOut = TypeCheckingProcedure.getOutType(parameter, substitutedArgument);
                JetType subIn = TypeCheckingProcedure.getInType(parameter, substitutedArgument);
                if (typeChecker.isSubtypeOf(superOut, subOut) && typeChecker.isSubtypeOf(subIn, superIn)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasErasedTypeArguments(@NotNull JetType supertype, @NotNull JetType subtype) {
        JetType subtypeCleared = TypeUtils.makeUnsubstitutedType((ClassDescriptor)subtype.getConstructor().getDeclarationDescriptor(), null);
        Multimap<TypeConstructor, TypeProjection> clearTypeSubstitutionMap = SubstitutionUtils.buildDeepSubstitutionMultimap(subtypeCleared);
        HashSet<JetType> clearSubstituted = new HashSet<JetType>();
        List<TypeParameterDescriptor> superParameters = supertype.getConstructor().getParameters();
        for (TypeParameterDescriptor superParameter : superParameters) {
            Collection<TypeProjection> substituted = clearTypeSubstitutionMap.get(superParameter.getTypeConstructor());
            for (TypeProjection substitutedProjection : substituted) {
                clearSubstituted.add(substitutedProjection.getType());
            }
        }
        List<TypeParameterDescriptor> subParameters = subtype.getConstructor().getParameters();
        for (int i = 0; i < subParameters.size(); ++i) {
            TypeParameterDescriptor parameter = subParameters.get(i);
            TypeProjection argument = subtype.getArguments().get(i);
            if (parameter.isReified() || argument.equals(SubstitutionUtils.makeStarProjection(parameter)) || clearSubstituted.contains(parameter.getDefaultType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public JetTypeInfo visitThisExpression(JetThisExpression expression, ExpressionTypingContext context) {
        JetType result = null;
        LabelResolver.LabeledReceiverResolutionResult resolutionResult = BasicExpressionTypingVisitor.resolveToReceiver(expression, context, false);
        switch (resolutionResult.getCode()) {
            case LABEL_RESOLUTION_ERROR: {
                break;
            }
            case NO_THIS: {
                context.trace.report(Errors.NO_THIS.on(expression));
                break;
            }
            case SUCCESS: {
                result = resolutionResult.getReceiverParameterDescriptor().getType();
                context.trace.record(BindingContext.EXPRESSION_TYPE, expression.getInstanceReference(), result);
            }
        }
        return DataFlowUtils.checkType(result, expression, context, context.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitSuperExpression(JetSuperExpression expression, ExpressionTypingContext context) {
        LabelResolver.LabeledReceiverResolutionResult resolutionResult = BasicExpressionTypingVisitor.resolveToReceiver(expression, context, true);
        if (context.expressionPosition == ExpressionPosition.FREE) {
            context.trace.report(Errors.SUPER_IS_NOT_AN_EXPRESSION.on(expression, expression.getText()));
            return BasicExpressionTypingVisitor.errorInSuper(expression, context);
        }
        switch (resolutionResult.getCode()) {
            case LABEL_RESOLUTION_ERROR: {
                return BasicExpressionTypingVisitor.errorInSuper(expression, context);
            }
            case NO_THIS: {
                context.trace.report(Errors.SUPER_NOT_AVAILABLE.on(expression));
                return BasicExpressionTypingVisitor.errorInSuper(expression, context);
            }
            case SUCCESS: {
                JetType result = BasicExpressionTypingVisitor.checkPossiblyQualifiedSuper(expression, context, resolutionResult.getReceiverParameterDescriptor());
                if (result != null) {
                    context.trace.record(BindingContext.EXPRESSION_TYPE, expression.getInstanceReference(), result);
                }
                return DataFlowUtils.checkType(result, expression, context, context.dataFlowInfo);
            }
        }
        throw new IllegalStateException("Unknown code: " + (Object)((Object)resolutionResult.getCode()));
    }

    private static JetTypeInfo errorInSuper(JetSuperExpression expression, ExpressionTypingContext context) {
        JetTypeReference superTypeQualifier = expression.getSuperTypeQualifier();
        if (superTypeQualifier != null) {
            context.expressionTypingServices.getTypeResolver().resolveType(context.scope, superTypeQualifier, context.trace, true);
        }
        return JetTypeInfo.create(null, context.dataFlowInfo);
    }

    private static JetType checkPossiblyQualifiedSuper(JetSuperExpression expression, ExpressionTypingContext context, ReceiverParameterDescriptor thisReceiver) {
        JetTypeReference superTypeQualifier;
        JetType thisType;
        JetType result;
        block17: {
            TypeSubstitutor substitutor;
            Collection<JetType> supertypes;
            block14: {
                boolean validType;
                JetTypeArgumentList redundantTypeArguments;
                JetType supertype;
                ClassifierDescriptor classifierCandidate;
                block16: {
                    block15: {
                        result = null;
                        thisType = thisReceiver.getType();
                        supertypes = thisType.getConstructor().getSupertypes();
                        substitutor = TypeSubstitutor.create(thisType);
                        superTypeQualifier = expression.getSuperTypeQualifier();
                        if (superTypeQualifier == null) break block14;
                        JetTypeElement typeElement = superTypeQualifier.getTypeElement();
                        classifierCandidate = null;
                        supertype = null;
                        redundantTypeArguments = null;
                        if (typeElement instanceof JetUserType) {
                            JetUserType userType = (JetUserType)typeElement;
                            if (userType.getTypeArguments().isEmpty()) {
                                classifierCandidate = context.expressionTypingServices.getTypeResolver().resolveClass(context.scope, userType, context.trace);
                            } else {
                                supertype = context.expressionTypingServices.getTypeResolver().resolveType(context.scope, superTypeQualifier, context.trace, true);
                                redundantTypeArguments = userType.getTypeArgumentList();
                            }
                        } else {
                            supertype = context.expressionTypingServices.getTypeResolver().resolveType(context.scope, superTypeQualifier, context.trace, true);
                        }
                        if (supertype == null) break block15;
                        if (!supertypes.contains(supertype)) break block16;
                        result = supertype;
                        break block16;
                    }
                    if (classifierCandidate instanceof ClassDescriptor) {
                        ClassDescriptor superclass = (ClassDescriptor)classifierCandidate;
                        for (JetType declaredSupertype : supertypes) {
                            if (!declaredSupertype.getConstructor().equals(superclass.getTypeConstructor())) continue;
                            result = substitutor.safeSubstitute(declaredSupertype, Variance.INVARIANT);
                            break;
                        }
                    }
                }
                boolean validClassifier = classifierCandidate != null && !ErrorUtils.isError(classifierCandidate);
                boolean bl = validType = supertype != null && !ErrorUtils.isErrorType(supertype);
                if (result == null && (validClassifier || validType)) {
                    context.trace.report(Errors.NOT_A_SUPERTYPE.on(superTypeQualifier));
                } else if (redundantTypeArguments != null) {
                    context.trace.report(Errors.TYPE_ARGUMENTS_REDUNDANT_IN_SUPER_QUALIFIER.on(redundantTypeArguments));
                }
                break block17;
            }
            if (supertypes.size() > 1) {
                context.trace.report(Errors.AMBIGUOUS_SUPER.on(expression));
            } else {
                JetType type = supertypes.isEmpty() ? KotlinBuiltIns.getInstance().getAnyType() : supertypes.iterator().next();
                result = substitutor.substitute(type, Variance.INVARIANT);
            }
        }
        if (result != null) {
            if (DescriptorUtils.isKindOf(thisType, ClassKind.TRAIT) && DescriptorUtils.isKindOf(result, ClassKind.CLASS)) {
                context.trace.report(Errors.SUPERCLASS_NOT_ACCESSIBLE_FROM_TRAIT.on(expression));
            }
            context.trace.record(BindingContext.EXPRESSION_TYPE, expression.getInstanceReference(), result);
            context.trace.record(BindingContext.REFERENCE_TARGET, expression.getInstanceReference(), result.getConstructor().getDeclarationDescriptor());
            if (superTypeQualifier != null) {
                context.trace.record(BindingContext.TYPE_RESOLUTION_SCOPE, superTypeQualifier, context.scope);
            }
        }
        return result;
    }

    @NotNull
    private static LabelResolver.LabeledReceiverResolutionResult resolveToReceiver(JetLabelQualifiedInstanceExpression expression, ExpressionTypingContext context, boolean onlyClassReceivers) {
        String labelName = expression.getLabelName();
        if (labelName != null) {
            LabelResolver.LabeledReceiverResolutionResult resolutionResult = context.labelResolver.resolveThisLabel(expression.getInstanceReference(), expression.getTargetLabel(), context, new LabelName(labelName));
            if (onlyClassReceivers && resolutionResult.success() && !BasicExpressionTypingVisitor.isDeclaredInClass(resolutionResult.getReceiverParameterDescriptor())) {
                return LabelResolver.LabeledReceiverResolutionResult.labelResolutionSuccess(ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER);
            }
            return resolutionResult;
        }
        ReceiverParameterDescriptor result = ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER;
        List<ReceiverParameterDescriptor> receivers = context.scope.getImplicitReceiversHierarchy();
        if (onlyClassReceivers) {
            for (ReceiverParameterDescriptor receiver : receivers) {
                if (!BasicExpressionTypingVisitor.isDeclaredInClass(receiver)) continue;
                result = receiver;
                break;
            }
        } else if (!receivers.isEmpty()) {
            result = receivers.get(0);
        }
        if (result != ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER) {
            context.trace.record(BindingContext.REFERENCE_TARGET, expression.getInstanceReference(), result.getContainingDeclaration());
        }
        return LabelResolver.LabeledReceiverResolutionResult.labelResolutionSuccess(result);
    }

    private static boolean isDeclaredInClass(ReceiverParameterDescriptor receiver) {
        return receiver.getContainingDeclaration() instanceof ClassDescriptor;
    }

    @Override
    public JetTypeInfo visitBlockExpression(JetBlockExpression expression, ExpressionTypingContext context) {
        return BasicExpressionTypingVisitor.visitBlockExpression(expression, context, false);
    }

    public static JetTypeInfo visitBlockExpression(JetBlockExpression expression, ExpressionTypingContext context, boolean isStatement) {
        return context.expressionTypingServices.getBlockReturnedType(context.scope, expression, isStatement ? CoercionStrategy.COERCION_TO_UNIT : CoercionStrategy.NO_COERCION, context, context.trace);
    }

    @Override
    public JetTypeInfo visitCallableReferenceExpression(JetCallableReferenceExpression expression, ExpressionTypingContext context) {
        JetTypeReference typeReference = expression.getTypeReference();
        JetType receiverType = typeReference == null ? null : context.expressionTypingServices.getTypeResolver().resolveType(context.scope, typeReference, context.trace, false);
        JetSimpleNameExpression callableReference = expression.getCallableReference();
        if (callableReference.getReferencedName().isEmpty()) {
            context.trace.report(Errors.UNRESOLVED_REFERENCE.on(callableReference, callableReference));
            JetType errorType = ErrorUtils.createErrorType("Empty callable reference");
            return DataFlowUtils.checkType(errorType, expression, context, context.dataFlowInfo);
        }
        JetType result = BasicExpressionTypingVisitor.getCallableReferenceType(expression, receiverType, context);
        return DataFlowUtils.checkType(result, expression, context, context.dataFlowInfo);
    }

    @Nullable
    private static JetType getCallableReferenceType(@NotNull JetCallableReferenceExpression expression, @Nullable JetType lhsType, @NotNull ExpressionTypingContext context) {
        JetSimpleNameExpression reference = expression.getCallableReference();
        boolean[] result = new boolean[1];
        FunctionDescriptor descriptor = BasicExpressionTypingVisitor.resolveCallableReferenceTarget(lhsType, context, expression, result);
        if (!result[0]) {
            context.trace.report(Errors.UNRESOLVED_REFERENCE.on(reference, reference));
        }
        if (descriptor == null) {
            return null;
        }
        ReceiverParameterDescriptor receiverParameter = descriptor.getReceiverParameter();
        ReceiverParameterDescriptor expectedThisObject = descriptor.getExpectedThisObject();
        if (receiverParameter != null && expectedThisObject != null) {
            context.trace.report(Errors.EXTENSION_IN_CLASS_REFERENCE_NOT_ALLOWED.on(reference, descriptor));
            return null;
        }
        JetType receiverType = null;
        if (receiverParameter != null) {
            receiverType = receiverParameter.getType();
        } else if (expectedThisObject != null) {
            receiverType = expectedThisObject.getType();
        }
        JetType type = KotlinBuiltIns.getInstance().getKFunctionType(Collections.<AnnotationDescriptor>emptyList(), receiverType, DescriptorUtils.getValueParametersTypes(descriptor.getValueParameters()), descriptor.getReturnType(), receiverParameter != null);
        ExpressionAsFunctionDescriptor functionDescriptor = new ExpressionAsFunctionDescriptor(context.scope.getContainingDeclaration(), Name.special("<callable-reference>"));
        FunctionDescriptorUtil.initializeFromFunctionType(functionDescriptor, type, null, Modality.FINAL, Visibilities.PUBLIC);
        context.trace.record(BindingContext.CALLABLE_REFERENCE, expression, functionDescriptor);
        return type;
    }

    @Nullable
    private static FunctionDescriptor resolveCallableReferenceTarget(@Nullable JetType lhsType, @NotNull ExpressionTypingContext context, @NotNull JetCallableReferenceExpression expression, @NotNull boolean[] result) {
        JetSimpleNameExpression reference = expression.getCallableReference();
        if (lhsType == null) {
            return BasicExpressionTypingVisitor.resolveCallableNotCheckingArguments(reference, ReceiverValue.NO_RECEIVER, context, result);
        }
        ClassifierDescriptor classifier = lhsType.getConstructor().getDeclarationDescriptor();
        if (!(classifier instanceof ClassDescriptor)) {
            context.trace.report(Errors.CALLABLE_REFERENCE_LHS_NOT_A_CLASS.on(expression));
            return null;
        }
        TransientReceiver receiver = new TransientReceiver(lhsType);
        TemporaryBindingTrace traceWithReceiver = TemporaryBindingTrace.create(context.trace, "trace to resolve callable reference with receiver", reference);
        FunctionDescriptor descriptor = BasicExpressionTypingVisitor.resolveCallableNotCheckingArguments(reference, receiver, (ExpressionTypingContext)context.replaceBindingTrace(traceWithReceiver), result);
        if (result[0]) {
            traceWithReceiver.commit();
            return descriptor;
        }
        JetScope staticScope = DescriptorUtils.getStaticNestedClassesScope((ClassDescriptor)classifier);
        TemporaryBindingTrace traceForStatic = TemporaryBindingTrace.create(context.trace, "trace to resolve callable reference in static scope", reference);
        FunctionDescriptor possibleStaticNestedClassConstructor = BasicExpressionTypingVisitor.resolveCallableNotCheckingArguments(reference, ReceiverValue.NO_RECEIVER, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceBindingTrace(traceForStatic)).replaceScope(staticScope), result);
        if (result[0]) {
            traceForStatic.commit();
            return possibleStaticNestedClassConstructor;
        }
        return null;
    }

    @Nullable
    private static FunctionDescriptor resolveCallableNotCheckingArguments(@NotNull JetSimpleNameExpression reference, @NotNull ReceiverValue receiver, @NotNull ExpressionTypingContext context, @NotNull boolean[] result) {
        Call call = CallMaker.makeCall(reference, receiver, null, reference, ThrowingList.instance());
        TemporaryBindingTrace trace = TemporaryBindingTrace.create(context.trace, "trace to resolve as function", reference);
        ExpressionTypingContext contextForResolve = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceBindingTrace(trace)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        ResolvedCallWithTrace<FunctionDescriptor> function = contextForResolve.expressionTypingServices.getCallExpressionResolver().getResolvedCallForFunction(call, reference, contextForResolve, ResolveMode.TOP_LEVEL_CALL, CheckValueArgumentsMode.DISABLED, ResolutionResultsCache.create(), result);
        if (!result[0]) {
            return null;
        }
        if (function instanceof VariableAsFunctionResolvedCall) {
            context.trace.report(Errors.UNSUPPORTED.on(reference, "References to variables aren't supported yet"));
            context.trace.report(Errors.UNRESOLVED_REFERENCE.on(reference, reference));
            return null;
        }
        trace.commit();
        return function != null ? (FunctionDescriptor)function.getResultingDescriptor() : null;
    }

    @Override
    public JetTypeInfo visitQualifiedExpression(JetQualifiedExpression expression, ExpressionTypingContext context) {
        CallExpressionResolver callExpressionResolver = context.expressionTypingServices.getCallExpressionResolver();
        return callExpressionResolver.getQualifiedExpressionTypeInfo(expression, context, ResolveMode.TOP_LEVEL_CALL, ResolutionResultsCache.create());
    }

    @Override
    public JetTypeInfo visitCallExpression(JetCallExpression expression, ExpressionTypingContext context) {
        CallExpressionResolver callExpressionResolver = context.expressionTypingServices.getCallExpressionResolver();
        return callExpressionResolver.getCallExpressionTypeInfo(expression, ReceiverValue.NO_RECEIVER, null, context, ResolveMode.TOP_LEVEL_CALL, ResolutionResultsCache.create());
    }

    @Override
    public JetTypeInfo visitUnaryExpression(JetUnaryExpression expression, ExpressionTypingContext context) {
        return this.visitUnaryExpression(expression, context, false);
    }

    public JetTypeInfo visitUnaryExpression(JetUnaryExpression expression, ExpressionTypingContext context, boolean isStatement) {
        JetType result;
        ExpressionReceiver receiver;
        OverloadResolutionResults<FunctionDescriptor> resolutionResults;
        JetExpression baseExpression = expression.getBaseExpression();
        if (baseExpression == null) {
            return JetTypeInfo.create(null, context.dataFlowInfo);
        }
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (JetTokens.LABELS.contains(operationType)) {
            return this.visitLabeledExpression(expression, context, isStatement);
        }
        if (operationType == JetTokens.EXCLEXCL) {
            return this.visitExclExclExpression(expression, context);
        }
        JetTypeInfo typeInfo = this.facade.getTypeInfo(baseExpression, (ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
        JetType type = typeInfo.getType();
        if (type == null) {
            return typeInfo;
        }
        DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
        Name name = OperatorConventions.UNARY_OPERATION_NAMES.get(operationType);
        if (name == null) {
            context.trace.report(Errors.UNSUPPORTED.on(operationSign, "visitUnaryExpression"));
            return JetTypeInfo.create(null, dataFlowInfo);
        }
        if ((operationType == JetTokens.PLUSPLUS || operationType == JetTokens.MINUSMINUS) && baseExpression instanceof JetArrayAccessExpression) {
            JetExpression stubExpression = ExpressionTypingUtils.createFakeExpressionOfType(baseExpression.getProject(), context.trace, "$e", type);
            this.resolveArrayAccessSetMethod((JetArrayAccessExpression)baseExpression, stubExpression, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceBindingTrace(TemporaryBindingTrace.create(context.trace, "trace to resolve array access set method for unary expression", expression)), context.trace);
        }
        if (!(resolutionResults = context.resolveCallWithGivenName(CallMaker.makeCall((ReceiverValue)(receiver = new ExpressionReceiver(baseExpression, type)), expression), expression.getOperationReference(), name)).isSuccess()) {
            return JetTypeInfo.create(null, dataFlowInfo);
        }
        JetType returnType = resolutionResults.getResultingDescriptor().getReturnType();
        if (operationType == JetTokens.PLUSPLUS || operationType == JetTokens.MINUSMINUS) {
            assert (returnType != null) : "returnType is null for " + resolutionResults.getResultingDescriptor();
            if (JetTypeChecker.INSTANCE.isSubtypeOf(returnType, KotlinBuiltIns.getInstance().getUnitType())) {
                result = ErrorUtils.createErrorType(KotlinBuiltIns.getInstance().getUnit().getName().asString());
                context.trace.report(Errors.INC_DEC_SHOULD_NOT_RETURN_UNIT.on(operationSign));
            } else {
                JetType receiverType = receiver.getType();
                if (!JetTypeChecker.INSTANCE.isSubtypeOf(returnType, receiverType)) {
                    context.trace.report(Errors.RESULT_TYPE_MISMATCH.on(operationSign, name.asString(), receiverType, returnType));
                } else {
                    context.trace.record(BindingContext.VARIABLE_REASSIGNMENT, expression);
                    BasicExpressionTypingVisitor.checkLValue(context.trace, baseExpression);
                }
                result = receiverType;
            }
        } else {
            result = returnType;
        }
        return DataFlowUtils.checkType(result, expression, context, dataFlowInfo);
    }

    private JetTypeInfo visitExclExclExpression(@NotNull JetUnaryExpression expression, @NotNull ExpressionTypingContext context) {
        JetExpression baseExpression = expression.getBaseExpression();
        assert (baseExpression != null);
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        assert (operationSign.getReferencedNameElementType() == JetTokens.EXCLEXCL);
        JetType expectedType = context.expectedType != TypeUtils.NO_EXPECTED_TYPE ? TypeUtils.makeNullable(context.expectedType) : TypeUtils.NO_EXPECTED_TYPE;
        JetTypeInfo typeInfo = this.facade.getTypeInfo(baseExpression, (ExpressionTypingContext)context.replaceExpectedType(expectedType));
        JetType type = typeInfo.getType();
        if (type == null) {
            return typeInfo;
        }
        DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
        if (BasicExpressionTypingVisitor.isKnownToBeNotNull(baseExpression, context) && !ErrorUtils.isErrorType(type)) {
            context.trace.report(Errors.UNNECESSARY_NOT_NULL_ASSERTION.on(operationSign, type));
        } else {
            DataFlowValue value = DataFlowValueFactory.INSTANCE.createDataFlowValue(baseExpression, type, context.trace.getBindingContext());
            dataFlowInfo = dataFlowInfo.disequate(value, DataFlowValue.NULL);
        }
        return JetTypeInfo.create(TypeUtils.makeNotNullable(type), dataFlowInfo);
    }

    private JetTypeInfo visitLabeledExpression(@NotNull JetUnaryExpression expression, @NotNull ExpressionTypingContext context, boolean isStatement) {
        JetExpression baseExpression = expression.getBaseExpression();
        assert (baseExpression != null);
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        assert (JetTokens.LABELS.contains(operationSign.getReferencedNameElementType()));
        String referencedName = operationSign.getReferencedName();
        context.labelResolver.enterLabeledElement(new LabelName(referencedName.substring(1)), baseExpression);
        JetTypeInfo typeInfo = this.facade.getTypeInfo(baseExpression, context, isStatement);
        context.labelResolver.exitLabeledElement(baseExpression);
        return DataFlowUtils.checkType(typeInfo.getType(), expression, context, typeInfo.getDataFlowInfo());
    }

    private static boolean isKnownToBeNotNull(JetExpression expression, ExpressionTypingContext context) {
        JetType type = context.trace.get(BindingContext.EXPRESSION_TYPE, expression);
        assert (type != null) : "This method is only supposed to be called when the type is not null";
        return BasicExpressionTypingVisitor.isKnownToBeNotNull(expression, type, context);
    }

    private static boolean isKnownToBeNotNull(JetExpression expression, JetType jetType, ExpressionTypingContext context) {
        DataFlowValue dataFlowValue = DataFlowValueFactory.INSTANCE.createDataFlowValue(expression, jetType, context.trace.getBindingContext());
        return !context.dataFlowInfo.getNullability(dataFlowValue).canBeNull();
    }

    public static void checkLValue(@NotNull BindingTrace trace, @NotNull JetExpression expression) {
        BasicExpressionTypingVisitor.checkLValue(trace, expression, false);
    }

    private static void checkLValue(@NotNull BindingTrace trace, @NotNull JetExpression expressionWithParenthesis, boolean canBeThis) {
        JetExpression expression = JetPsiUtil.deparenthesizeWithNoTypeResolution(expressionWithParenthesis);
        if (expression instanceof JetArrayAccessExpression) {
            JetExpression arrayExpression = ((JetArrayAccessExpression)expression).getArrayExpression();
            if (arrayExpression != null) {
                BasicExpressionTypingVisitor.checkLValue(trace, arrayExpression, true);
            }
            return;
        }
        if (canBeThis && expression instanceof JetThisExpression) {
            return;
        }
        VariableDescriptor variable = BindingContextUtils.extractVariableDescriptorIfAny(trace.getBindingContext(), expression, true);
        if (variable == null) {
            trace.report(Errors.VARIABLE_EXPECTED.on(expression != null ? expression : expressionWithParenthesis));
        }
    }

    @Override
    public JetTypeInfo visitBinaryExpression(JetBinaryExpression expression, ExpressionTypingContext contextWithExpectedType) {
        ExpressionTypingContext context = (ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        JetExpression left = expression.getLeft();
        JetExpression right = expression.getRight();
        IElementType operationType = operationSign.getReferencedNameElementType();
        JetType result = null;
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        if (operationType == JetTokens.IDENTIFIER) {
            Name referencedName = operationSign.getReferencedNameAsName();
            JetTypeInfo typeInfo = this.getTypeInfoForBinaryCall(context.scope, referencedName, context, expression);
            result = typeInfo.getType();
            dataFlowInfo = typeInfo.getDataFlowInfo();
        } else if (OperatorConventions.BINARY_OPERATION_NAMES.containsKey(operationType)) {
            JetTypeInfo typeInfo = this.getTypeInfoForBinaryCall(context.scope, OperatorConventions.BINARY_OPERATION_NAMES.get(operationType), context, expression);
            result = typeInfo.getType();
            dataFlowInfo = typeInfo.getDataFlowInfo();
        } else if (operationType == JetTokens.EQ) {
            result = this.visitAssignment(expression, contextWithExpectedType);
        } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey(operationType)) {
            result = this.visitAssignmentOperation(expression, contextWithExpectedType);
        } else if (OperatorConventions.COMPARISON_OPERATIONS.contains(operationType)) {
            JetTypeInfo typeInfo = this.getTypeInfoForBinaryCall(context.scope, OperatorConventions.COMPARE_TO, context, expression);
            dataFlowInfo = typeInfo.getDataFlowInfo();
            JetType compareToReturnType = typeInfo.getType();
            if (compareToReturnType != null && !ErrorUtils.isErrorType(compareToReturnType)) {
                KotlinBuiltIns builtIns;
                TypeConstructor intTypeConstructor;
                TypeConstructor constructor = compareToReturnType.getConstructor();
                if (constructor.equals(intTypeConstructor = (builtIns = KotlinBuiltIns.getInstance()).getInt().getTypeConstructor())) {
                    result = builtIns.getBooleanType();
                } else {
                    context.trace.report(Errors.COMPARE_TO_TYPE_MISMATCH.on(operationSign, compareToReturnType));
                }
            }
        } else {
            JetType booleanType = KotlinBuiltIns.getInstance().getBooleanType();
            if (OperatorConventions.EQUALS_OPERATIONS.contains(operationType)) {
                if (right != null && left != null) {
                    ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, left, context);
                    JetTypeInfo leftTypeInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, context, this.facade);
                    dataFlowInfo = leftTypeInfo.getDataFlowInfo();
                    ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo);
                    OverloadResolutionResults<FunctionDescriptor> resolutionResults = ExpressionTypingUtils.resolveFakeCall(contextWithDataFlow, receiver, OperatorConventions.EQUALS, KotlinBuiltIns.getInstance().getNullableAnyType());
                    dataFlowInfo = this.facade.getTypeInfo(right, contextWithDataFlow).getDataFlowInfo();
                    if (resolutionResults.isSuccess()) {
                        FunctionDescriptor equals = resolutionResults.getResultingCall().getResultingDescriptor();
                        context.trace.record(BindingContext.REFERENCE_TARGET, operationSign, equals);
                        context.trace.record(BindingContext.RESOLVED_CALL, operationSign, resolutionResults.getResultingCall());
                        if (ExpressionTypingUtils.ensureBooleanResult(operationSign, OperatorConventions.EQUALS, equals.getReturnType(), context)) {
                            this.ensureNonemptyIntersectionOfOperandTypes(expression, context);
                        }
                    } else if (resolutionResults.isAmbiguity()) {
                        context.trace.report(Errors.OVERLOAD_RESOLUTION_AMBIGUITY.on(operationSign, resolutionResults.getResultingCalls()));
                    } else {
                        context.trace.report(Errors.EQUALS_MISSING.on(operationSign));
                    }
                }
                result = booleanType;
            } else if (operationType == JetTokens.EQEQEQ || operationType == JetTokens.EXCLEQEQEQ) {
                this.ensureNonemptyIntersectionOfOperandTypes(expression, context);
                result = booleanType;
            } else if (OperatorConventions.IN_OPERATIONS.contains(operationType)) {
                if (right == null) {
                    return JetTypeInfo.create(null, dataFlowInfo);
                }
                JetTypeInfo typeInfo = this.checkInExpression(expression, expression.getOperationReference(), left, right, context);
                dataFlowInfo = typeInfo.getDataFlowInfo();
                result = typeInfo.getType();
            } else if (OperatorConventions.BOOLEAN_OPERATIONS.containsKey(operationType)) {
                JetType rightType;
                JetTypeInfo leftTypeInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, context, this.facade);
                JetType leftType = leftTypeInfo.getType();
                dataFlowInfo = leftTypeInfo.getDataFlowInfo();
                WritableScopeImpl leftScope = ExpressionTypingUtils.newWritableScopeImpl(context, "Left scope of && or ||");
                DataFlowInfo flowInfoLeft = DataFlowUtils.extractDataFlowInfoFromCondition(left, operationType == JetTokens.ANDAND, context).and(dataFlowInfo);
                WritableScopeImpl rightScope = operationType == JetTokens.ANDAND ? leftScope : ExpressionTypingUtils.newWritableScopeImpl(context, "Right scope of && or ||");
                JetType jetType = rightType = right == null ? null : this.facade.getTypeInfo(right, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceDataFlowInfo(flowInfoLeft)).replaceScope(rightScope)).getType();
                if (left != null && leftType != null && !ExpressionTypingUtils.isBoolean(leftType)) {
                    context.trace.report(Errors.TYPE_MISMATCH.on(left, booleanType, leftType));
                }
                if (rightType != null && !ExpressionTypingUtils.isBoolean(rightType)) {
                    context.trace.report(Errors.TYPE_MISMATCH.on(right, booleanType, rightType));
                }
                result = booleanType;
            } else if (operationType == JetTokens.ELVIS) {
                JetTypeInfo leftTypeInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, context, this.facade);
                JetType leftType = leftTypeInfo.getType();
                dataFlowInfo = leftTypeInfo.getDataFlowInfo();
                if (left != null && leftType != null) {
                    JetType rightType;
                    if (BasicExpressionTypingVisitor.isKnownToBeNotNull(left, leftType, context)) {
                        context.trace.report(Errors.USELESS_ELVIS.on(left, leftType));
                    }
                    ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceDataFlowInfo(dataFlowInfo)).replaceScope(context.scope);
                    JetType jetType = rightType = right == null ? null : this.facade.getTypeInfo(right, newContext).getType();
                    if (rightType != null) {
                        DataFlowUtils.checkType(TypeUtils.makeNullableAsSpecified(leftType, rightType.isNullable()), left, contextWithExpectedType);
                        return JetTypeInfo.create(TypeUtils.makeNullableAsSpecified(CommonSupertypes.commonSupertype(Arrays.asList(leftType, rightType)), rightType.isNullable()), dataFlowInfo);
                    }
                }
            } else {
                context.trace.report(Errors.UNSUPPORTED.on(operationSign, "Unknown operation"));
            }
        }
        return DataFlowUtils.checkType(result, expression, contextWithExpectedType, dataFlowInfo);
    }

    @NotNull
    public JetTypeInfo checkInExpression(JetElement callElement, @NotNull JetSimpleNameExpression operationSign, @Nullable JetExpression left, @NotNull JetExpression right, ExpressionTypingContext context) {
        ExpressionTypingContext contextWithNoExpectedType = (ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        DataFlowInfo dataFlowInfo = this.facade.getTypeInfo(right, contextWithNoExpectedType).getDataFlowInfo();
        ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, right, contextWithNoExpectedType);
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo);
        OverloadResolutionResults<FunctionDescriptor> resolutionResult = contextWithDataFlow.resolveCallWithGivenName(CallMaker.makeCallWithExpressions(callElement, receiver, null, operationSign, Collections.singletonList(left)), operationSign, OperatorConventions.CONTAINS);
        JetType containsType = OverloadResolutionResultsUtil.getResultType(resolutionResult);
        ExpressionTypingUtils.ensureBooleanResult(operationSign, OperatorConventions.CONTAINS, containsType, context);
        if (left != null) {
            dataFlowInfo = this.facade.getTypeInfo(left, contextWithDataFlow).getDataFlowInfo().and(dataFlowInfo);
        }
        return JetTypeInfo.create(resolutionResult.isSuccess() ? KotlinBuiltIns.getInstance().getBooleanType() : null, dataFlowInfo);
    }

    private void ensureNonemptyIntersectionOfOperandTypes(JetBinaryExpression expression, ExpressionTypingContext context) {
        JetType rightType;
        JetExpression left = expression.getLeft();
        if (left == null) {
            return;
        }
        JetExpression right = expression.getRight();
        JetType leftType = this.facade.getTypeInfo(left, context).getType();
        if (leftType != null && right != null && (rightType = this.facade.getTypeInfo(right, context).getType()) != null) {
            if (TypeUtils.isIntersectionEmpty(leftType, rightType)) {
                context.trace.report(Errors.EQUALITY_NOT_APPLICABLE.on(expression, expression.getOperationReference(), leftType, rightType));
            }
            this.checkSenselessComparisonWithNull(expression, left, right, context);
        }
    }

    private void checkSenselessComparisonWithNull(@NotNull JetBinaryExpression expression, @NotNull JetExpression left, @NotNull JetExpression right, @NotNull ExpressionTypingContext context) {
        boolean expressionIsAlways;
        boolean equality;
        JetExpression expr;
        if (JetPsiUtil.isNullConstant(left)) {
            expr = right;
        } else if (JetPsiUtil.isNullConstant(right)) {
            expr = left;
        } else {
            return;
        }
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        JetType type = this.facade.getTypeInfo(expr, context).getType();
        if (type == null || ErrorUtils.isErrorType(type)) {
            return;
        }
        DataFlowValue value = DataFlowValueFactory.INSTANCE.createDataFlowValue(expr, type, context.trace.getBindingContext());
        Nullability nullability = context.dataFlowInfo.getNullability(value);
        boolean bl = equality = operationSign.getReferencedNameElementType() == JetTokens.EQEQ || operationSign.getReferencedNameElementType() == JetTokens.EQEQEQ;
        if (nullability == Nullability.NULL) {
            expressionIsAlways = equality;
        } else if (nullability == Nullability.NOT_NULL) {
            expressionIsAlways = !equality;
        } else {
            return;
        }
        context.trace.report(Errors.SENSELESS_COMPARISON.on(expression, expression, expressionIsAlways));
    }

    protected JetType visitAssignmentOperation(JetBinaryExpression expression, ExpressionTypingContext context) {
        return this.assignmentIsNotAnExpressionError(expression, context);
    }

    protected JetType visitAssignment(JetBinaryExpression expression, ExpressionTypingContext context) {
        return this.assignmentIsNotAnExpressionError(expression, context);
    }

    private JetType assignmentIsNotAnExpressionError(JetBinaryExpression expression, ExpressionTypingContext context) {
        this.facade.checkStatementType(expression, (ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
        context.trace.report(Errors.ASSIGNMENT_IN_EXPRESSION_CONTEXT.on(expression));
        return null;
    }

    @Override
    public JetTypeInfo visitArrayAccessExpression(JetArrayAccessExpression expression, ExpressionTypingContext context) {
        JetTypeInfo typeInfo = this.resolveArrayAccessGetMethod(expression, (ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
        return DataFlowUtils.checkType(typeInfo.getType(), expression, context, typeInfo.getDataFlowInfo());
    }

    @NotNull
    public JetTypeInfo getTypeInfoForBinaryCall(JetScope scope, Name name, ExpressionTypingContext contextWithOldScope, JetBinaryExpression binaryExpression) {
        OverloadResolutionResults<Object> resolutionResults;
        ExpressionTypingContext context = (ExpressionTypingContext)contextWithOldScope.replaceScope(scope);
        JetExpression left = binaryExpression.getLeft();
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        if (left != null) {
            dataFlowInfo = this.facade.getTypeInfo(left, context).getDataFlowInfo();
        }
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo);
        if (left != null) {
            ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, left, context);
            resolutionResults = BasicExpressionTypingVisitor.getResolutionResultsForBinaryCall(scope, name, contextWithDataFlow, binaryExpression, receiver);
        } else {
            resolutionResults = OverloadResolutionResultsImpl.nameNotFound();
        }
        JetExpression right = binaryExpression.getRight();
        if (right != null) {
            dataFlowInfo = this.facade.getTypeInfo(right, contextWithDataFlow).getDataFlowInfo();
        }
        return JetTypeInfo.create(OverloadResolutionResultsUtil.getResultType(resolutionResults), dataFlowInfo);
    }

    @NotNull
    static OverloadResolutionResults<FunctionDescriptor> getResolutionResultsForBinaryCall(JetScope scope, Name name, ExpressionTypingContext context, JetBinaryExpression binaryExpression, ExpressionReceiver receiver) {
        return ((ExpressionTypingContext)context.replaceScope(scope)).resolveCallWithGivenName(CallMaker.makeCall((ReceiverValue)receiver, binaryExpression), binaryExpression.getOperationReference(), name);
    }

    @Override
    public JetTypeInfo visitDeclaration(JetDeclaration dcl, ExpressionTypingContext context) {
        context.trace.report(Errors.DECLARATION_IN_ILLEGAL_CONTEXT.on(dcl));
        return JetTypeInfo.create(null, context.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitRootNamespaceExpression(JetRootNamespaceExpression expression, ExpressionTypingContext context) {
        if (context.expressionPosition == ExpressionPosition.LHS_OF_DOT) {
            return DataFlowUtils.checkType(JetModuleUtil.getRootNamespaceType(expression), expression, context, context.dataFlowInfo);
        }
        context.trace.report(Errors.NAMESPACE_IS_NOT_AN_EXPRESSION.on(expression));
        return JetTypeInfo.create(null, context.dataFlowInfo);
    }

    @Override
    public JetTypeInfo visitStringTemplateExpression(JetStringTemplateExpression expression, ExpressionTypingContext contextWithExpectedType) {
        final ExpressionTypingContext context = (ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        final StringBuilder builder = new StringBuilder();
        final CompileTimeConstant[] value = new CompileTimeConstant[1];
        final DataFlowInfo[] dataFlowInfo = new DataFlowInfo[]{context.dataFlowInfo};
        for (JetStringTemplateEntry entry : expression.getEntries()) {
            entry.accept(new JetVisitorVoid(){

                @Override
                public void visitStringTemplateEntryWithExpression(JetStringTemplateEntryWithExpression entry) {
                    JetExpression entryExpression = entry.getExpression();
                    if (entryExpression != null) {
                        JetTypeInfo typeInfo = BasicExpressionTypingVisitor.this.facade.getTypeInfo(entryExpression, (ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo[0]));
                        dataFlowInfo[0] = typeInfo.getDataFlowInfo();
                    }
                    value[0] = CompileTimeConstantResolver.OUT_OF_RANGE;
                }

                @Override
                public void visitLiteralStringTemplateEntry(JetLiteralStringTemplateEntry entry) {
                    builder.append(entry.getText());
                }

                @Override
                public void visitEscapeStringTemplateEntry(JetEscapeStringTemplateEntry entry) {
                    String text = entry.getText();
                    CompileTimeConstant<?> character = CompileTimeConstantResolver.escapedStringToCharValue(text);
                    if (character instanceof ErrorValue) {
                        context.trace.report(Errors.ILLEGAL_ESCAPE_SEQUENCE.on(entry));
                        value[0] = CompileTimeConstantResolver.OUT_OF_RANGE;
                    } else {
                        builder.append(((CharValue)character).getValue());
                    }
                }
            });
        }
        if (value[0] != CompileTimeConstantResolver.OUT_OF_RANGE) {
            context.trace.record(BindingContext.COMPILE_TIME_VALUE, expression, new StringValue(builder.toString()));
        }
        return DataFlowUtils.checkType(KotlinBuiltIns.getInstance().getStringType(), expression, contextWithExpectedType, dataFlowInfo[0]);
    }

    @Override
    public JetTypeInfo visitAnnotatedExpression(JetAnnotatedExpression expression, ExpressionTypingContext data) {
        JetExpression baseExpression = expression.getBaseExpression();
        if (baseExpression == null) {
            return JetTypeInfo.create(null, data.dataFlowInfo);
        }
        return this.facade.getTypeInfo(baseExpression, data);
    }

    @Override
    public JetTypeInfo visitJetElement(JetElement element, ExpressionTypingContext context) {
        context.trace.report(Errors.UNSUPPORTED.on(element, this.getClass().getCanonicalName()));
        return JetTypeInfo.create(null, context.dataFlowInfo);
    }

    @NotNull
    JetTypeInfo resolveArrayAccessSetMethod(@NotNull JetArrayAccessExpression arrayAccessExpression, @NotNull JetExpression rightHandSide, @NotNull ExpressionTypingContext context, @NotNull BindingTrace traceForResolveResult) {
        return this.resolveArrayAccessSpecialMethod(arrayAccessExpression, rightHandSide, context, traceForResolveResult, false);
    }

    @NotNull
    JetTypeInfo resolveArrayAccessGetMethod(@NotNull JetArrayAccessExpression arrayAccessExpression, @NotNull ExpressionTypingContext context) {
        return this.resolveArrayAccessSpecialMethod(arrayAccessExpression, null, context, context.trace, true);
    }

    @NotNull
    private JetTypeInfo resolveArrayAccessSpecialMethod(@NotNull JetArrayAccessExpression arrayAccessExpression, @Nullable JetExpression rightHandSide, @NotNull ExpressionTypingContext oldContext, @NotNull BindingTrace traceForResolveResult, boolean isGet) {
        JetExpression arrayExpression = arrayAccessExpression.getArrayExpression();
        if (arrayExpression == null) {
            return JetTypeInfo.create(null, oldContext.dataFlowInfo);
        }
        JetTypeInfo arrayTypeInfo = this.facade.getTypeInfo(arrayExpression, oldContext);
        JetType arrayType = arrayTypeInfo.getType();
        if (arrayType == null) {
            return arrayTypeInfo;
        }
        DataFlowInfo dataFlowInfo = arrayTypeInfo.getDataFlowInfo();
        ExpressionTypingContext context = (ExpressionTypingContext)oldContext.replaceDataFlowInfo(dataFlowInfo);
        ExpressionReceiver receiver = new ExpressionReceiver(arrayExpression, arrayType);
        if (!isGet) assert (rightHandSide != null);
        OverloadResolutionResults<FunctionDescriptor> functionResults = context.resolveCallWithGivenName(isGet ? CallMaker.makeArrayGetCall(receiver, arrayAccessExpression, Call.CallType.ARRAY_GET_METHOD) : CallMaker.makeArraySetCall(receiver, arrayAccessExpression, rightHandSide, Call.CallType.ARRAY_SET_METHOD), arrayAccessExpression, Name.identifier(isGet ? "get" : "set"));
        List<JetExpression> indices = arrayAccessExpression.getIndexExpressions();
        if (!indices.isEmpty()) {
            dataFlowInfo = this.facade.getTypeInfo(indices.get(indices.size() - 1), context).getDataFlowInfo();
        }
        if (!isGet) {
            dataFlowInfo = this.facade.getTypeInfo(rightHandSide, (ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo)).getDataFlowInfo();
        }
        if (!functionResults.isSuccess()) {
            traceForResolveResult.report(isGet ? Errors.NO_GET_METHOD.on(arrayAccessExpression) : Errors.NO_SET_METHOD.on(arrayAccessExpression));
            return JetTypeInfo.create(null, dataFlowInfo);
        }
        traceForResolveResult.record(isGet ? BindingContext.INDEXED_LVALUE_GET : BindingContext.INDEXED_LVALUE_SET, arrayAccessExpression, functionResults.getResultingCall());
        return JetTypeInfo.create(functionResults.getResultingDescriptor().getReturnType(), dataFlowInfo);
    }
}

